/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.query.BroadcastQueryTarget;

public class ExcelOutput
extends OutputManager {
    public void printStart() throws IOException {
        this.out.println("<table>");
    }

    public void printEnd() {
        this.out.println("</table>");
    }

    protected void prepareHeaders() {
        String filename_base = this.msg.getValue("form")[0];
        if (filename_base.equals("")) {
            filename_base = "output";
        }
        this.msg.setContentType("application/msexcel");
        this.msg.setHeader("Content-Disposition", "attachment; filename=" + filename_base + ".xls;");
    }

    public void printBody() throws IOException, SQLException {
        float fileSize;
        this.out.println("<tr>");
        for (int p = 0; p < this.niceNames.length; ++p) {
            this.out.println("<th>" + this.niceNames[p] + "</th>");
        }
        this.out.println("</tr>");
        int row_count = 0;
        for (fileSize = 0.0f; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); ++row_count, fileSize += 10.0f) {
            this.out.print("<tr>");
            for (int i = 0; i < this.niceNames.length; ++i) {
                String formattedString = this.rs.getString(i + 1);
                this.out.print("<td>" + formattedString + "</td>");
                try {
                    fileSize += (float)(formattedString.length() + 9);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 13.0f;
                }
            }
            this.out.println("</tr>");
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
    }

    public void printNewResultHeader(BroadcastQueryTarget t) {
        this.out.println("</table><table><tr><th>===>> Data from datasource " + t.getName() + " at: " + t.getUrl());
        this.out.println("</th></tr>");
    }

    public void printLimit() throws IOException {
        this.out.print("<tr><td>");
        super.printLimit();
        this.out.print("<\td><\tr>");
    }
}

