/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.output.HTMLOutput;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.SelectElement;
import org.mitre.mrald.query.SelectElementComparatorByOrder;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.LinkUtils;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

public class HTMLLinkOutput
extends HTMLOutput {
    String datasource = "";
    private List<String> fieldNames = new ArrayList<String>();
    private List<String> tableNames = new ArrayList<String>();

    public void printStart(MsgObject msg) throws ServletException, IOException, SQLException, OutputManagerException {
        int i;
        ArrayList<ParserElement> wkObjects = msg.getWorkingObjects();
        this.datasource = msg.getValue("Datasource")[0];
        ArrayList<SelectElement> list = new ArrayList<SelectElement>();
        for (i = 0; i < wkObjects.size(); ++i) {
            ParserElement wk = wkObjects.get(i);
            if (!(wk instanceof SelectElement)) continue;
            list.add((SelectElement)wk);
        }
        Collections.sort(list, new SelectElementComparatorByOrder());
        for (i = 0; i < list.size(); ++i) {
            this.fieldNames.add(((SelectElement)list.get(i)).getField().toLowerCase());
            this.tableNames.add(((SelectElement)list.get(i)).getTable());
        }
        super.printStart();
    }

    public void printBody() throws IOException, SQLException {
        DBMetaData md = MetaData.getDbMetaData(this.datasource);
        ArrayList<Link> allPkLinks = new ArrayList<Link>();
        ArrayList pkLinks = new ArrayList();
        ArrayList<TableMetaData> tableInfos = new ArrayList<TableMetaData>();
        this.out.print("<table border=\"1\" cellpadding=\"3\"><tbody class=\"output\">");
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            TableMetaData tableInfo = md.getTableMetaData(this.tableNames.get(i));
            if (tableInfo == null) {
                throw new NullPointerException("Can't find metadata for table " + this.tableNames.get(i));
            }
            tableInfos.add(tableInfo);
            pkLinks = (ArrayList)md.getPKLinkData(tableInfo.getName());
            for (int k = 0; k < pkLinks.size(); ++k) {
                Link link;
                if (allPkLinks.contains(pkLinks.get(k)) || !this.fieldNames.contains((link = (Link)pkLinks.get(k)).getPcolumn().toLowerCase()) && !this.fieldNames.contains(link.getFcolumn().toLowerCase())) continue;
                allPkLinks.add(link);
            }
        }
        try {
            if (allPkLinks.size() != 0) {
                StringBuffer headerRow = new StringBuffer("<tr>");
                for (int p = 0; p < this.niceNames.length; ++p) {
                    headerRow.append("<th>" + this.niceNames[p] + "</th>");
                }
                headerRow.append("</tr>");
                this.out.println(headerRow.toString());
                LinkUtils.getLinkTableHtml(this.out, md, allPkLinks, tableInfos, this.rs, this.lineLimitSize, this.mbLimitSize);
            } else {
                super.printBody();
            }
            this.out.println("</tbody></table>");
        }
        catch (MraldException e) {
            throw new MraldError(e, this.msg);
        }
    }
}

