/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;

public class HTMLOutput
extends OutputManager {
    public void printNewResultHeader(BroadcastQueryTarget t) {
        this.out.println("<br/><br/><span style=\"font-size:1.5em;font-weight:bold;text-align:center;\">Data from datasource " + t.getName() + " located at " + t.getUrl());
        this.out.println("</span><br/><br/>");
    }

    public void printStart() throws IOException {
        this.out.print("<html><head>\n" + Config.getProperty("CSS") + "\n</head><body>\n");
        this.out.print("<div id=\"header\"><h1 class=\"headerTitle\">Query Results</h1></div>");
        this.out.print("<script language=\"JavaScript1.2\" type=\"text/javascript\" src=\"");
        this.out.print(Config.getProperty("BaseUrl"));
        this.out.println("/navi.js\"></script>\n");
        this.out.println("<!--\n");
        super.printQuery();
        this.out.println(" -->");
        this.out.println("\n<br/><center>");
    }

    public void printEnd() {
        this.out.println("</center></body></html>");
    }

    protected void prepareHeaders() {
        this.msg.setContentType("text/html");
        this.msg.setHeader("Content-Disposition", "inline;");
    }

    public void printBody() throws IOException, SQLException {
        float fileSize;
        this.out.println("<!--\n");
        super.printQuery();
        this.out.println(" -->");
        StringBuffer headerRow = new StringBuffer("<tr>");
        String funcName = "";
        funcName = this.dbQuery.indexOf("Count") > 0 ? "Count" : (this.dbQuery.indexOf("Count(*)") > 0 ? "Count(*)" : (this.dbQuery.indexOf("Max") > 0 ? "Max" : (this.dbQuery.indexOf("Min") > 0 ? "Min" : "")));
        this.out.println("\n<br/><center>");
        this.out.print("<table border=\"1\" cellpadding=\"3\"><tbody class=\"output\">");
        for (int p = 0; p < this.niceNames.length; ++p) {
            if (this.niceNames[p].equals("")) {
                headerRow.append("<th>" + funcName + "</th>");
                continue;
            }
            headerRow.append("<th>" + this.niceNames[p] + "</th>");
        }
        headerRow.append("</tr>");
        this.out.println(headerRow.toString());
        int row_count = 0;
        boolean even = false;
        for (fileSize = 0.0f; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); fileSize += 10.0f) {
            if (even) {
                this.out.print("<tr class=\"selected\">");
            } else {
                this.out.print("<tr>");
            }
            even = !even;
            for (int i = 0; i < this.niceNames.length; ++i) {
                String formattedString = this.classNames[i].equals("Timestamp") ? this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]) : (this.classNames[i].equals("BigDecimal") ? this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]) : this.rs.getString(i + 1));
                this.out.print("<td>" + formattedString + "</td>");
                try {
                    fileSize += (float)(formattedString.length() + 9);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 13.0f;
                }
            }
            this.out.println("</tr>");
            if ((double)(++row_count) / 1000.0 != (double)((int)((double)row_count / 1000.0))) continue;
            this.out.println("</tbody></table><table border=\"1\" cellpadding=\"3\"><tbody class=\"output\">" + headerRow.toString());
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
        this.out.println("</tbody></table></center>");
    }

    public void printLimit() {
        this.out.println("<center><div class=\"holder\">");
        this.out.print("There were " + this.recordsReturned + " records returned.  ");
        if (this.lineLimitSize == -1) {
            this.out.print("There was no line limit.");
        } else {
            this.out.print("The limit was " + this.lineLimitSize + " lines.");
        }
        this.out.print("  There were approximately " + this.bytesReturned + " bytes returned.  ");
        if (this.mbLimitSize == -1.0f) {
            this.out.print("There was no file size limit.");
        } else {
            this.out.print("The limit was " + this.mbLimitSize + " bytes.  ");
        }
        this.out.println("</div></center>");
        if (this.printQuery) {
            this.printQuery();
        }
    }

    public void printQuery() {
        this.out.println("<br/><br/><center><div class=\"holder\">Query: ");
        this.out.println(MiscUtils.parseTextToHtml(this.dbQuery.toString()));
        this.out.println("</div></center>");
    }
}

