/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.output.ParameterOutput;
import org.mitre.mrald.util.Config;

public class MitreParameterOutput
extends ParameterOutput {
    public MitreParameterOutput() {
        this.dataFileDelimiter = (char)9;
    }

    protected String getDropDown(String classType, int instanceNum, int count, boolean canBeInt) {
        StringBuffer ret = new StringBuffer();
        if (classType.equals("BigDecimal") && canBeInt) {
            ret.append("<option value=\"Type:Continuous\">Continuous</option>\n");
        }
        if (count <= this.maxCategories) {
            ret.append("<option value=\"Type:Nominal\">Nominal Specification (Class)</option>\n");
        }
        ret.append("<option value=\"Type:Ignore\">Ignore</option>\n");
        ret.append("<option value=\"Type:Ordered\">Ordered</option>\n");
        return ret.toString();
    }

    protected String getFieldDropDown() {
        StringBuffer ret = new StringBuffer();
        for (int p = 0; p < this.niceNames.length; ++p) {
            ret.append("<option value=\"" + this.niceNames[p] + "\">" + this.niceNames[p] + "</option>\n");
        }
        return ret.toString();
    }

    protected String makeDataFile(MsgObject msg) throws ServletException, IOException, SQLException, OutputManagerException {
        float fileSize;
        String fileLocation = msg.getUserId() + System.currentTimeMillis() + ".data";
        File dir = new File(System.getProperty("java.io.tmpdir"));
        if (!dir.exists()) {
            dir.mkdir();
        }
        FileOutputStream fout = new FileOutputStream(new File(System.getProperty("java.io.tmpdir") + "/" + fileLocation));
        int row_count = 0;
        this.initializeSets(this.niceNames.length);
        for (fileSize = 0.0f; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); ++row_count, fileSize += 10.0f) {
            StringBuffer formattedString = new StringBuffer("");
            for (int i = 0; i < this.niceNames.length; ++i) {
                if (!formattedString.toString().equals("")) {
                    formattedString.append(this.dataFileDelimiter);
                }
                String currentValue = this.classNames[i].equals("Timestamp") ? this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]) : (this.classNames[i].equals("BigDecimal") ? this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]) : this.rs.getString(i + 1));
                this.categories[i].add(this.rs.getString(i + 1));
                formattedString.append(currentValue);
                try {
                    fileSize += (float)(formattedString.length() + 9);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 13.0f;
                }
            }
            fout.write(formattedString.toString().getBytes());
            fout.write(Config.NEWLINE.getBytes());
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
        fout.close();
        return System.getProperty("java.io.tmpdir") + "/" + fileLocation;
    }
}

