/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import Zql.ParseException;
import Zql.ZQuery;
import Zql.ZqlJJParser;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.PostgresSource;
import org.mitre.mrald.join.SimpleOptimizer;
import org.mitre.mrald.join.SortMergeJoin;
import org.mitre.mrald.join.Source;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.query.PivotFilter;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiDbOutputManager
extends OutputManager {
    protected String[] datasources;
    protected HashMap<String, String> groupedQueries;
    protected ArrayList<Statement> statements;
    protected ArrayList<Connection> crossDbConns;
    HashMap<String, Statement> querySet = new HashMap();

    @Override
    public void execute(MsgObject msg) throws WorkflowStepException {
        String pivot;
        this.msg = msg;
        this.userID = msg.getUserId();
        this.crossDbConns = new ArrayList();
        this.statements = new ArrayList();
        if (msg.getValue("showQuery")[0].equals("true")) {
            this.printQuery = true;
        }
        if ((pivot = msg.getValue("pivot")[0]).length() > 0) {
            this.doPivot = true;
            this.pivotPieces = PivotFilter.parse(pivot);
        }
        try {
            String outStr = msg.getValue("outputSize")[0];
            if (outStr.equals("lines")) {
                outStr = msg.getValue("outputLinesCount")[0];
                outStr = outStr == null ? "-1" : outStr;
                this.setLineLimitSize(new Integer(outStr));
            } else if (outStr.equals("mb")) {
                outStr = msg.getValue("outputMBSize")[0];
                outStr = outStr == null ? "-1" : outStr;
                this.setMbLimitSize(new Float(outStr).floatValue());
            }
        }
        catch (NumberFormatException nfe) {
            MraldOutFile.logToFile(nfe);
        }
        try {
            this.dbQueries = msg.getQuery();
            if (this.dbQueries[0].equals("")) {
                throw new WorkflowStepException("Error in Output Manager: There was no SQL query.");
            }
            this.datasources = msg.getValue("Datasource");
            if (this.datasources[0].equals("")) {
                this.datasources[0] = "main";
            }
            this.dbQuery = this.dbQueries[0];
            if (this.datasources.length > 1) {
                this.groupedQueries = this.groupQueries(this.datasources, this.dbQueries);
            } else {
                this.groupedQueries = new HashMap();
                this.groupedQueries.put(this.datasources[0], this.dbQueries[0]);
            }
            for (String ds : this.groupedQueries.keySet()) {
                Connection dbConn = new MraldConnection(ds, msg).getConnection();
                String query = this.groupedQueries.get(ds);
                Statement statement = dbConn.createStatement();
                this.querySet.put(query, statement);
                this.crossDbConns.add(dbConn);
                this.statements.add(statement);
            }
            this.prepareHeaders();
            this.runUserQuery();
            this.formatOutput();
            this.out.close();
            this.closeStatements();
            this.freeConnection();
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
            try {
                this.conn.close();
            }
            catch (Exception se) {
                MraldOutFile.logToFile(e);
            }
            throw new MraldError(e, msg);
        }
    }

    private HashMap<String, String> groupQueries(String[] datasources, String[] queries) {
        HashMap<String, String> groupedQueries = new HashMap<String, String>();
        for (String ds : datasources) {
            DBMetaData md = MetaData.getDbMetaData(ds);
            Properties props = md.getDbProps();
            String schema = props.getProperty("SCHEMA");
            String sidName = props.getProperty("DBNAME");
            String sidNameSchema = sidName + "." + schema;
            for (String query : queries) {
                if (query.indexOf(sidNameSchema) <= 0) continue;
                groupedQueries.put(ds, query);
            }
        }
        return groupedQueries;
    }

    @Override
    public void runUserQuery() {
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MultiDbOutputManager: runUserQuery : Start");
        try {
            this.runCrossDbQuery();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void runCrossDbQuery() throws ParseException, SQLException {
        HashMap<String, Statement> qry2stmt = this.querySet;
        String[] links = this.extractLinks();
        HashSet<String> dbnames = MultiDbOutputManager.extractDBnames(links);
        HashMap<String, String> dbname2qry = MultiDbOutputManager.bindDBnames2queries(qry2stmt, dbnames);
        assert (dbname2qry.size() <= 2);
        CrossDBInfo info = MultiDbOutputManager.extractQueryInfo(qry2stmt, dbnames, dbname2qry, links.length);
        MultiDbOutputManager.populateJoinColumns(links, info);
        Join join = SimpleOptimizer.chooseJoinAlgorithm(info.outerSrc, info.innerSrc, info.outerCols, info.innerCols, true);
        this.rs = join.execute();
    }

    private static CrossDBInfo extractQueryInfo(HashMap<String, Statement> qry2stmt, HashSet<String> dbnames, HashMap<String, String> dbname2qry, int numCols) throws ParseException {
        CrossDBInfo result = new CrossDBInfo(numCols);
        for (String dbname : dbnames) {
            String sql = dbname2qry.get(dbname);
            Statement stmt = qry2stmt.get(sql);
            if (!(sql = sql.replaceAll(dbname + "\\.", "")).contains(";")) {
                sql = sql + ";";
            }
            PostgresSource src = new PostgresSource(stmt, sql);
            ZQuery query = new ZqlJJParser((Reader)new StringReader(sql)).QueryStatement();
            Vector selectCols = query.getSelect();
            if (result.outerSrc == null) {
                result.outerSrc = src;
                result.outerName = dbname;
                result.outerSelect = selectCols;
                continue;
            }
            result.innerSrc = src;
            result.innerName = dbname;
            result.innerSelect = selectCols;
        }
        return result;
    }

    private static HashMap<String, String> bindDBnames2queries(HashMap<String, Statement> qry2stmt, HashSet<String> dbnames) {
        HashMap<String, String> dbname2qry = new HashMap<String, String>();
        for (String dbname : dbnames) {
            for (String sql : qry2stmt.keySet()) {
                if (!sql.contains(dbname + ".")) continue;
                if (dbname2qry.containsKey(dbname)) {
                    throw new IllegalStateException("Ambiguous name: " + dbname);
                }
                dbname2qry.put(dbname, sql);
            }
        }
        return dbname2qry;
    }

    private static HashSet<String> extractDBnames(String[] links) {
        HashSet<String> dbnames = new HashSet<String>();
        for (int i = 0; i < links.length; ++i) {
            String[] linkelements = links[i].split("~");
            for (int j = 0; j < linkelements.length; ++j) {
                String[] split = linkelements[j].split(":");
                if (!split[0].endsWith("Link")) continue;
                dbnames.add(split[1].split("\\.")[0]);
            }
        }
        return dbnames;
    }

    private String[] extractLinks() {
        String link;
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MultiDbOutputManager: extractLInks : Start");
        ArrayList<String> tmpLinks = new ArrayList<String>();
        int link_num = 1;
        while ((link = this.msg.getValue("DbCrossLink" + link_num)[0]) != "") {
            tmpLinks.add(link);
            ++link_num;
        }
        String[] links = new String[tmpLinks.size()];
        links = tmpLinks.toArray(links);
        return links;
    }

    private void closeStatements() throws SQLException {
        if (this.statements == null) {
            return;
        }
        for (Statement statement : this.statements) {
            if (statement != null) {
                statement.close();
            }
            this.statements.remove(statement);
        }
    }

    @Override
    public void freeConnection() throws OutputManagerException {
        try {
            this.niceNames = null;
            this.formats = null;
            this.classNames = null;
            this.rs = null;
            this.closeStatements();
            if (this.crossDbConns == null) {
                return;
            }
            for (Connection connection : this.crossDbConns) {
                if (connection != null) {
                    connection.close();
                }
                this.crossDbConns.remove(connection);
            }
        }
        catch (SQLException e) {
            OutputManagerException thisOutputMangerException = new OutputManagerException(e.getMessage());
            throw thisOutputMangerException;
        }
    }

    private static void populateJoinColumns(String[] links, CrossDBInfo info) {
        for (int i = 0; i < links.length; ++i) {
            String[] linkelements = links[i].split("~");
            block1: for (int j = 0; j < linkelements.length; ++j) {
                int k;
                String[] split = linkelements[j].split(":");
                if (!split[0].endsWith("Link")) continue;
                int dot = split[1].indexOf(46);
                String dbname = split[1].substring(0, dot);
                String field = split[1].substring(dot + 1);
                if (dbname.equals(info.outerName)) {
                    for (k = 0; k < info.outerSelect.size(); ++k) {
                        if (!info.outerSelect.get(k).toString().equals(field)) continue;
                        info.outerCols[i] = k + 1;
                        continue block1;
                    }
                    continue;
                }
                if (!dbname.equals(info.innerName)) continue;
                for (k = 0; k < info.innerSelect.size(); ++k) {
                    if (!info.innerSelect.get(k).toString().equals(field)) continue;
                    info.innerCols[i] = k + 1;
                    continue block1;
                }
            }
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException, ParseException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Class.forName("org.postgresql.Driver");
        Connection db1 = DriverManager.getConnection("jdbc:postgresql://localhost:5432/dils0", "postgres", "postgres");
        Statement stmt1 = db1.createStatement();
        String sql1 = "select dils0.public.organism.organism_id, dils0.public.organism.species, dils0.public.organism.dob, dils0.public.organism.gender from dils0.public.organism";
        Connection db2 = DriverManager.getConnection("jdbc:postgresql://localhost:5432/movies", "postgres", "postgres");
        Statement stmt2 = db2.createStatement();
        String sql2 = "select movies.public.ratings.userid, movies.public.ratings.movieid, movies.public.ratings.rating from movies.public.ratings where movies.public.ratings.userid < 10000 and movies.public.ratings.rating >= 4";
        HashMap<String, Statement> qry2stmt = new HashMap<String, Statement>();
        qry2stmt.put(sql1, stmt1);
        qry2stmt.put(sql2, stmt2);
        String[] links = new String[]{"PrimaryLink:dils0.public.organism.organism_id~SecondaryLink:movies.public.ratings.userid~SqlThread:-1"};
        HashSet<String> dbnames = MultiDbOutputManager.extractDBnames(links);
        HashMap<String, String> dbname2qry = MultiDbOutputManager.bindDBnames2queries(qry2stmt, dbnames);
        assert (dbname2qry.size() <= 2);
        CrossDBInfo info = MultiDbOutputManager.extractQueryInfo(qry2stmt, dbnames, dbname2qry, links.length);
        System.out.println(info.outerName + ":" + info.outerSrc.sql);
        System.out.println(info.innerName + ":" + info.innerSrc.sql);
        MultiDbOutputManager.populateJoinColumns(links, info);
        SortMergeJoin join = new SortMergeJoin(info.outerSrc, info.innerSrc, info.outerCols, info.innerCols);
        ResultSet rs = ((Join)join).execute();
        Source.print(rs);
        System.out.println("Done");
    }

    public static class CrossDBInfo {
        protected Source outerSrc = null;
        protected Source innerSrc = null;
        protected String outerName = null;
        protected String innerName = null;
        protected Vector outerSelect = null;
        protected Vector innerSelect = null;
        protected int[] outerCols;
        protected int[] innerCols;

        protected CrossDBInfo(int numCols) {
            this.outerCols = new int[numCols];
            this.innerCols = new int[numCols];
        }
    }
}

