/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.output.OutputControllerException;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;

public class OutputController
extends AbstractStep {
    protected static ArrayList<Object> keys = new ArrayList();
    protected static Properties currentClasses;
    protected static PropertyChangeListener pcl;
    protected static String propertyName;
    protected MsgObject messageObject = new MsgObject();

    public OutputController() {
        propertyName = "outputProps";
    }

    public OutputController(MsgObject thisMessage) {
        propertyName = "outputProps";
        this.messageObject = thisMessage;
    }

    protected static void init() {
        OutputController.loadProperties();
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                OutputController.loadProperties();
            }
        };
    }

    protected static void loadProperties() {
        currentClasses = MiscUtils.loadProperties(Config.getProperty(propertyName));
        Enumeration<?> eKeys = currentClasses.propertyNames();
        while (eKeys.hasMoreElements()) {
            keys.add(eKeys.nextElement());
        }
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        if (currentClasses == null) {
            OutputController.init();
            Config.addPropertyChangeListener(pcl);
        }
        try {
            this.messageObject = msgObject;
            this.processOutput();
        }
        catch (OutputControllerException e) {
            MiscUtils.handleException(msgObject, e, true);
        }
    }

    public void processOutput() throws WorkflowStepException, OutputControllerException {
        String[] returnFormatType = this.messageObject.getValue("Format");
        String returnFormat = returnFormatType[0];
        OutputManager outputType = this.castElement(returnFormat);
        outputType.execute(this.messageObject);
    }

    protected OutputManager castElement(String currentName) throws OutputControllerException {
        String className = null;
        try {
            className = this.getElementType(currentName);
            if (className == null) {
                return null;
            }
            Class<?> classDefinition = Class.forName(className);
            OutputManager outputType = (OutputManager)classDefinition.newInstance();
            return outputType;
        }
        catch (InstantiationException wfe) {
            throw new OutputControllerException(wfe);
        }
        catch (ClassNotFoundException cne) {
            MraldOutFile.logToFile(cne);
        }
        catch (IllegalAccessException iae) {
            throw new OutputControllerException(iae);
        }
        throw new MraldError("Couldn't find an OutputManager mapped to " + currentName);
    }

    protected String getElementType(String classType) throws OutputControllerException {
        for (int i = 0; i < keys.size(); ++i) {
            if (!classType.startsWith((String)keys.get(i))) continue;
            return (String)currentClasses.get(keys.get(i));
        }
        throw new NullPointerException("An class type of " + classType + " is not recognized.  Please check the class type in the form and the appropriate properties file.");
    }

    static {
        propertyName = "";
    }
}

