/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.query.BroadcastQuery;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.query.PivotFilter;
import org.mitre.mrald.query.PivotedResultSet;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.JdbcPropertyPublisher;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

public abstract class OutputManager
extends AbstractStep {
    protected float bytesReturned = 0.0f;
    protected String[] classNames;
    protected Connection conn = null;
    protected String[] dbQueries;
    protected String dbQuery = null;
    protected String datasource;
    protected int fetchSize = 0;
    protected String[] formats;
    protected int lineLimitSize = -1;
    protected float mbLimitSize = -1.0f;
    protected String[] niceNames;
    protected int recordsReturned = 0;
    protected ResultSet rs = null;
    protected SQLException sqlExceptionMessage;
    protected Statement stmt = null;
    protected PreparedStatement prepStmt;
    protected String userID;
    protected boolean printQuery = false;
    protected boolean doPivot = false;
    protected String[] pivotPieces;
    protected Thread t;
    protected PrintWriter out;
    protected MsgObject msg;
    protected boolean firstTime = true;

    public void setLineLimitSize(int userSpecifiedLimitOnLines) {
        this.lineLimitSize = userSpecifiedLimitOnLines;
    }

    public void setMbLimitSize(float userSpecifiedLimitOnSize) {
        this.mbLimitSize = userSpecifiedLimitOnSize * 1000000.0f;
    }

    public int getLineLimitSize() {
        return this.lineLimitSize;
    }

    public float getMbLimitSize() {
        return this.mbLimitSize;
    }

    public ResultSet getQryResultsinRS() {
        return this.rs;
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
        String pivot;
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "OutputManager: execute: start");
        this.msg = msg;
        this.userID = msg.getUserId();
        if (msg.getValue("showQuery")[0].equals("true")) {
            this.printQuery = true;
        }
        if ((pivot = msg.getValue("pivot")[0]).length() > 0) {
            this.doPivot = true;
            this.pivotPieces = PivotFilter.parse(pivot);
        }
        try {
            String outStr = msg.getValue("outputSize")[0];
            if (outStr.equals("lines")) {
                outStr = msg.getValue("outputLinesCount")[0];
                outStr = outStr == null ? "-1" : outStr;
                this.setLineLimitSize(new Integer(outStr));
            } else if (outStr.equals("mb")) {
                outStr = msg.getValue("outputMBSize")[0];
                outStr = outStr == null ? "-1" : outStr;
                this.setMbLimitSize(new Float(outStr).floatValue());
            }
        }
        catch (NumberFormatException nfe) {
            MraldOutFile.logToFile(nfe);
        }
        try {
            this.dbQueries = msg.getQuery();
            if (this.dbQueries[0].equals("")) {
                throw new WorkflowStepException("Error in Output Manager: There was no SQL query.");
            }
            Properties props = new Properties();
            props.put("SetBigStringTryClob", "true");
            JdbcPropertyPublisher.populateProperties(msg.getReq(), props);
            this.datasource = msg.getValue("Datasource")[0];
            if (this.datasource.equals("")) {
                this.datasource = "main";
            }
            this.conn = new MraldConnection(this.datasource, msg).getConnection();
            this.stmt = this.conn.createStatement();
            this.prepareHeaders();
            for (int i = 0; i < this.dbQueries.length; ++i) {
                this.dbQuery = this.dbQueries[i];
                this.runUserQuery();
                this.formatOutput();
            }
            this.out.close();
            this.stmt.close();
            this.freeConnection();
            String test = msg.getValue("CrossLink1")[0].toString();
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "OutputManager: execute " + test);
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
            try {
                this.conn.close();
            }
            catch (Exception se) {
                MraldOutFile.logToFile(e);
            }
            throw new MraldError(e, msg);
        }
    }

    public void freeConnection() throws OutputManagerException {
        try {
            this.niceNames = null;
            this.formats = null;
            this.classNames = null;
            this.stmt = null;
            this.rs = null;
            this.conn.close();
        }
        catch (SQLException e) {
            OutputManagerException thisOutputMangerException = new OutputManagerException(e.getMessage());
            throw thisOutputMangerException;
        }
    }

    protected void printQuery() {
        this.out.println("Query: " + this.dbQuery);
    }

    public ResultSet returnResultsToUser() {
        return this.rs;
    }

    public void runUserQuery() {
        try {
            StringBuffer logInfo = new StringBuffer();
            long startTime = MiscUtils.logQuery(this.userID, this.datasource, this.dbQuery, logInfo);
            if (this.dbQuery.startsWith("U")) {
                this.stmt.executeUpdate(this.dbQuery);
            } else {
                MraldOutFile.appendToFile(Config.getProperty("LOGFILE"), "OutputManager: RunUserQuery: About to execute the following query " + this.dbQuery);
                this.rs = this.stmt.executeQuery(this.dbQuery);
                MraldOutFile.appendToFile(Config.getProperty("LOGFILE"), "OutputManager: RunUserQuery: Executed the following query " + this.dbQuery);
                if (this.doPivot) {
                    this.rs = new PivotedResultSet(this.rs, this.pivotPieces);
                }
            }
            MiscUtils.logQueryRun(startTime, logInfo);
        }
        catch (SQLException se) {
            try {
                this.prepStmt = this.conn.prepareStatement(this.dbQuery);
                this.rs = this.prepStmt.executeQuery();
            }
            catch (SQLException sqe) {
                try {
                    this.prepStmt.close();
                    this.stmt.close();
                    this.conn.close();
                }
                catch (Exception e) {
                    MraldOutFile.logToFile(e);
                }
                throw new MraldError(se, this.msg);
            }
        }
    }

    protected void setDBFormats() {
    }

    protected String getAndFormat(BigDecimal number, String format) {
        if (number == null) {
            return "null";
        }
        if (format.equals("")) {
            return number.toString();
        }
        DecimalFormat df = new DecimalFormat(format);
        return df.format(number);
    }

    protected String getAndFormat(Timestamp date, String format) {
        if (date == null) {
            return "null";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    protected BigDecimal getBigDecimal(String number) {
        return new BigDecimal(number);
    }

    protected Date getTimestamp(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat();
        return df.parse(date);
    }

    protected MsgObject groupNVPairs(MsgObject msg) throws MsgObjectException {
        Iterator<String> nvNames = msg.getNames().iterator();
        MsgObject returnObject = new MsgObject();
        int outputFormats = 0;
        while (nvNames.hasNext()) {
            String currentName = nvNames.next();
            if (!currentName.toLowerCase().startsWith("outputformat")) continue;
            String[] values = msg.getValue(currentName);
            StringBuffer ret = new StringBuffer(values[0]);
            for (int i = 1; i < values.length; ++i) {
                ret.append("~" + values[i]);
            }
            returnObject.setValue(Integer.toString(outputFormats), ret.toString());
            ++outputFormats;
        }
        return returnObject;
    }

    protected MsgObject parseNVPairs(String parseString) {
        MsgObject nameValues = new MsgObject();
        StringTokenizer valueTokens = new StringTokenizer(parseString, "~");
        while (valueTokens.hasMoreTokens()) {
            String pair = valueTokens.nextToken();
            int split = pair.indexOf(":");
            String name = pair.substring(0, split);
            String value = pair.substring(split + 1, pair.length());
            nameValues.setValue(name, value);
        }
        return nameValues;
    }

    public void formatOutput() throws MraldException {
        try {
            if (this.firstTime) {
                this.msg.SetOutPrintWriter();
                this.out = this.msg.getOutPrintWriter();
                this.getFormatInfo();
                this.prepareHeaders();
                this.printStart();
                this.firstTime = false;
            }
            this.printBody();
            this.printLimit();
            if (this.msg.getValue("broadcastQuery")[0].equals("true")) {
                BroadcastQuery.processBroadcast(this.msg, this);
            }
            this.printEnd();
        }
        catch (SQLException e) {
            throw new MraldException(e, this.msg);
        }
        catch (IOException e) {
            throw new MraldException(e, this.msg);
        }
    }

    protected abstract void prepareHeaders() throws OutputManagerException;

    protected void printStart() throws IOException, SQLException {
    }

    protected void printHeaders() throws IOException, SQLException {
    }

    public abstract void printBody() throws IOException, SQLException;

    public void printLimit() throws IOException {
        this.out.print("There were " + this.recordsReturned + " records returned.  ");
        if (this.lineLimitSize == -1) {
            this.out.print("There was no line limit.");
        } else {
            this.out.print("The limit was " + this.lineLimitSize + " lines.");
        }
        this.out.print("  There were approximately " + this.bytesReturned + " bytes returned.  ");
        if (this.mbLimitSize == -1.0f) {
            this.out.println("There was no file size limit.");
        } else {
            this.out.println("The limit was " + this.mbLimitSize + " bytes.  ");
        }
        if (this.printQuery) {
            this.printQuery();
        }
    }

    protected void printEnd() throws IOException, SQLException {
    }

    public abstract void printNewResultHeader(BroadcastQueryTarget var1);

    protected void getFormatInfo() throws MsgObjectException, SQLException {
        ResultSetMetaData md = this.rs.getMetaData();
        int count = md.getColumnCount();
        this.niceNames = new String[count];
        this.formats = new String[count];
        this.classNames = new String[count];
        for (int i = 0; i < count; ++i) {
            this.niceNames[i] = md.getColumnName(i + 1);
            try {
                this.classNames[i] = md.getColumnClassName(i + 1);
                continue;
            }
            catch (AbstractMethodError e) {
                this.classNames[i] = md.getColumnTypeName(i + 1);
            }
        }
        this.setDBFormats();
        MsgObject outputFormats = this.groupNVPairs(this.msg);
        for (String currentName : outputFormats.getNames()) {
            MsgObject thisFormat = this.parseNVPairs(outputFormats.getValue(currentName)[0]);
            String thisFieldName = thisFormat.getValue("fieldname")[0];
            String thisNiceName = thisFormat.getValue("nicename")[0];
            String thisFormatType = thisFormat.getValue("type")[0];
            String thisFormatPattern = thisFormat.getValue("formatpattern")[0];
            for (int i = 0; i < this.niceNames.length; ++i) {
                if (!thisFieldName.equalsIgnoreCase(this.niceNames[i]) && (!this.doPivot || i < this.niceNames.length - 2 || !thisFieldName.equalsIgnoreCase(((PivotedResultSet)md).getValueColumnName()))) continue;
                if (!(thisNiceName.equals("") || this.doPivot && i >= this.niceNames.length - 2)) {
                    this.niceNames[i] = thisNiceName;
                }
                if (thisFormatType.equals("") && thisFormatPattern.equals("")) continue;
                this.classNames[i] = thisFormatType.toLowerCase().startsWith("da") || thisFormatType.startsWith("TIME") ? "Timestamp" : (thisFormatType.toLowerCase().startsWith("num") || thisFormatType.startsWith("BIGINT") || thisFormatType.startsWith("DECIMAL") || thisFormatType.startsWith("DOUBLE") || thisFormatType.startsWith("FLOAT") || thisFormatType.startsWith("INTEGER") || thisFormatType.startsWith("NUMERIC") || thisFormatType.startsWith("SMALLINT") || thisFormatType.startsWith("TINYINT") ? "BigDecimal" : (thisFormatType.toLowerCase().startsWith("flo") ? "BigDecimal" : thisFormatType));
                this.formats[i] = thisFormatPattern;
            }
        }
    }

    public void setResultSet(ResultSet rs) {
        this.rs = rs;
    }

    public void setQuery(String query) {
        this.dbQuery = query;
    }
}

