/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.parser.MraldParserException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldOutFile;

public class MraldParser
extends AbstractStep {
    private static Properties buildables;
    private static ArrayList<Object> keys;
    private static PropertyChangeListener pcl;
    private ArrayList<ParserElement> qeList = new ArrayList();

    protected static void init() {
        MraldParser.loadProperties();
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MraldParser.loadProperties();
            }
        };
    }

    protected static void loadProperties() {
        buildables = MiscUtils.loadProperties(Config.getProperty("parserProps"));
        Enumeration<?> eKeys = buildables.propertyNames();
        while (eKeys.hasMoreElements()) {
            keys.add(eKeys.nextElement());
        }
    }

    public static void setBuildables(Properties buildables) {
        MraldParser.buildables = buildables;
        Enumeration<?> eKeys = buildables.propertyNames();
        while (eKeys.hasMoreElements()) {
            keys.add(eKeys.nextElement());
        }
    }

    public Properties getBuildables() {
        return buildables;
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            if (buildables == null) {
                MraldParser.init();
                Config.addPropertyChangeListener(pcl);
            }
            this.processNvPairs(msgObject);
            this.qeList.addAll(msgObject.getWorkingObjects());
            msgObject.setWorkingObjects(this.qeList);
        }
        catch (MraldParserException e) {
            try {
                msgObject.SetOutPrintWriter();
                msgObject.setContentType("text/html");
                MiscUtils.handleException(msgObject, e, true);
            }
            catch (MsgObjectException msge) {
                throw new WorkflowStepException(msge.getMessage());
            }
        }
    }

    private static String getElementType(String currentName) throws MraldParserException {
        for (int i = 0; i < keys.size(); ++i) {
            if (!currentName.startsWith((String)keys.get(i))) continue;
            return (String)buildables.get(keys.get(i));
        }
        return null;
    }

    public static ParserElement castElement(String currentName) throws MraldParserException {
        String className = MraldParser.getElementType(currentName);
        try {
            if (className == null) {
                return null;
            }
            Class<?> classDefinition = Class.forName(className);
            ParserElement parserElement = (ParserElement)classDefinition.newInstance();
            return parserElement;
        }
        catch (InstantiationException wfe) {
            MraldParserException ce = new MraldParserException("InstantiationException" + wfe.getMessage());
            throw ce;
        }
        catch (ClassNotFoundException cne) {
            MraldOutFile.logToFile(cne);
        }
        catch (IllegalAccessException iae) {
            MraldParserException ce = new MraldParserException("Illegal access exception" + iae.getMessage());
            throw ce;
        }
        return null;
    }

    private void processNvPairs(MsgObject msg) throws MraldParserException {
        try {
            block2: while (true) {
                for (String currentName : new TreeSet<String>(msg.getNames())) {
                    ParserElement parserElement = MraldParser.castElement(currentName);
                    if (parserElement == null) continue;
                    currentName = parserElement.preProcess(msg, currentName);
                    parserElement.process(msg.getValue(currentName));
                    currentName = parserElement.postProcess(msg, currentName);
                    msg.removeValue(currentName);
                    if (!parserElement.getIsActive()) continue;
                    this.qeList.add(parserElement);
                    continue block2;
                }
                break;
            }
        }
        catch (MraldParserException e) {
            MraldParserException thisException = new MraldParserException(e.getMessage());
            throw thisException;
        }
    }

    static {
        keys = new ArrayList();
    }
}

