/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPivotFilter
extends SqlElements {
    public static final int ENTITY_TABLE = 0;
    public static final int ENTITY_FIELD = 1;
    public static final int ENTITY_TYPE = 2;
    public static final int ATTRIBUTE_TABLE = 3;
    public static final int ATTRIBUTE_FIELD = 4;
    public static final int ATTRIBUTE_TYPE = 5;
    public static final int VALUE_TABLE = 6;
    public static final int VALUE_FIELD = 7;
    public static final int VALUE_TYPE = 8;

    public AbstractPivotFilter() throws MraldException {
        this.elementType = "Filter";
    }

    public AbstractPivotFilter(MsgObject msg) throws MraldException {
        super(msg);
        this.elementType = "Filter";
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) throws MraldException {
        return currentSelectList;
    }

    protected void buildOuter(StringBuffer clause) {
        String entityTable = this.nameValues.getValue("EntityTable")[0];
        String entityField = this.nameValues.getValue("EntityField")[0];
        clause.append(entityTable).append(".").append(entityField).append(" IN ");
    }

    protected void buildValue(StringBuffer clause, String which, String value, boolean useParens) {
        String delimiter;
        String type = this.nameValues.getValue(which + "Type")[0];
        String string = type.equals("Numeric") ? "" : (delimiter = type.equals("Date") ? "#" : "'");
        if (useParens) {
            clause.append("(");
        }
        clause.append(delimiter);
        clause.append(value);
        clause.append(delimiter);
        if (useParens) {
            clause.append(")");
        }
    }

    public static void buildEAVinfo(StringBuffer result, String[] pieces) {
        result.append("~");
        result.append("EntityTable");
        result.append(":");
        result.append(pieces[0]);
        result.append("~");
        result.append("EntityField");
        result.append(":");
        result.append(pieces[1]);
        result.append("~");
        result.append("EntityType");
        result.append(":");
        result.append(pieces[2]);
        result.append("~");
        result.append("AttributeTable");
        result.append(":");
        result.append(pieces[3]);
        result.append("~");
        result.append("AttributeField");
        result.append(":");
        result.append(pieces[4]);
        result.append("~");
        result.append("AttributeType");
        result.append(":");
        result.append(pieces[5]);
        result.append("~");
        result.append("ValueTable");
        result.append(":");
        result.append(pieces[6]);
        result.append("~");
        result.append("ValueField");
        result.append(":");
        result.append(pieces[7]);
        result.append("~");
        result.append("ValueType");
        result.append(":");
        result.append(pieces[8]);
    }

    public static String[] parse(String pivot) {
        return pivot.split("~");
    }
}

