/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.Broadcast;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.query.LinkElement;
import org.mitre.mrald.query.QueryBuilder;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;

class BroadcastManager {
    protected List<Future<ResultSet>> workingBroadcasts = new ArrayList<Future<ResultSet>>();
    protected List<Future<ResultSet>> doneBroadcasts = null;
    protected Map<Future<ResultSet>, BroadcastQueryTarget> sources = new HashMap<Future<ResultSet>, BroadcastQueryTarget>();
    protected Map<Future<ResultSet>, String> queries = new HashMap<Future<ResultSet>, String>();
    protected ExecutorService executer = Executors.newCachedThreadPool();

    BroadcastManager() {
    }

    public void add(BroadcastQueryTarget target) {
        String query = "";
        MsgObject msg = new MsgObject();
        msg.setWorkingObjects(new ArrayList<ParserElement>(Arrays.asList(target.getSqlElements())));
        msg.setLinks(new ArrayList<LinkElement>(Arrays.asList(target.getLinkElements())));
        QueryBuilder builder = new QueryBuilder(msg);
        try {
            builder.buildQueryComponents(msg.getWorkingObjects());
            query = builder.buildQuery();
        }
        catch (Throwable t) {
            MraldOutFile.logToFile(t);
            return;
        }
        Broadcast doer = new Broadcast(target.getUrl(), target.getRemoteDatasource(), query);
        Future p = this.executer.submit(doer);
        this.workingBroadcasts.add(p);
        this.sources.put(p, target);
        this.queries.put(p, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDone() {
        this.doneBroadcasts = new ArrayList<Future<ResultSet>>();
        List<Future<ResultSet>> list = this.workingBroadcasts;
        synchronized (list) {
            for (Future<ResultSet> future : this.workingBroadcasts) {
                if (!future.isDone()) continue;
                this.doneBroadcasts.add(future);
            }
            this.workingBroadcasts.removeAll(this.doneBroadcasts);
        }
    }

    public void processWithOuputManager(MsgObject msg, OutputManager output) {
        int waitTime = 0;
        int maxWaitTime = 0;
        String max = Config.getProperty("broadcastWaitSeconds");
        try {
            maxWaitTime = Integer.parseInt(max);
        }
        catch (Exception e) {
            maxWaitTime = 60;
        }
        this.checkDone();
        while (this.workingBroadcasts.size() + this.doneBroadcasts.size() > 0 && waitTime < maxWaitTime) {
            for (Future<ResultSet> future : this.doneBroadcasts) {
                try {
                    ResultSet rs = future.get();
                    if (rs == null) continue;
                    output.setResultSet(rs);
                    output.setQuery(this.queries.get(future));
                    output.printNewResultHeader(this.sources.get(future));
                    output.printBody();
                    output.printLimit();
                }
                catch (Throwable e) {
                    MraldOutFile.logToFile(e);
                }
            }
            if (this.workingBroadcasts.size() > 0) {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                waitTime += 2;
            }
            this.checkDone();
        }
    }
}

