/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.query.BroadcastManager;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.query.BroadcastTargetProvider;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastQuery {
    private static PropertyChangeListener pcl;
    private static BroadcastTargetProvider provider;
    public static final Vector userThreads;
    protected static Hashtable<MsgObject, BroadcastManager> activeBroadcasts;

    public static void init() {
        if (pcl == null) {
            pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BroadcastQuery.loadTargets();
                }
            };
            Config.addPropertyChangeListener(pcl);
        }
    }

    protected static void loadTargets() {
        provider.reload();
    }

    public static BroadcastTargetProvider getProvider() {
        try {
            Object p = provider.getClass().newInstance();
            return (BroadcastTargetProvider)p;
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
            return null;
        }
    }

    public static void setProvider(BroadcastTargetProvider _provider) {
        provider = _provider;
        BroadcastQuery.loadTargets();
    }

    public static void doBroadcast(MsgObject msg, List<BroadcastQueryTarget> targetList) {
        try {
            BroadcastManager manager = new BroadcastManager();
            for (BroadcastQueryTarget target : targetList) {
                try {
                    manager.add(target);
                }
                catch (Throwable t) {
                    MraldOutFile.logToFile(t);
                }
            }
            activeBroadcasts.put(msg, manager);
        }
        catch (Throwable t) {
            MraldOutFile.logToFile(t);
            return;
        }
    }

    public static void processBroadcast(MsgObject msg, OutputManager output) {
        BroadcastManager manager = activeBroadcasts.get(msg);
        manager.processWithOuputManager(msg, output);
    }

    static {
        provider = null;
        userThreads = new Vector();
        activeBroadcasts = new Hashtable();
    }
}

