/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.query.FilterElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MraldException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareFieldsFilter
extends FilterElement
implements FormBuilderElement {
    public static final String FILTER_NAME = "CompareFieldsFilter";
    public static final String TAG_NAME = "compareFieldsFilter";

    public CompareFieldsFilter() {
        this.elementType = FILTER_NAME;
    }

    public CompareFieldsFilter(MsgObject msg) {
        super(msg);
        this.elementType = FILTER_NAME;
    }

    @Override
    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer list = FBUtils.buildTableFieldDropDown(md, FILTER_NAME, num);
        StringBuffer ret = new StringBuffer();
        ret.append("\n<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">");
        ret.append("<tr>");
        ret.append("<td><strong>Title:</strong></td>");
        ret.append("<td><input name=\"").append(FILTER_NAME);
        ret.append(num);
        ret.append("~label\" type=\"text\" size=\"30\"></td>");
        ret.append("</tr>");
        ret.append("<tr>");
        ret.append("<td><strong>First Field:</strong></td>");
        ret.append("<td>");
        ret.append(list.toString().replaceAll("Table:", "Table1:").replaceAll("Field:", "Field1:"));
        ret.append("</td>");
        ret.append("<td><strong>Operator:</strong></td>");
        ret.append("<td>");
        ret.append(FBUtils.getSimpleOperatorList(FILTER_NAME + num, ""));
        ret.append("</td>");
        ret.append("<td><strong>Second Field:</strong></td>");
        ret.append("<td>");
        ret.append(list.toString().replaceAll("Table:", "Table2:").replaceAll("Field:", "Field2:"));
        ret.append("</td>");
        ret.append("</tr>");
        ret.append("\n</table>");
        return ret.toString();
    }

    @Override
    public Node getFBNode(Document document) {
        String field1 = this.nameValues.getValue("Field1")[0];
        String table1 = this.nameValues.getValue("Table1")[0];
        String operator = this.nameValues.getValue("Operator")[0];
        String field2 = this.nameValues.getValue("Field2")[0];
        String table2 = this.nameValues.getValue("Table2")[0];
        String label = this.nameValues.getValue("label")[0];
        if (table1.equals("") || field1.equals("") || label.equals("") || table2.equals("") || field2.equals("")) {
            return null;
        }
        Element ret = document.createElement(TAG_NAME);
        FBUtils.addTextNode(document, ret, "table1", table1);
        FBUtils.addTextNode(document, ret, "column1", field1);
        FBUtils.addTextNode(document, ret, "operator", operator);
        FBUtils.addTextNode(document, ret, "table2", table2);
        FBUtils.addTextNode(document, ret, "column2", field2);
        FBUtils.addTextNode(document, ret, "label", label);
        return ret;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        String newValue = this.nameValues.getValue("Table1")[0];
        String synValue = this.nameValues.getValue("Synomyn1")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!newValue.equals("") && !currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        newValue = this.nameValues.getValue("Table2")[0];
        synValue = this.nameValues.getValue("Synomyn2")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!newValue.equals("") && !currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        String operator = null;
        String table1 = this.nameValues.getValue("Table1")[0].toString();
        String table2 = this.nameValues.getValue("Table2")[0].toString();
        String synValue = this.nameValues.getValue("Syn1")[0].toString();
        if (!synValue.equals("")) {
            table1 = synValue;
        }
        if (!(synValue = this.nameValues.getValue("Syn2")[0].toString()).equals("")) {
            table2 = synValue;
        }
        String field1 = this.nameValues.getValue("Field1")[0].toString();
        String field2 = this.nameValues.getValue("Field2")[0].toString();
        if (field1.equals("") || field2.equals("") || table1.equals("") || table2.equals("")) {
            return currentWhereList;
        }
        operator = this.nameValues.getValue("Operator")[0];
        if (operator.equals("")) {
            operator = "=";
        }
        String where = table1 + "." + field1 + operator + table2 + "." + field2;
        currentWhereList.add(where);
        return currentWhereList;
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) {
        String check;
        if (this.nameValues.getNames().contains("LookForCheck") && ((check = this.nameValues.getValue("checked")[0]) == null || check.length() == 0)) {
            this.isActive = false;
        }
        return currentName;
    }
}

