/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import org.mitre.mrald.query.Node;

class Edge {
    String qual;
    private boolean needed;
    private Node node1;
    private Node node2;
    private int weight;

    public Edge() {
        this.node1 = null;
        this.node2 = null;
        this.weight = Integer.MAX_VALUE;
        this.needed = false;
        this.qual = null;
    }

    public Edge(Node primaryTable, Node secondaryTable, String qualValue) {
        this.node1 = primaryTable;
        this.node2 = secondaryTable;
        this.weight = 1;
        this.needed = false;
        this.qual = qualValue;
        this.node1.attachEdge(this);
        this.node2.attachEdge(this);
    }

    public void setNeeded(boolean neededVal) {
        this.needed = neededVal;
    }

    public void setNodes(Node newNode1, Node newNode2) {
        this.node1 = newNode1;
        this.node2 = newNode2;
    }

    public void setQual(String qualVal) {
        this.qual = qualVal;
    }

    public void setWeight(int weightVal) {
        this.weight = weightVal;
    }

    public boolean getNeeded() {
        return this.needed;
    }

    public Node[] getNodes() {
        Node[] returnNodes = new Node[]{this.node1, this.node2};
        return returnNodes;
    }

    public String getQual() {
        return this.qual;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Edge edge) {
        return this.getQual().equals(edge.getQual());
    }

    public boolean hasSameNodes(Edge edge) {
        if (this.node1 == edge.getNodes()[0] && this.node2 == edge.getNodes()[1]) {
            return true;
        }
        return this.node1 == edge.getNodes()[1] && this.node2 == edge.getNodes()[0];
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Edge: " + this.qual);
        ret.append("\nWeight: " + this.weight + " Needed: " + this.needed + "\n");
        return ret.toString();
    }
}

