/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.query.SqlElementException;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkElement
extends SqlElements
implements Cloneable {
    private boolean needed = false;
    protected String primaryField;
    protected String primaryTable;
    protected String secondaryField;
    protected String secondaryTable;
    protected String outerJoin = "";

    public LinkElement() {
        this.elementType = "Link";
    }

    public static String buildValue(String primaryTable, String primaryField, String secondaryTable, String secondaryField) {
        StringBuffer ret = new StringBuffer();
        ret.append("PrimaryLink");
        ret.append(":");
        ret.append(primaryTable);
        ret.append(".");
        ret.append(primaryField);
        ret.append("~");
        ret.append("SecondaryLink");
        ret.append(":");
        ret.append(secondaryTable);
        ret.append(".");
        ret.append(secondaryField);
        return ret.toString();
    }

    public void setNeeded(boolean neededVal) {
        this.needed = neededVal;
    }

    public boolean getNeeded() {
        return this.needed;
    }

    public String getPrimaryField() {
        return this.primaryField;
    }

    public String getPrimaryTable() {
        return this.primaryTable;
    }

    public String getQual() {
        String[] tableComps;
        StringBuffer ret = new StringBuffer();
        boolean tableSpace = false;
        if (this.primaryTable.indexOf("\"") == 0 && this.primaryTable.lastIndexOf("\"") == this.primaryTable.length()) {
            tableSpace = true;
        }
        this.table = (tableComps = this.primaryTable.split(" ")).length == 3 ? tableComps[2] : (tableComps.length == 2 ? (tableSpace ? tableComps[0] + " " + tableComps[1] : tableComps[1]) : tableComps[0]);
        ret.append(this.table);
        ret.append(".");
        ret.append(this.primaryField);
        if (this.outerJoin.equals("Left")) {
            ret.append("(+) ");
        }
        ret.append("=");
        tableSpace = this.secondaryTable.indexOf("\"") == 0 && this.secondaryTable.lastIndexOf("\"") == this.secondaryTable.length() - 1;
        tableComps = this.secondaryTable.split(" ");
        this.table = tableComps.length == 3 ? tableComps[2] : (tableComps.length == 2 ? (tableSpace ? tableComps[0] + " " + tableComps[1] : tableComps[1]) : tableComps[0]);
        ret.append(this.table);
        ret.append(".");
        ret.append(this.secondaryField);
        if (this.outerJoin.equals("Right")) {
            ret.append("(+) ");
        }
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "LinkElement: getQual: " + ret.toString());
        return ret.toString();
    }

    public String getSecondaryField() {
        return this.secondaryField;
    }

    public String getSecondaryTable() {
        return this.secondaryTable;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) throws MraldException {
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        return currentWhereList;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) {
        this.isActive = false;
        return currentName;
    }

    @Override
    public String preProcess(MsgObject msg, String currentName) {
        try {
            String[] valueList = msg.getValue(currentName);
            for (int i = 0; i < valueList.length; ++i) {
                this.resetVariables(valueList[i]);
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "LinkElement : preProcess: adding a link " + this.toString());
                msg.addLink((LinkElement)this.clone());
            }
            return currentName;
        }
        catch (CloneNotSupportedException e) {
            throw new MraldError(e, msg);
        }
        catch (MraldException e) {
            throw new MraldError(e, msg);
        }
    }

    public void resetVariables(String linkString) throws MraldException {
        String[] temp = new String[]{linkString};
        this.nameValues.clearNvPairs();
        try {
            this.process(temp);
        }
        catch (SqlElementException e) {
            throw new MraldException(e);
        }
        String var = this.nameValues.getValue("SecondaryLink")[0];
        StringTokenizer tableFieldPair = new StringTokenizer(var, ".");
        this.secondaryTable = tableFieldPair.countTokens() == 4 ? tableFieldPair.nextToken() + "." + tableFieldPair.nextToken() + "." + tableFieldPair.nextToken() : (tableFieldPair.countTokens() == 3 ? tableFieldPair.nextToken() + "." + tableFieldPair.nextToken() : tableFieldPair.nextToken());
        this.secondaryField = tableFieldPair.nextToken();
        var = this.nameValues.getValue("PrimaryLink")[0];
        tableFieldPair = new StringTokenizer(var, ".");
        this.primaryTable = tableFieldPair.countTokens() == 4 ? tableFieldPair.nextToken() + "." + tableFieldPair.nextToken() + "." + tableFieldPair.nextToken() : (tableFieldPair.countTokens() == 3 ? tableFieldPair.nextToken() + "." + tableFieldPair.nextToken() : tableFieldPair.nextToken());
        this.primaryField = tableFieldPair.nextToken();
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "LinkElement: reset variables:Primary Table " + this.primaryTable + " primary field : " + this.primaryField);
        String outerVar = this.nameValues.getValue("OuterJoin")[0];
        if (outerVar != null && !outerVar.equals("")) {
            this.outerJoin = outerVar;
        }
    }
}

