/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.query.Edge;
import org.mitre.mrald.query.LinkElement;
import org.mitre.mrald.query.Node;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MraldDijkstra {
    public static final int JOIN_PATH_NOT_COMPLETE = 1;
    public static final int JOIN_PATH_NOT_COMPLETE_OR_UNIQUE = 3;
    public static final int JOIN_PATH_NOT_UNIQUE = 2;
    public static final int JOIN_PATH_OK = 0;
    ArrayList<Edge> edges;
    ArrayList<Node> nodes = new ArrayList();
    ArrayList quals = null;

    public MraldDijkstra(MsgObject msg) {
        this.edges = new ArrayList();
        ArrayList<LinkElement> links = msg.getLinks();
        for (int i = 0; i < links.size(); ++i) {
            Node existingNode2;
            LinkElement currentElement = links.get(i);
            String nodeName = currentElement.getPrimaryTable();
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldDijkstra: constructor: primary Table " + nodeName);
            Node existingNode1 = this.findNode(nodeName);
            if (existingNode1 == null) {
                existingNode1 = new Node(nodeName);
                this.nodes.add(existingNode1);
            }
            if ((existingNode2 = this.findNode(nodeName = currentElement.getSecondaryTable())) == null) {
                existingNode2 = new Node(nodeName);
                this.nodes.add(existingNode2);
            }
            this.edges.add(new Edge(existingNode1, existingNode2, currentElement.getQual()));
        }
    }

    public String getQualString() {
        if (this.quals.size() == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.quals.size(); ++i) {
            ret.append(((Edge)this.quals.get(i)).getQual());
            if (i >= this.quals.size() - 1) continue;
            ret.append(" AND ");
        }
        return ret.toString();
    }

    public Node findNode(String nodeName) {
        if (nodeName == null) {
            NullPointerException e = new NullPointerException("Passed a 'null' nodeName to MraldDijkstra.findNode()");
            throw e;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node currentNode = this.nodes.get(i);
            if (!currentNode.getName().equalsIgnoreCase(nodeName)) continue;
            return currentNode;
        }
        return null;
    }

    public String runDijkstra(ArrayList<String> startingFromList) throws MraldException {
        if (startingFromList.size() < 2) {
            return "";
        }
        HashSet<Node> knownPath = new HashSet<Node>();
        HashSet<Node> unknownPath = new HashSet<Node>(this.nodes);
        Node cheapestNode = this.findNode(startingFromList.get(0));
        if (cheapestNode == null) {
            throw new MraldException("You are attempting to build a form that has more than one table and no joins between tables.  All tables included must be joined to at least one other table, or the results of the query will not make sense (you will get a Cartesian product - a lot of unrelated data");
        }
        cheapestNode.setCostToReach(0);
        while (unknownPath.size() > 0) {
            cheapestNode = this.findCheapest(unknownPath);
            knownPath.add(cheapestNode);
            unknownPath.remove(cheapestNode);
            this.relax(cheapestNode);
        }
        HashSet<Edge> qualList = new HashSet<Edge>();
        for (int i = 0; i < startingFromList.size(); ++i) {
            Node temp = this.findNode(startingFromList.get(i));
            if (temp == null) {
                StringBuffer ret = new StringBuffer();
                for (int j = 0; j < this.nodes.size(); ++j) {
                    Node currentNode = this.nodes.get(j);
                    ret.append(currentNode.getName());
                    ret.append("\n");
                }
                throw new MraldException("There has been an error in analysing the link structure in your request.\n\nFor debugging purposes, table '" + startingFromList.get(i) + "' was not found in list of available nodes.\nThe list includes:\n" + ret.toString());
            }
            qualList.addAll(temp.getPath());
        }
        this.quals = new ArrayList(qualList);
        Edge currentEdge2 = new Edge();
        Node[] nodes = new Node[2];
        for (Edge currentEdge2 : this.quals) {
            nodes = currentEdge2.getNodes();
            if (!startingFromList.contains(nodes[0].getName())) {
                startingFromList.add(nodes[0].getName());
            }
            if (startingFromList.contains(nodes[1].getName())) continue;
            startingFromList.add(nodes[1].getName());
        }
        return this.getQualString();
    }

    public int testCompleteJoinPath(ArrayList tableList) {
        for (int i = 0; i < tableList.size(); ++i) {
            boolean ok = false;
            for (int x = 0; x < this.nodes.size(); ++x) {
                if (!tableList.get(i).equals(this.nodes.get(x).getName())) continue;
                ok = true;
            }
            if (ok) continue;
            return 1;
        }
        HashSet<Node> visitedNodes = new HashSet<Node>();
        HashSet<Edge> usedEdges = new HashSet<Edge>();
        HashSet<Edge> unUsedEdges = new HashSet<Edge>();
        Node currentNode = this.nodes.get(0);
        visitedNodes.add(currentNode);
        unUsedEdges.addAll(currentNode.getAttachedEdges());
        Edge currentEdge = null;
        while (unUsedEdges.size() != 0) {
            currentEdge = (Edge)unUsedEdges.iterator().next();
            if (!visitedNodes.contains(currentEdge.getNodes()[0])) {
                currentNode = currentEdge.getNodes()[0];
            } else if (!visitedNodes.contains(currentEdge.getNodes()[1])) {
                currentNode = currentEdge.getNodes()[1];
            }
            ArrayList<Edge> edgesToAdd = currentNode.getAttachedEdges();
            for (int i = 0; i < edgesToAdd.size(); ++i) {
                if (usedEdges.contains(edgesToAdd.get(i))) continue;
                unUsedEdges.add(edgesToAdd.get(i));
            }
            visitedNodes.add(currentNode);
            unUsedEdges.remove(currentEdge);
            usedEdges.add(currentEdge);
        }
        return visitedNodes.size() == this.nodes.size() ? 0 : 1;
    }

    public int testJoinPath(ArrayList tableList) {
        if (tableList.size() == 1) {
            return 0;
        }
        return this.testCompleteJoinPath(tableList) + this.testUniqueJoinPath();
    }

    public int testUniqueJoinPath() {
        if (this.edges.size() < 2) {
            return 0;
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge currentEdge = this.edges.get(i);
            for (int x = i; x < this.edges.size(); ++x) {
                Edge testingEdge = this.edges.get(x);
                if (testingEdge.getNodes()[0] != currentEdge.getNodes()[1] || testingEdge.getNodes()[1] != currentEdge.getNodes()[0]) continue;
                return 2;
            }
        }
        ArrayList<Node> visitedNodes = new ArrayList<Node>();
        ArrayList<Edge> usedEdges = new ArrayList<Edge>();
        Node startNode = this.nodes.get(0);
        visitedNodes.add(startNode);
        return this.traverseUniqueJoinPath(startNode, usedEdges, visitedNodes);
    }

    public String toString() {
        int i;
        StringBuffer ret = new StringBuffer();
        ret.append("List of all Nodes:");
        for (i = 0; i < this.nodes.size(); ++i) {
            ret.append("\n\t");
            ret.append(this.nodes.get(i).getName());
        }
        ret.append("\nList of all Edges:");
        for (i = 0; i < this.edges.size(); ++i) {
            ret.append("\n\t");
            ret.append(this.edges.get(i).getQual());
        }
        return ret.toString();
    }

    public int traverseUniqueJoinPath(Node currentNode, List<Edge> usedEdges, List<Node> visitedNodes) {
        Map adjacentNodes = currentNode.getAdjacentNodes();
        for (Node neighborNode : adjacentNodes.keySet()) {
            Edge neighborsEdge = (Edge)adjacentNodes.get(neighborNode);
            if (usedEdges.contains(neighborsEdge)) continue;
            if (visitedNodes.contains(neighborNode)) {
                return 2;
            }
            visitedNodes.add(neighborNode);
            usedEdges.add(neighborsEdge);
            if (this.traverseUniqueJoinPath(neighborNode, usedEdges, visitedNodes) != 1) continue;
            return 1;
        }
        return 0;
    }

    private Node findCheapest(HashSet<Node> set) throws ClassCastException {
        TreeSet<Node> sortedSet = new TreeSet<Node>(set);
        return sortedSet.first();
    }

    private void relax(Node justSet) throws MraldException {
        ArrayList<Edge> attachedEdges = justSet.getAttachedEdges();
        Node[] edgeNodes = new Node[2];
        for (int i = 0; i < attachedEdges.size(); ++i) {
            int j;
            ArrayList<Edge> newPath;
            Edge edgeChecking = attachedEdges.get(i);
            edgeNodes = edgeChecking.getNodes();
            if (justSet == edgeNodes[0]) {
                if (justSet.getCostToReach() + edgeChecking.getWeight() >= edgeNodes[1].getCostToReach()) continue;
                edgeNodes[1].setCostToReach(justSet.getCostToReach() + edgeChecking.getWeight());
                newPath = new ArrayList<Edge>(justSet.getPath());
                newPath.add(edgeChecking);
                for (j = 0; j < attachedEdges.size(); ++j) {
                    if (edgeChecking == attachedEdges.get(j) || !edgeChecking.hasSameNodes(attachedEdges.get(j))) continue;
                    newPath.add(attachedEdges.get(j));
                }
                edgeNodes[1].setPath(newPath);
                continue;
            }
            if (justSet == edgeNodes[1]) {
                if (justSet.getCostToReach() + edgeChecking.getWeight() >= edgeNodes[0].getCostToReach()) continue;
                edgeNodes[0].setCostToReach(justSet.getCostToReach() + edgeChecking.getWeight());
                newPath = new ArrayList<Edge>(justSet.getPath());
                newPath.add(edgeChecking);
                for (j = 0; j < attachedEdges.size(); ++j) {
                    if (edgeChecking == attachedEdges.get(j) || !edgeChecking.hasSameNodes(attachedEdges.get(j))) continue;
                    newPath.add(attachedEdges.get(j));
                }
                edgeNodes[0].setPath(newPath);
                continue;
            }
            throw new MraldException("MraldDijkstra.relax() not functioning properly");
        }
    }
}

