/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotedResultSet
implements ResultSet,
ResultSetMetaData {
    public final int entity_column;
    public final int attribute_column;
    public final int value_column;
    public final int base_column_count;
    public final ResultSet base_data;
    public final ResultSetMetaData base_metadata;
    private Object[][] pivot_data;
    private HashMap<String, Integer> pivot_columns;
    private String[] pivot_column_names;
    private int row_pointer = -1;

    public PivotedResultSet(ResultSet base_data, String[] pieces) throws SQLException {
        this.base_data = base_data;
        this.base_metadata = base_data.getMetaData();
        this.base_column_count = this.base_metadata.getColumnCount();
        this.entity_column = this.find(pieces[1]);
        this.attribute_column = this.find(pieces[4]);
        this.value_column = this.find(pieces[7]);
        this.buildPivotTable();
    }

    public int find(String field) throws SQLException {
        for (int i = 1; i <= this.base_column_count; ++i) {
            if (!this.base_metadata.getColumnName(i).equalsIgnoreCase(field)) continue;
            return i;
        }
        throw new SQLException("Field not found: " + field);
    }

    private void buildPivotTable() throws SQLException {
        ArrayList<Object[]> tuples = new ArrayList<Object[]>();
        HashMap<Object, Integer> rows = new HashMap<Object, Integer>();
        int row_index = 0;
        TreeSet<String> cols = new TreeSet<String>();
        while (this.base_data.next()) {
            Object row = this.base_data.getObject(this.entity_column);
            String col = this.base_data.getString(this.attribute_column);
            Object[] tuple = new Object[this.base_column_count + 1];
            tuple[0] = null;
            for (int i = 1; i <= this.base_column_count; ++i) {
                tuple[i] = this.base_data.getObject(i);
            }
            tuples.add(tuple);
            if (!rows.containsKey(row)) {
                rows.put(row, new Integer(row_index++));
            }
            if (cols.contains(col)) continue;
            cols.add(col);
        }
        this.buildPivotColumns(cols);
        this.pivot_data = new Object[rows.size()][];
        for (Object row : rows.keySet()) {
            int index = rows.get(row);
            Object[] tuple = new Object[this.getColumnCount() + 1];
            this.pivot_data[index] = tuple;
        }
        this.populatePivotTable(tuples, rows);
    }

    private void buildPivotColumns(TreeSet<String> cols) throws SQLException {
        int col_index = 1;
        int num_columns = cols.size() + this.base_column_count - 2;
        this.pivot_columns = new HashMap(num_columns);
        this.pivot_column_names = new String[num_columns + 1];
        for (int i = 1; i <= this.base_column_count; ++i) {
            if (i == this.attribute_column || i == this.value_column) continue;
            this.pivot_columns.put(this.base_metadata.getColumnName(i), new Integer(col_index));
            this.pivot_column_names[col_index] = this.base_metadata.getColumnName(i);
            ++col_index;
        }
        for (String col : cols) {
            this.pivot_columns.put(col, new Integer(col_index));
            this.pivot_column_names[col_index] = col;
            ++col_index;
        }
    }

    private void populatePivotTable(ArrayList<Object[]> tuples, HashMap<Object, Integer> rows) throws SQLException {
        for (Object[] tuple : tuples) {
            Object tuple_row = tuple[this.entity_column];
            Object[] pivot_row = this.pivot_data[rows.get(tuple_row)];
            int shift = 0;
            for (int i = 1; i <= this.base_column_count; ++i) {
                if (i == this.attribute_column || i == this.value_column) {
                    ++shift;
                    continue;
                }
                pivot_row[i - shift] = tuple[i];
            }
            String col = (String)tuple[this.attribute_column];
            int col_index = this.pivot_columns.get(col);
            Object val = tuple[this.value_column];
            Object old = pivot_row[col_index];
            if (old != null) {
                val = old.toString() + "<br/>" + val.toString();
            }
            pivot_row[col_index] = val;
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public void close() throws SQLException {
        this.base_data.close();
        this.pivot_column_names = null;
        this.pivot_columns = null;
        this.pivot_data = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object result = this.pivot_data[this.row_pointer][columnIndex];
        return result != null ? result.toString() : null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object result = this.pivot_data[this.row_pointer][columnIndex];
        if (!(result instanceof Timestamp)) {
            if (result instanceof Date) {
                result = new Timestamp(((Date)result).getTime());
            } else {
                try {
                    java.util.Date date = DateFormat.getDateInstance().parse(result.toString());
                    result = new Timestamp(date.getTime());
                }
                catch (ParseException e) {
                    throw new SQLException(e.getMessage());
                }
            }
        }
        return (Timestamp)result;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer result = this.pivot_columns.get(columnName);
        if (result == null) {
            throw new SQLException("No such column: " + columnName);
        }
        return result;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object result = this.pivot_data[this.row_pointer][columnIndex];
        if (result != null && !(result instanceof BigDecimal)) {
            result = new BigDecimal(result.toString());
        }
        return (BigDecimal)result;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.row_pointer < 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.row_pointer >= this.pivot_data.length;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.row_pointer == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.row_pointer == this.pivot_data.length - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.row_pointer = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.row_pointer = this.pivot_data.length;
    }

    @Override
    public boolean first() throws SQLException {
        this.row_pointer = 0;
        return this.pivot_data.length > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.row_pointer = this.pivot_data.length - 1;
        return this.pivot_data.length > 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.row_pointer + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.row_pointer = row - 1;
        return this.adjustedRowPointer();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.row_pointer += rows;
        return this.adjustedRowPointer();
    }

    private boolean adjustedRowPointer() {
        if (this.row_pointer < -1) {
            this.row_pointer = -1;
        }
        if (this.row_pointer > this.pivot_data.length) {
            this.row_pointer = this.pivot_data.length;
        }
        return this.row_pointer >= 0 && this.row_pointer < this.pivot_data.length;
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("A pivoted result-set cannot be inserted into.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("A pivoted result-set cannot be deleted from.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("A pivoted result-set cannot be inserted into.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.base_data.getStatement();
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("A pivoted result-set cannot be updated.");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.pivot_columns.size();
    }

    private int getAdjustedColumnIndex(int column) {
        int shift = (column >= this.attribute_column ? 1 : 0) + (column >= this.value_column ? 1 : 0);
        return column > this.base_column_count - 2 ? this.value_column : column + shift;
    }

    public String getValueColumnName() throws SQLException {
        return this.base_metadata.getColumnName(this.value_column);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.base_metadata.isAutoIncrement(this.getAdjustedColumnIndex(column));
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.base_metadata.isCaseSensitive(this.getAdjustedColumnIndex(column));
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.base_metadata.isSearchable(this.getAdjustedColumnIndex(column));
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.base_metadata.isCurrency(this.getAdjustedColumnIndex(column));
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.base_metadata.isNullable(this.getAdjustedColumnIndex(column));
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.base_metadata.isSigned(this.getAdjustedColumnIndex(column));
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.base_metadata.getColumnDisplaySize(this.getAdjustedColumnIndex(column));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.base_metadata.getColumnLabel(this.getAdjustedColumnIndex(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.pivot_column_names[column];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.base_metadata.getSchemaName(this.getAdjustedColumnIndex(column));
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.base_metadata.getPrecision(this.getAdjustedColumnIndex(column));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.base_metadata.getScale(this.getAdjustedColumnIndex(column));
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.base_metadata.getTableName(this.getAdjustedColumnIndex(column));
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.base_metadata.getCatalogName(this.getAdjustedColumnIndex(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.base_metadata.getColumnType(this.getAdjustedColumnIndex(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.base_metadata.getColumnTypeName(this.getAdjustedColumnIndex(column));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.base_metadata.getColumnClassName(this.getAdjustedColumnIndex(column));
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://mumps.mitre.org:5432/ChronicFatigue", "postgres", "postgres");
        Statement stmt = db.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT bmi, yrs_ill, dob, abt_id, sf36_value, sex, sf36_code, age FROM sf36summaryscores NATURAL JOIN patientinfo;");
        String[] eav = new String[]{"patientinfo", "abt_id", "Numeric", "sf36summaryscores", "sf36_code", "String", "sf36summaryscores", "sf36_value", "Numeric"};
        PivotedResultSet pvt = new PivotedResultSet(rs, eav);
        for (int i = 1; i <= pvt.getColumnCount(); ++i) {
            System.out.print(pvt.getColumnName(i));
            System.out.print("\t");
        }
        System.out.println();
        while (pvt.next()) {
            for (int j = 1; j <= pvt.getColumnCount(); ++j) {
                System.out.print(pvt.getString(j));
                System.out.print("\t");
            }
            System.out.println();
        }
        System.out.println(pvt.getRow() - 1);
        System.out.println("Done!");
    }
}

