/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.BroadcastQuery;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.query.BroadcastTargetProvider;
import org.mitre.mrald.query.LinkElement;
import org.mitre.mrald.query.MraldDijkstra;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

public class QueryBuilder
extends AbstractStep {
    private ArrayList<String> fromStrings = new ArrayList();
    private ArrayList<String> groupByStrings = new ArrayList();
    private MsgObject msg;
    private ArrayList<String> orderByStrings = new ArrayList();
    private ArrayList<String> selectStrings = new ArrayList();
    private ArrayList<String> whereAndStrings = new ArrayList();

    public QueryBuilder() {
    }

    public QueryBuilder(MsgObject msg) {
        this.msg = msg;
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            this.setQueryLimit();
            this.buildQueryComponents(msgObject.getWorkingObjects());
            msgObject.setQuery(this.buildQuery());
            if (this.msg.getValue("broadcastQuery")[0].equals("true")) {
                this.startBroadcasts();
            }
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e);
        }
    }

    public void startBroadcasts() {
        BroadcastTargetProvider provider = BroadcastQuery.getProvider();
        ArrayList<ParserElement> sqlElements = this.msg.getWorkingObjects();
        ArrayList<LinkElement> linkElements = this.msg.getLinks();
        List<BroadcastQueryTarget> targetList = provider.getTargets(sqlElements, linkElements, this.msg.getValue("Datasource")[0]);
        BroadcastQuery.doBroadcast(this.msg, targetList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setQueryLimit() throws MraldException {
        try {
            String[] qSize = this.msg.getValue("outputSize");
            if (!qSize[0].startsWith("line")) return;
        }
        catch (Exception nfe) {
            MraldException otherException = new MraldException(nfe.getMessage());
            throw otherException;
        }
    }

    public String buildQuery() throws MraldException {
        String finalQueryString = "";
        try {
            int l;
            String start = "SELECT ";
            if (!this.msg.getValue("showDuplicates")[0].equals("true")) {
                start = start + "DISTINCT ";
            }
            finalQueryString = this.order(this.selectStrings, start);
            MraldDijkstra links = new MraldDijkstra(this.msg);
            ArrayList<LinkElement> linkArray = this.msg.getLinks();
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "QueryBuilder : execute: get number of Links " + linkArray.size());
            for (LinkElement test : linkArray) {
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "QueryBuilder : execute: get Links " + test.toString());
            }
            String linkString = links.runDijkstra(this.fromStrings);
            finalQueryString = finalQueryString + " From ";
            for (l = 0; l < this.fromStrings.size(); ++l) {
                String this_fstr = this.fromStrings.get(l);
                finalQueryString = finalQueryString + this_fstr;
                if (l >= this.fromStrings.size() - 1) continue;
                finalQueryString = finalQueryString + ", ";
            }
            if (this.whereAndStrings.size() > 0) {
                finalQueryString = finalQueryString + " Where ";
                for (l = 0; l < this.whereAndStrings.size(); ++l) {
                    String this_wstr = this.whereAndStrings.get(l);
                    finalQueryString = finalQueryString + this_wstr;
                    if (l >= this.whereAndStrings.size() - 1) continue;
                    finalQueryString = finalQueryString + " AND ";
                }
            }
            if (!linkString.equals("")) {
                finalQueryString = finalQueryString.indexOf(" Where ") != -1 ? finalQueryString + " AND " + linkString : finalQueryString + " Where " + linkString;
            }
            finalQueryString = finalQueryString + this.order(this.groupByStrings, " GROUP BY ");
            finalQueryString = finalQueryString + this.order(this.orderByStrings, " ORDER BY ");
            finalQueryString = MiscUtils.clearSemiColon(finalQueryString);
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "QueryBuilder: query " + finalQueryString);
            return finalQueryString;
        }
        catch (MraldException cde) {
            MraldException e = new MraldException("In QueryBuilder.buildQuery(): " + cde.getMessage() + "\nQuery so far is: " + finalQueryString);
            throw e;
        }
    }

    public void buildQueryComponents(ArrayList qe) throws MraldException {
        if (qe.size() == 0) {
            throw new MraldException("You must select output data to proceed. Please make selection from Output Data Selection list and resubmit.");
        }
        SqlElements this_qe = null;
        for (int k = 0; k < qe.size(); ++k) {
            this_qe = (SqlElements)qe.get(k);
            if (this_qe == null) continue;
            this.fromStrings = this_qe.buildFrom(this.fromStrings);
            this.whereAndStrings = this_qe.buildWhereAnd(this.whereAndStrings);
            this.selectStrings = this_qe.buildSelect(this.selectStrings);
            this.orderByStrings = this_qe.buildOrderBy(this.orderByStrings);
            this.groupByStrings = this_qe.buildGroupBy(this.groupByStrings);
        }
    }

    private String order(ArrayList orderByStrings, String leadIn) {
        String returnString = "";
        if (orderByStrings.size() != 0) {
            TreeMap<Float, String> orderList = new TreeMap<Float, String>();
            Float selectPos = new Float(0.0f);
            int lastString = orderByStrings.size() + 300;
            returnString = returnString + leadIn;
            for (int h = 0; h < orderByStrings.size(); ++h) {
                Float f;
                StringTokenizer thisField = new StringTokenizer(orderByStrings.get(h).toString(), "~");
                String fieldName = thisField.nextToken();
                if (thisField.hasMoreTokens()) {
                    f = new Float(thisField.nextToken());
                } else {
                    ++lastString;
                    f = new Float(lastString);
                }
                selectPos = f;
                orderList.put(selectPos, fieldName);
            }
            Collection sortedValues = orderList.values();
            Iterator it = sortedValues.iterator();
            while (it.hasNext()) {
                returnString = returnString + it.next();
                if (!it.hasNext()) continue;
                returnString = returnString + ", ";
            }
        }
        return returnString;
    }
}

