/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.parser.MraldParserException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.QueryBuildable;
import org.mitre.mrald.query.SqlElementException;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlElements
extends ParserElement
implements QueryBuildable {
    public static final String DEFAULT_SQL_NO = "0";
    public String getOrder;
    protected String elementType;
    protected String outputType = null;
    protected String sqlNo = "0";
    protected String as;
    protected String field;
    protected String fromTableName;
    protected String operator;
    protected String order;
    protected String synonym;
    protected String table;

    public SqlElements() {
        this.nameValues = new MsgObject();
        this.elementType = "SQL";
    }

    public SqlElements(MsgObject thisMsg) {
        this.nameValues = thisMsg;
        this.elementType = "SQL";
    }

    public void setOutputType(String thisOutputType) {
        this.outputType = thisOutputType;
    }

    public void setSqlNo(String thisSqlNo) {
        this.sqlNo = thisSqlNo;
    }

    public String getAs() {
        return this.as;
    }

    @Override
    public String getElementType() {
        return this.elementType;
    }

    public String getField() {
        return this.field;
    }

    public String getFromTableName() {
        return this.fromTableName;
    }

    @Override
    public MsgObject getNameValues() {
        return this.nameValues;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getOrder() {
        return this.order;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String getSqlNo() {
        return this.sqlNo;
    }

    public String getSynonym() {
        return this.synonym;
    }

    public String getTable() {
        return this.table;
    }

    @Override
    public abstract ArrayList<String> buildFrom(ArrayList<String> var1) throws MraldException;

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public abstract ArrayList<String> buildOrderBy(ArrayList<String> var1) throws MraldException;

    @Override
    public abstract ArrayList<String> buildSelect(ArrayList<String> var1) throws MraldException;

    public abstract ArrayList<String> buildWhere(ArrayList<String> var1) throws MraldException;

    @Override
    public ArrayList<String> buildWhereAnd(ArrayList<String> currentWhereAndList) throws MraldException {
        return this.buildWhere(currentWhereAndList);
    }

    @Override
    public String preProcess(MsgObject msg, String currentName) throws SqlElementException {
        return currentName;
    }

    @Override
    public void process(String[] valueList) throws SqlElementException {
        String outputManager;
        try {
            super.process(valueList);
        }
        catch (MraldParserException e) {
            throw new MraldError(e);
        }
        String sqlNo = this.nameValues.getValue("SqlThread")[0];
        if (!sqlNo.equals("")) {
            this.setSqlNo(sqlNo);
        }
        if (!(outputManager = this.nameValues.getValue("outputManager")[0]).equals("")) {
            this.setOutputType(outputManager);
        }
        this.init();
    }

    protected void setAs() {
        this.as = this.nameValues.getValue("As")[0];
    }

    protected void setField() {
        this.field = this.nameValues.getValue("Field")[0];
    }

    protected void setOperator() {
        this.operator = this.nameValues.getValue("Operator")[0];
        if (this.operator.equals("")) {
            this.operator = "=";
        }
    }

    protected void setOrder() {
        this.order = this.nameValues.getValue("Order")[0];
    }

    protected void setTable() {
        this.synonym = this.nameValues.getValue("Synomyn")[0].toString();
        this.fromTableName = this.nameValues.getValue("Table")[0].toString();
        String dbName = this.nameValues.getValue("DBName")[0];
        String schemaName = this.nameValues.getValue("Schema")[0];
        if (!dbName.equals("") && !schemaName.equals("")) {
            this.fromTableName = dbName + "." + schemaName + "." + this.fromTableName;
        }
        if (!this.synonym.equals("")) {
            this.table = this.synonym;
            this.fromTableName = this.fromTableName + " " + this.synonym;
        } else {
            this.table = this.fromTableName;
        }
    }

    protected void init() {
        this.setTable();
        this.setField();
        this.setOperator();
        this.setAs();
        this.setOrder();
    }

    public String buildValue() {
        StringBuilder ret = new StringBuilder();
        ret.append("ElementType:" + this.elementType);
        ret.append("~");
        for (String key : this.nameValues.getNames()) {
            String[] values = this.nameValues.getValue(key);
            for (int i = 0; i < values.length; ++i) {
                ret.append(key.toString() + ":" + values[i]);
                ret.append("~");
            }
        }
        return ret.toString();
    }
}

