/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatElement
extends SqlElements {
    boolean complete = false;
    String function;

    public StatElement() {
        this.elementType = "Stat";
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        String nextVal;
        if (!this.complete) {
            return currentFromList;
        }
        if (this.function.indexOf(42) != -1) {
            this.addAllTables(currentFromList);
            return currentFromList;
        }
        if (!currentFromList.contains(this.fromTableName)) {
            currentFromList.add(this.fromTableName);
        }
        if ((nextVal = this.nameValues.getValue("GroupSelect")[0]).equals("")) {
            return currentFromList;
        }
        if (!currentFromList.contains(nextVal = nextVal.substring(0, nextVal.indexOf(".")))) {
            currentFromList.add(nextVal);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) {
        String newValue;
        if (!this.complete) {
            return currentGroupByList;
        }
        String groupStr = this.nameValues.getValue("Group")[0];
        if (groupStr.equals("Hour")) {
            String newValue2 = "TO_CHAR( " + this.nameValues.getValue("GroupSelect")[0] + ", 'YYYY-MM-DD HH24') ";
            if (!currentGroupByList.contains(newValue2)) {
                currentGroupByList.add(newValue2);
            }
        } else if (groupStr.equals("Day")) {
            String newValue3 = "TO_CHAR( " + this.nameValues.getValue("GroupSelect")[0] + ", 'YYYY-MM-DD') ";
            if (!currentGroupByList.contains(newValue3)) {
                currentGroupByList.add(newValue3);
            }
        } else if (groupStr.equals("Month") && !currentGroupByList.contains(newValue = "TO_CHAR( " + this.nameValues.getValue("GroupSelect")[0] + ", 'YYYY-MM') ")) {
            currentGroupByList.add(newValue);
        }
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) {
        if (!this.complete) {
            return currentSelectList;
        }
        String groupStr = this.nameValues.getValue("Group")[0];
        if (!groupStr.equals("")) {
            this.addGroupString(currentSelectList, groupStr);
        }
        String newValue = null;
        if (this.function.indexOf(42) != -1) {
            newValue = "Count(*) AS All_Count~" + this.order;
        } else {
            String myColumn = this.function;
            int index = myColumn.toUpperCase().indexOf("DISTINCT");
            if (index != -1) {
                myColumn = myColumn.substring(0, index - 1) + "_Distinct";
            }
            newValue = this.function.toUpperCase().indexOf("DISTINCT") == -1 ? this.function + "( " + this.field + ") AS \"" + myColumn + " " + this.field + "\"" + "~" + this.order : this.function + "( " + this.field + ")) AS \"" + myColumn + " " + this.field + "\"" + "~" + this.order;
        }
        if (!currentSelectList.contains(newValue)) {
            currentSelectList.add(newValue);
        }
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        if (this.table == null || this.table.equals("")) {
            return currentWhereList;
        }
        return currentWhereList;
    }

    protected void addAllTables(ArrayList<String> currentFromList) {
        String[] tableNames = this.nameValues.getValue("Table");
        for (int i = 0; i < tableNames.length; ++i) {
            if (currentFromList.contains(tableNames[i])) continue;
            currentFromList.add(tableNames[i]);
        }
    }

    protected void addGroupString(ArrayList<String> currentSelectList, String groupStr) {
        String groupSelectString = this.nameValues.getValue("GroupSelect")[0];
        String dateFormat = null;
        if (groupStr.equals("Hour")) {
            dateFormat = ", 'YYYY-MM-DD HH24') ";
        } else if (groupStr.equals("Day")) {
            dateFormat = ", 'YYYY-MM-DD') ";
        } else if (groupStr.equals("Month")) {
            dateFormat = ", 'YYYY-MM') ";
        }
        String newValue = "TO_CHAR( " + groupSelectString + dateFormat + groupStr + "~" + this.order;
        if (!currentSelectList.contains(newValue)) {
            currentSelectList.add(newValue);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.function = this.nameValues.getValue("Function")[0];
        this.complete = !this.table.equals("") && !this.function.equals("") && (!this.field.equals("") || this.function.indexOf(42) != -1);
    }
}

