/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mitre.mrald.control.MraldEntry;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.query.SqlElementException;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubQueryElement
extends SqlElements {
    MsgObject subQueryMsg;
    MsgObject outer;

    public SubQueryElement() {
        this.elementType = "SubQuery";
        this.subQueryMsg = new MsgObject();
        this.outer = new MsgObject();
    }

    public SubQueryElement(MsgObject msg) {
        super(msg);
        this.elementType = "SubQuery";
        this.subQueryMsg = new MsgObject();
        this.outer = new MsgObject();
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) throws MraldException {
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        String newValue = this.outer.getValue("Table")[0];
        String synValue = this.outer.getValue("Synomyn")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public void process(String[] valueList) throws SqlElementException {
        String outputManager;
        int numOfArrayLists = valueList.length;
        StringTokenizer valueTokens = null;
        String valueArray = null;
        String name = null;
        String value = null;
        for (int i = 0; i < numOfArrayLists; ++i) {
            valueArray = valueList[i];
            valueTokens = new StringTokenizer(valueArray, "||");
            if (!valueTokens.hasMoreTokens()) {
                this.isActive = false;
            }
            while (valueTokens.hasMoreTokens()) {
                this.isActive = true;
                StringTokenizer nameValuePair = new StringTokenizer(valueTokens.nextToken(), "-");
                name = nameValuePair.nextToken();
                if (name.indexOf(" ") > 0 && name.charAt(0) != '\"') {
                    name = "\"" + name + "\"";
                }
                value = nameValuePair.nextToken();
                if (name.equals("Outer")) {
                    this.outer = MiscUtils.parseNVPairs(value);
                    continue;
                }
                this.subQueryMsg.setValue(name, value);
            }
        }
        String sqlNo = this.nameValues.getValue("SqlThread")[0];
        if (!sqlNo.equals("")) {
            this.setSqlNo(sqlNo);
        }
        if (!(outputManager = this.nameValues.getValue("outputManager")[0]).equals("")) {
            this.setOutputType(outputManager);
        }
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        String subquery;
        this.subQueryMsg.setUserId(this.getClass().getName());
        MraldEntry go = new MraldEntry(this.subQueryMsg);
        try {
            subquery = go.buildQuery();
        }
        catch (WorkflowStepException e) {
            throw new MraldException(e.getMessage());
        }
        String outerTable = this.outer.getValue("Table")[0].toString();
        String outerField = this.outer.getValue("Field")[0].toString();
        boolean doesntContain = this.outer.getValue("Contains")[0].toString().toLowerCase().equals("no");
        StringBuffer ret = new StringBuffer();
        ret.append(outerTable);
        ret.append(".");
        ret.append(outerField);
        if (doesntContain) {
            ret.append(" NOT IN (");
        } else {
            ret.append(" IN (");
        }
        ret.append(subquery);
        ret.append(")");
        String newValue = ret.toString();
        if (!currentWhereList.contains(newValue)) {
            currentWhereList.add(newValue);
        }
        return currentWhereList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }
}

