/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.Calendar;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TimeFormatException;
import org.mitre.mrald.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeElement
extends SqlElements {
    private boolean endDateSelected = false;
    private boolean startDateSelected = false;

    public TimeElement() {
        this.elementType = "Time";
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) {
        String newValue = this.nameValues.getValue("Table")[0];
        String synValue = this.nameValues.getValue("Synomyn")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) throws MraldException {
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        try {
            String newValue = " ";
            int noOfValues = this.nameValues.getValue("Value").length;
            if (noOfValues == 0) {
                return currentWhereList;
            }
            String field = this.nameValues.getValue("Field")[0].toString();
            String synValue = this.nameValues.getValue("Synomyn")[0];
            String startValue = null;
            String endValue = null;
            int i = 0;
            for (i = 0; i < noOfValues; ++i) {
                String startDate = this.nameValues.getValue("StartDate")[i];
                String startTime = this.nameValues.getValue("StartTime")[i];
                startValue = TimeFormatter.formatDateTime(this.nameValues.getValue("StartDate")[i] + " " + this.nameValues.getValue("StartTime")[i], false).toString();
                if (this.endDateSelected) {
                    endValue = TimeFormatter.formatDateTime(this.nameValues.getValue("EndDate")[i] + " " + this.nameValues.getValue("EndTime")[i], false).toString();
                } else if (this.startDateSelected) {
                    String endDate = this.nameValues.getValue("EndDate")[i];
                    String endTime = this.nameValues.getValue("EndTime")[i];
                    endValue = TimeFormatter.formatDateTime(endDate + " " + endTime, false).toString();
                    Calendar startValueCal = this.buildTimeStart(i, endDate + " " + endTime);
                    startValue = TimeFormatter.getTimeAsString(startValueCal);
                } else {
                    Calendar endValueCal = this.buildTimeEnd(i, startDate + " " + startTime);
                    endValue = TimeFormatter.getTimeAsString(endValueCal);
                }
                synValue = this.nameValues.getValue("Synomyn")[0];
                field = !synValue.equals("") ? synValue + "." + this.nameValues.getValue("Field")[i] : this.nameValues.getValue("Table")[i] + "." + this.nameValues.getValue("Field")[i];
                newValue = newValue + " ( " + field + " >= to_date('" + startValue + "', '" + "YYYY-MM-DD HH24:MI:SS" + "')" + " AND " + field + " <= to_date('" + endValue + "', '" + "YYYY-MM-DD HH24:MI:SS" + "') ) ";
            }
            if (!currentWhereList.contains(newValue)) {
                currentWhereList.add(newValue);
            }
            return currentWhereList;
        }
        catch (TimeFormatException e) {
            MraldException mess = new MraldException(e.getMessage());
            throw mess;
        }
    }

    @Override
    public String preProcess(MsgObject msg, String currentName) {
        if (msg.getValue("EnableTime")[0].equals("EndTime")) {
            this.endDateSelected = true;
        } else if (msg.getValue("EnableTime")[0].equals("StartTime")) {
            this.startDateSelected = true;
        }
        String[] groupTags = new String[]{"Day", "EnableTime", "EndDate", "EndTime", "Function", "Hour", "Minute", "Month", "Second", "StartDate", "StartTime", "Time"};
        this.collectElementGroup(msg, currentName, groupTags);
        return currentName;
    }

    private Calendar buildTimeEnd(int i, String startTimeVal) throws MraldException {
        try {
            String empty = "";
            Calendar startTime = (Calendar)TimeFormatter.formatDateTime(startTimeVal, true);
            String monthAdd = this.nameValues.getValue("Month")[i];
            String dayAdd = this.nameValues.getValue("Day")[i];
            String hourAdd = this.nameValues.getValue("Hour")[i];
            String minuteAdd = this.nameValues.getValue("Minute")[i];
            String secondsAdd = this.nameValues.getValue("Second")[i];
            if (monthAdd.equals(empty) && dayAdd.equals(empty) && hourAdd.equals(empty) && minuteAdd.equals(empty) && secondsAdd.equals(empty)) {
                MraldException noTime = new MraldException("You must select a date to add.");
                throw noTime;
            }
            if (!monthAdd.equals(empty)) {
                startTime.add(2, new Integer(monthAdd));
            }
            if (!dayAdd.equals(empty)) {
                startTime.add(5, new Integer(dayAdd));
            }
            if (!hourAdd.equals(empty)) {
                startTime.add(10, new Integer(hourAdd));
            }
            if (!minuteAdd.equals(empty)) {
                startTime.add(12, new Integer(minuteAdd));
            }
            if (!secondsAdd.equals(empty)) {
                startTime.add(13, new Integer(secondsAdd));
            }
            startTime.set(14, 0);
            startTime.add(14, -1);
            return startTime;
        }
        catch (TimeFormatException e) {
            MraldException qbe = new MraldException(e.getMessage());
            throw qbe;
        }
    }

    private Calendar buildTimeStart(int i, String startTimeVal) throws MraldException {
        try {
            String empty = "";
            Calendar startTime = (Calendar)TimeFormatter.formatDateTime(startTimeVal, true);
            String monthAdd = this.nameValues.getValue("Month")[i];
            String dayAdd = this.nameValues.getValue("Day")[i];
            String hourAdd = this.nameValues.getValue("Hour")[i];
            String minuteAdd = this.nameValues.getValue("Minute")[i];
            String secondsAdd = this.nameValues.getValue("Second")[i];
            if (monthAdd.equals(empty) && dayAdd.equals(empty) && hourAdd.equals(empty) && minuteAdd.equals(empty) && secondsAdd.equals(empty)) {
                MraldException noTime = new MraldException("You must select a date to add.");
                throw noTime;
            }
            int negInt = -1;
            if (!monthAdd.equals(empty)) {
                startTime.add(2, new Integer(monthAdd) * negInt);
            }
            if (!dayAdd.equals(empty)) {
                startTime.add(5, new Integer(dayAdd) * negInt);
            }
            if (!hourAdd.equals(empty)) {
                startTime.add(10, new Integer(hourAdd) * negInt);
            }
            if (!minuteAdd.equals(empty)) {
                startTime.add(12, new Integer(minuteAdd) * negInt);
            }
            if (!secondsAdd.equals(empty)) {
                startTime.add(13, new Integer(secondsAdd) * negInt);
            }
            startTime.set(14, 0);
            startTime.add(14, 1);
            return startTime;
        }
        catch (TimeFormatException e) {
            MraldException qbe = new MraldException(e.getMessage());
            throw qbe;
        }
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) {
        String[] table = this.nameValues.getValue("Table");
        String[] field = this.nameValues.getValue("Field");
        if (table[0].equals("") || field[0].equals("")) {
            this.isActive = false;
        }
        return currentName;
    }
}

