/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MraldException;

public class UpdateBuilder
extends AbstractStep {
    private ArrayList<String> fromStrings = new ArrayList();
    private MsgObject msg;
    private ArrayList<String> selectStrings = new ArrayList();
    private ArrayList<String> whereAndStrings = new ArrayList();

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            this.buildQueryComponents(msgObject.getWorkingObjects());
            String query = this.buildQuery();
            msgObject.setQuery(query);
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e, this.msg);
        }
    }

    private String buildQuery() throws MraldException {
        String finalQueryString = "UPDATE ";
        if (this.fromStrings.size() > 1) {
            throw new MraldException("You may only update one table at a time");
        }
        String this_fstr = this.fromStrings.get(0);
        finalQueryString = finalQueryString + this_fstr;
        finalQueryString = finalQueryString + this.values(this.selectStrings, " SET");
        if (this.whereAndStrings.size() > 0) {
            finalQueryString = finalQueryString + " Where ";
            for (int l = 0; l < this.whereAndStrings.size(); ++l) {
                String this_wstr = this.whereAndStrings.get(l);
                finalQueryString = finalQueryString + this_wstr;
                if (l >= this.whereAndStrings.size() - 1) continue;
                finalQueryString = finalQueryString + " AND ";
            }
        }
        return finalQueryString;
    }

    private void buildQueryComponents(ArrayList qe) throws MraldException {
        if (qe.size() == 0) {
            throw new MraldException("You must select output data to proceed. Please make selection from Output Data Selection list and resubmit.");
        }
        SqlElements this_qe = null;
        for (int k = 0; k < qe.size(); ++k) {
            this_qe = (SqlElements)qe.get(k);
            if (this_qe == null) continue;
            this.fromStrings = this_qe.buildFrom(this.fromStrings);
            this.whereAndStrings = this_qe.buildWhereAnd(this.whereAndStrings);
            this.selectStrings = this_qe.buildSelect(this.selectStrings);
        }
    }

    private String values(ArrayList selectStrings, String leadIn) {
        String returnString = leadIn + " ";
        Iterator it = selectStrings.iterator();
        while (it.hasNext()) {
            returnString = returnString + it.next();
            if (!it.hasNext()) continue;
            returnString = returnString + ", ";
        }
        return returnString;
    }
}

