/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.specOutput;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.specOutput.CommonLineInfo;
import org.mitre.mrald.specOutput.ConstraintInfo;
import org.mitre.mrald.specOutput.LineElement;
import org.mitre.mrald.specOutput.SpecOutputException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.TimeFormatException;
import org.mitre.mrald.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line {
    public String queryId;
    public String queryType;
    private String fileName;
    private HashMap fileOutputs;
    private CommonLineInfo commonLine = null;
    public String queryConstraintId;
    private ArrayList<ConstraintInfo> queryConstraints;
    private String queryString = " ";
    private ArrayList<LineElement> localLineElements;
    private ArrayList<Line> subLines;
    private String thisProject;
    private String missingEquipment = "";
    private boolean isEquipMissing = false;
    private boolean checkEquip = false;
    private String defaultEquipType = "????";
    private PreparedStatement ps;
    private Connection conn;
    private ResultSet rs;
    protected SQLException sqlExceptionMessage;
    private static final boolean DEBUG = false;

    public Line() throws SQLException {
        this.rs = null;
        this.conn = new MraldConnection(Config.getProperty("DBSERVER"), Config.getProperty("DBDRIVER"), Config.getProperty("DBLOGIN"), Config.getProperty("DBPASSWORD")).getConnection();
        this.ps = null;
        this.thisProject = null;
        this.commonLine = new CommonLineInfo();
    }

    public Line(Connection thisConnection) {
        this.ps = null;
        this.rs = null;
        this.conn = thisConnection;
        this.thisProject = null;
    }

    public Line(Connection thisConnection, String projectType) {
        this.ps = null;
        this.rs = null;
        this.conn = thisConnection;
        this.thisProject = projectType;
    }

    public void setFileOutputs(HashMap thisFileOutputs) throws SpecOutputException {
        this.fileOutputs = thisFileOutputs;
    }

    public HashMap getFileOuputs() throws SpecOutputException {
        return this.fileOutputs;
    }

    public void closeLocalFileWriter() {
    }

    public void buildPreparedQuery() throws SpecOutputException {
        if (this.queryString.length() < 5) {
            return;
        }
        String newConstraint = null;
        String orderBy = null;
        int orderByIndex = this.queryString.lastIndexOf(" ORDER BY");
        if (orderByIndex != -1) {
            orderBy = this.queryString.substring(orderByIndex);
            this.queryString = this.queryString.substring(0, orderByIndex);
        }
        for (int b = 0; b < this.queryConstraints.size(); ++b) {
            ConstraintInfo ci = this.queryConstraints.get(b);
            String tableName = ci.queryConstraintTableName;
            String localColumnNm = ci.localColumnName;
            newConstraint = this.queryString.lastIndexOf("WHERE") == -1 ? " WHERE " + tableName + "." + localColumnNm + " = ? " : " AND " + tableName + "." + localColumnNm + " = ? ";
            this.queryString = this.queryString + newConstraint;
        }
        if (orderByIndex != -1) {
            this.queryString = this.queryString + orderBy;
        }
    }

    public void updateQueryString(String newQuery) {
        this.queryString = newQuery;
    }

    public void updateQueryConstraints(ResultSet rs, int cRow) throws SpecOutputException {
        String bindValue = null;
        try {
            for (int b = 0; b < this.queryConstraints.size(); ++b) {
                ConstraintInfo ci = this.queryConstraints.get(b);
                String constraintColumn = ci.queryConstraintName;
                bindValue = rs.getString(constraintColumn);
                if (constraintColumn.startsWith("equip")) {
                    this.checkEquip = true;
                    this.missingEquipment = bindValue;
                }
                if (bindValue == null) {
                    SpecOutputException spec = new SpecOutputException(" Column " + constraintColumn + " in sub query does not exist in parent query: ");
                    throw spec;
                }
                String typeFormat = ci.queryConstraintFormat;
                if (typeFormat.equals("number")) {
                    this.ps.setLong(b + 1, Long.parseLong(bindValue));
                    continue;
                }
                if (typeFormat.equals("date")) {
                    String newDate = this.convertFromOraTime(bindValue);
                    Calendar thisDate = (Calendar)TimeFormatter.formatDateTime(newDate, true);
                    Date sqlDate = new Date(thisDate.getTime().getTime());
                    this.ps.setDate(b + 1, sqlDate);
                    continue;
                }
                this.ps.setString(b + 1, bindValue);
            }
        }
        catch (NumberFormatException ne) {
            SpecOutputException spec = new SpecOutputException("Bind value " + bindValue + " is not a number");
            ne.printStackTrace();
            throw spec;
        }
        catch (TimeFormatException tfe) {
            SpecOutputException spec = new SpecOutputException("Timeformatter Error with " + bindValue);
            tfe.printStackTrace();
            throw spec;
        }
        catch (SQLException se) {
            System.out.println("SQL Exception in Line:updateQueryConstraints" + se.getMessage() + this.queryString);
            se.printStackTrace();
            SpecOutputException spec = new SpecOutputException(se.getMessage());
            throw spec;
        }
    }

    public String processReport(ResultSet incomingRs, int cRow, MsgObject msg, BufferedWriter outFile, String prevFileName) throws ServletException, IOException, SQLException, MsgObjectException, SpecOutputException {
        boolean noQuery = true;
        try {
            ArrayList<LineElement> postElements = new ArrayList<LineElement>();
            PrintWriter out = msg.getOutPrintWriter();
            if (this.conn == null) {
                this.conn = new MraldConnection(Config.getProperty("DBSERVER"), Config.getProperty("DBDRIVER"), Config.getProperty("DBLOGIN"), Config.getProperty("DBPASSWORD")).getConnection();
            }
            if (this.ps == null) {
                this.ps = this.conn.prepareStatement(this.queryString);
            }
            if (incomingRs != null && this.queryString != null && this.queryString.length() > 5) {
                this.updateQueryConstraints(incomingRs, cRow);
            }
            if (this.queryString != null && this.queryString.length() > 5) {
                this.rs = this.ps.executeQuery();
                if (this.checkEquip) {
                    if (!this.rs.next()) {
                        this.isEquipMissing = true;
                        this.checkEquip = false;
                        this.ps.setString(1, this.defaultEquipType);
                    }
                    this.rs = this.ps.executeQuery();
                }
                noQuery = false;
            } else {
                this.rs = incomingRs;
            }
            int current_row = 0;
            String formatString = "";
            if (this.fileName != prevFileName && (outFile = (BufferedWriter)this.fileOutputs.get(this.fileName)) == null) {
                SpecOutputException spec = new SpecOutputException("File " + this.fileName + " not found.");
                throw spec;
            }
            if (noQuery) {
                for (int i = 0; i < this.localLineElements.size(); ++i) {
                    LineElement thisLineelem = this.localLineElements.get(i);
                    formatString = thisLineelem.formatOutput(this.rs, formatString, current_row, this);
                }
                if (this.thisProject == null) {
                    this.thisProject = CommonLineInfo.getProject();
                }
                if (this.thisProject.startsWith("DPAT")) {
                    outFile.write(formatString);
                } else if (this.fileName.equals("toScreen")) {
                    out.print(formatString);
                } else {
                    outFile.write(formatString);
                    outFile.flush();
                }
                formatString = "";
                ++current_row;
            } else {
                int count = 0;
                while (this.rs.next()) {
                    LineElement thisLineelem;
                    int i;
                    ++count;
                    for (i = 0; i < this.localLineElements.size(); ++i) {
                        thisLineelem = this.localLineElements.get(i);
                        if (thisLineelem.getOrder().equals("POST")) {
                            thisLineelem.setValue(this.rs);
                            postElements.add(thisLineelem);
                            continue;
                        }
                        formatString = thisLineelem.formatOutput(this.rs, formatString, current_row, this);
                    }
                    if (this.thisProject.startsWith("DPAT")) {
                        outFile.write(formatString);
                    } else if (this.fileName.equals("toScreen")) {
                        out.print(formatString);
                        out.flush();
                    } else {
                        outFile.write(formatString);
                        outFile.flush();
                    }
                    formatString = "";
                    if (this.subLines.size() > 0) {
                        for (int j = 0; j < this.subLines.size(); ++j) {
                            Line thisSubLine = this.subLines.get(j);
                            thisSubLine.setFileOutputs(this.fileOutputs);
                            thisSubLine.setCommonLineInfo(this.commonLine);
                            thisSubLine.processReport(this.rs, current_row, msg, outFile, this.fileName);
                        }
                    }
                    formatString = "";
                    for (i = 0; i < postElements.size(); ++i) {
                        thisLineelem = (LineElement)postElements.get(i);
                        formatString = thisLineelem.formatOutput(formatString, current_row, this);
                    }
                    if (this.thisProject.startsWith("DPAT")) {
                        outFile.write(formatString);
                    } else if (this.fileName.equals("toScreen")) {
                        out.print(formatString);
                    } else {
                        outFile.write(formatString);
                    }
                    formatString = "";
                    ++current_row;
                }
            }
            if (this.thisProject == null) {
                this.thisProject = CommonLineInfo.getProject();
            }
            if (this.thisProject.startsWith("DPAT") && this.isEquipMissing) {
                String updateEquip = "The EQUIP_UPGRADE table needs the new type:" + this.missingEquipment;
                out.println("<HTML>");
                out.println(" CONTINUING WITH THE DEFAULT VALUES:");
                out.println(updateEquip);
                out.println("<br>");
                out.println("</HTML>");
                this.isEquipMissing = false;
                this.missingEquipment = "";
            }
            if (this.thisProject.equals("DPAT_MATRIX") & this.queryType.equals("1")) {
                String MATRIXFileLink = "<a href = \"" + Config.getProperty("BaseUrl") + "/" + this.fileName + "\"> Press here to get your MATRIX File </a> <br>";
                out.println("<HTML>");
                out.println(" <h3> Your MATRIX Files Request Was Successfully Initiated </h3> <br> <i> <b> **SAVE THESE LINKS, YOU MAY NOT BE ABLE TO USE YOUR BACK BUTTON LATER ** </b></i><br> <p> <br>");
                out.println(MATRIXFileLink);
                out.println(" <p><br> Note: To Save information to a file <br> 1. Press your right mouse key with the cursor over the link <br> 2. Select <i> Save Link As </i> to save <br>");
                out.println("</HTML>");
            }
            if (this.thisProject.equals("MLM") & this.queryType.equals("1")) {
                String MATRIXFileLink = "<a href = \"" + Config.getProperty("BaseUrl") + "/" + this.fileName + "\"> Hyperlink to your SFG Generated File</a> <br>";
                out.println("<html> <head> <title>Specialized Format Generation (SFG) File Retrieval</title> </head> <body> &nbsp; <table BORDER CELLSPACING=0 CELLPADDING=0 WIDTH=\"75%\" > <tr BGCOLOR=\"#66FFFF\"> <td> <center><b><font face=\"Arial,Helvetica\"><font color=\"#333333\"><font size=+3>Specialized Format Generation (SFG)</font></font></font></b> <br><b><font face=\"Arial,Helvetica\"><font color=\"#333333\"><font size=+3>File Retrieval&nbsp;</font></font></font></b></center> </td> </tr> </table> <table BORDER CELLSPACING=0 CELLPADDING=0 WIDTH=\"75%\" > <tr> <td> <center><font size=+1>A File has been generated for you using the SFG Component.&nbsp;&nbsp;</font> <br><font size=+1>The file is accessible at the following hyperlink:</font></center> <font size=+1></font></td> </tr> <tr> <td> <center> <br> ");
                out.println(MATRIXFileLink);
                out.println("</center> </td> </tr> </table> <table BORDER CELLSPACING=0 CELLPADDING=0 WIDTH=\"75%\" > <tr> <td><b>Note: </b>To Save information to a local file on your personal computer&nbsp; <ol> <li> Press your right mouse key with the cursor over the link&nbsp;</li> <li> Press <i>Save Link As </i>to save&nbsp;</li> </ol> </td> </tr> <tr> <td><b>Warnings:&nbsp;</b> <ol start=1 type=1> <li> Any new file generated from the same query form will <i>overwrite</i> this file.&nbsp;</li> <li> In consideration of CRS disk space, SFG files are purged weekly.</li> </ol> </td> </tr> </table> </body> </html> ");
            }
            if (this.thisProject.equals("DPAT") & this.queryType.equals("1")) {
                String sendLink = "<a href = \"" + Config.getProperty("BaseUrl") + "/FDG/itineraries\"> Press here to get your Itinerary File </a> ";
                out.println("<HTML>");
                out.println(" <h3> Your Itinerary File Request Was Successfully Initiated </h3> <br> Shortly your itinerary file will be generated at the following link <br>");
                out.println(sendLink);
                out.println("</HTML>");
            }
            if (this.thisProject.equals("TAAM") & this.queryType.equals("1")) {
                String trafficFileLink = "<a href = \"" + Config.getProperty("BaseUrl") + "/data/" + msg.getUserId() + "-TimeTable\"> Press here to get your TAAM Traffic File </a> <br>";
                String waypointFileLink = "<a href = \"" + Config.getProperty("BaseUrl") + "/data/" + msg.getUserId() + "-Waypoints\"> Press here to get your Waypoints File </a> ";
                out.println("<HTML>");
                out.println(" <h3> Your TAAM Files Request Was Successfully Initiated </h3> <br> <i> <b> **SAVE THESE LINKS, YOU MAY NOT BE ABLE TO USE YOUR BACK BUTTON LATER ** </b></i><br> <p> <br>");
                out.println(trafficFileLink);
                out.println(waypointFileLink);
                out.println(" <p><br> Note: To Save information to a file <br> 1. Press your right mouse key with the cursor over the link <br> 2. Select <i> Save Link As </i> to save <br>");
                out.println("</HTML>");
            }
            if (this.thisProject.equals("ACES") & this.queryType.equals("1")) {
                String AcesFileLink = "<a href = \"" + Config.getProperty("BaseUrl") + "/" + this.fileName + "\"> Press here to get your ACES XML File </a> <br>";
                out.println("<HTML>");
                out.println(" <h3> Your ACES Files Request Was Successfully Initiated </h3> <br> <i> <b> **SAVE THESE LINKS, YOU MAY NOT BE ABLE TO USE YOUR BACK BUTTON LATER ** </b></i><br> <p> <br>");
                out.println(AcesFileLink);
                out.println(" <p><br> Note: To Save information to a file <br> 1. Press your right mouse key with the cursor over the link <br> 2. Select <i> Save Link As </i> to save <br>");
                out.println("</HTML>");
            }
            return this.thisProject;
        }
        catch (SpecOutputException sote) {
            System.out.println("Special Output Exception in Line: " + sote.getMessage());
            sote.printStackTrace();
            throw sote;
        }
        catch (SQLException se) {
            System.out.println("SQL Exception in Line: " + se.getMessage());
            se.printStackTrace();
            throw se;
        }
        catch (MsgObjectException moe) {
            System.out.println("MsgOBject Exception in Line: " + moe.getMessage());
            moe.printStackTrace();
            throw moe;
        }
        catch (ServletException se) {
            System.out.println("SQL Exception in Line: " + se.getMessage());
            se.printStackTrace();
            throw se;
        }
        catch (Exception exc) {
            SpecOutputException spec = new SpecOutputException(exc.getMessage());
            exc.printStackTrace();
            throw spec;
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getThisProject() {
        return this.thisProject;
    }

    public void setThisProject(String projectType) {
        this.thisProject = projectType;
    }

    public void createSubLines() {
        this.subLines = new ArrayList();
    }

    public void addSubLines(Line subLine) {
        this.subLines.add(subLine);
    }

    public ArrayList<Line> getSubLines() {
        return this.subLines;
    }

    public void createQueryConstraints() {
        this.queryConstraints = new ArrayList();
    }

    public void addQueryConstraints(ConstraintInfo constraint) {
        this.queryConstraints.add(constraint);
    }

    public ArrayList<ConstraintInfo> getQueryConstraints() {
        return this.queryConstraints;
    }

    public void createLocalLineElements() {
        this.localLineElements = new ArrayList();
    }

    public void addLocalLineElements(LineElement lineElement) {
        this.localLineElements.add(lineElement);
    }

    public ArrayList<LineElement> getLocalLineElements() {
        return this.localLineElements;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String thisFileName) {
        this.fileName = thisFileName;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String thisQueryString) {
        this.queryString = thisQueryString;
    }

    public CommonLineInfo getCommonLineInfo() {
        return this.commonLine;
    }

    public void setCommonLineInfo(CommonLineInfo thisCommonLine) {
        this.commonLine = thisCommonLine;
    }

    public String convertFromOraTime(String otime) {
        String year = otime.substring(0, 4);
        String month = otime.substring(5, 7);
        String day = otime.substring(8, 10);
        String hour = otime.substring(11, 13);
        String minute = otime.substring(14, 16);
        String second = otime.substring(17, 19);
        String calTime = month + "/" + day + "/" + year + " " + hour + ":" + minute + ":" + second;
        return calTime;
    }
}

