/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.specOutput;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.specOutput.Line;
import org.mitre.mrald.specOutput.SpecOutputException;
import org.mitre.mrald.specOutput.TranslateXML;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;

public class Mqp
extends AbstractStep {
    protected static Statement stmt;
    protected static Connection conn;
    protected int recordsReturned;
    protected float bytesReturned;
    protected static ResultSet rs;
    protected SQLException sqlExceptionMessage;
    public static String projectName;

    public Mqp() {
        stmt = null;
        rs = null;
        conn = null;
    }

    public ResultSet getQryResultsinRS() {
        return rs;
    }

    public static String addUserConstraints(MsgObject msg, Line ml) {
        boolean justAddedWhere = false;
        String returnQueryString = ml.getQueryString();
        String orderBy = null;
        int orderByIndex = returnQueryString.lastIndexOf(" ORDER BY");
        if (orderByIndex != -1) {
            orderBy = returnQueryString.substring(orderByIndex);
            returnQueryString = returnQueryString.substring(0, orderByIndex);
        }
        if (returnQueryString.lastIndexOf("WHERE") == -1) {
            returnQueryString = returnQueryString + " WHERE ";
            justAddedWhere = true;
        }
        if (projectName.startsWith("DPAT")) {
            if (!justAddedWhere) {
                returnQueryString = returnQueryString + " AND ";
            }
            returnQueryString = returnQueryString + Mqp.AddFilterInfo(msg);
        }
        String whereString = msg.getQuery()[0];
        returnQueryString = Mqp.compareTables(whereString, returnQueryString);
        whereString = Mqp.getWhereString(whereString);
        if (!justAddedWhere) {
            whereString = " AND " + whereString;
        }
        returnQueryString = returnQueryString + whereString;
        if (orderByIndex != -1) {
            returnQueryString = returnQueryString + orderBy;
        }
        return returnQueryString;
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            String xmlFile = msgObject.getValue("formatXML")[0];
            if (xmlFile.equals("")) {
                // empty if block
            }
            String dPatPath = Config.getProperty("specialFormatXmlLocation") + xmlFile;
            TranslateXML myParser = new TranslateXML(dPatPath, msgObject);
            Line totalLine = myParser.ProcessXML();
            projectName = totalLine.getThisProject();
            totalLine.updateQueryString(Mqp.addUserConstraints(msgObject, totalLine));
            msgObject.SetOutPrintWriter();
            msgObject.setContentType("text/html");
            totalLine.setFileOutputs(myParser.getFileOutputs());
            BufferedWriter outFile = (BufferedWriter)totalLine.getFileOuputs().get(totalLine.getFileName());
            if (outFile == null) {
                WorkflowStepException spec = new WorkflowStepException("The file " + totalLine.getFileName() + " could not be found.");
                throw spec;
            }
            totalLine.processReport(null, 0, msgObject, outFile, totalLine.getFileName());
            if (!projectName.equals("DPAT") && projectName.equals("TAAM")) {
                String taamPath = Config.getProperty("taamPath");
                Runtime.getRuntime().exec(taamPath + "WEB-INF/taamPostProc.sh " + taamPath + "data/" + msgObject.getUserId() + "-Waypoints");
            }
        }
        catch (SpecOutputException se) {
            WorkflowStepException we = new WorkflowStepException(se.getMessage());
            throw we;
        }
        catch (ServletException se) {
            WorkflowStepException we = new WorkflowStepException(se.getMessage());
            throw we;
        }
        catch (MsgObjectException moe) {
            WorkflowStepException we = new WorkflowStepException(moe.getMessage());
            throw we;
        }
        catch (SQLException se) {
            WorkflowStepException we = new WorkflowStepException(se.getMessage());
            throw we;
        }
        catch (IOException ioe) {
            WorkflowStepException we = new WorkflowStepException(ioe.getMessage());
            throw we;
        }
        catch (Exception e) {
            e.printStackTrace();
            WorkflowStepException we = new WorkflowStepException(e.getMessage());
            throw we;
        }
    }

    public ResultSet returnResultsToUser() {
        return rs;
    }

    private static String getWhereString(String query) {
        String whereString = null;
        int whereIndex = query.toUpperCase().indexOf("WHERE ");
        if (whereIndex > 0) {
            whereString = query.substring(whereIndex + 5, query.length());
        }
        return whereString;
    }

    private static String compareTables(String query, String xmlQuery) {
        ArrayList<String> tablesFromForm = MiscUtils.getTables(query, true);
        ArrayList<String> tablesFromXml = MiscUtils.getTables(xmlQuery, true);
        for (int i = 0; i < tablesFromForm.size(); ++i) {
            String prevQuery = xmlQuery;
            String table = tablesFromForm.get(i).toString();
            if (!(!tablesFromXml.contains(table) & table.length() > 3)) continue;
            int whereIndex = xmlQuery.toUpperCase().indexOf("WHERE ");
            xmlQuery = prevQuery.substring(0, whereIndex) + "," + table + " " + prevQuery.substring(whereIndex, prevQuery.length());
        }
        return xmlQuery;
    }

    public static String AddFilterInfo(MsgObject msgObj) {
        String keyStr;
        int b;
        String[] key;
        int i;
        String where = new String();
        boolean changed = false;
        where = "(deptairport in (select oagcode from airport";
        for (i = 1; i <= 3; ++i) {
            key = msgObj.getValue("OriginatingFilter" + i);
            for (b = 0; b < key.length; ++b) {
                keyStr = key[b];
                if (keyStr.equals("")) continue;
                if (!changed) {
                    where = where + " WHERE " + keyStr;
                    changed = true;
                    continue;
                }
                where = where + " OR " + keyStr;
            }
        }
        changed = false;
        where = where + ") and arrairport in (select oagcode from airport";
        for (i = 1; i <= 3; ++i) {
            key = msgObj.getValue("DestinationFilter" + i);
            for (b = 0; b < key.length; ++b) {
                keyStr = key[b];
                if (keyStr.equals("")) continue;
                if (!changed) {
                    where = where + " WHERE " + keyStr;
                    changed = true;
                    continue;
                }
                where = where + " OR " + keyStr;
            }
        }
        where = where + "))";
        return where;
    }
}

