/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.specOutput;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.specOutput.CommonLineInfo;
import org.mitre.mrald.specOutput.ConstraintInfo;
import org.mitre.mrald.specOutput.Line;
import org.mitre.mrald.specOutput.LineElement;
import org.mitre.mrald.specOutput.SpecOutputException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TranslateXML {
    private static String LINE_TAG = "Line";
    private static String LINE_ID_TAG = "id";
    private static String LINE_TYPE_TAG = "type";
    private static String FILE_NAME_TAG = "fileName";
    private static String LINE_QUERY_CONSTRAINT_TAG = "constraintOnID";
    private static String QUERY_STRING_TAG = "QueryString";
    private static String QUERY_CONSTRAINT_TAG = "QueryConstraint";
    private static String QUERY_TAG = "Query";
    private static String ELEMENT_TAG = "Element";
    private static String ELEMENT_NUMBER_TAG = "number";
    private static String DB_TABLE_TAG = "DBTable";
    private static String DB_FIELD_TAG = "DBField";
    private static String STATIC_VALUE_TAG = "StaticValue";
    private static String TYPE_TAG = "Type";
    private static String SPECIAL_TRANSFORM_TAG = "SpecialTransform";
    private static String PROJECT_TAG = "name";
    private MsgObject msgObject = null;
    private String XMLFile = null;
    private String projectTag = PROJECT_TAG;
    private String lineTypeTag = LINE_TYPE_TAG;
    private String fileNameTag = FILE_NAME_TAG;
    private String lineTag = LINE_TAG;
    private String lineIdTag = LINE_ID_TAG;
    private String lineQueryConstraintTag = LINE_QUERY_CONSTRAINT_TAG;
    private String queryStringTag = QUERY_STRING_TAG;
    private String queryConstraintTag = QUERY_CONSTRAINT_TAG;
    private String queryTag = QUERY_TAG;
    private String elementTag = ELEMENT_TAG;
    private String elementNumberTag = ELEMENT_NUMBER_TAG;
    private String dbTableTag = DB_TABLE_TAG;
    private String dbFieldTag = DB_FIELD_TAG;
    private String staticValueTag = STATIC_VALUE_TAG;
    private String formatTypeTag = TYPE_TAG;
    private String specialTransformTag = SPECIAL_TRANSFORM_TAG;
    private String projectOutputType;
    private String orderTag = "Order";
    private int loopCount = 0;
    private int loopCountMax = 4;
    private HashMap<String, BufferedWriter> fileOutputs = new HashMap();

    public TranslateXML(String sXMLFile, MsgObject msgObject) {
        this.msgObject = msgObject;
        this.XMLFile = sXMLFile;
    }

    public Line ProcessXML() throws SpecOutputException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.XMLFile);
            Element rootElement = document.getDocumentElement();
            this.projectOutputType = rootElement.getAttribute(this.projectTag);
            if (!rootElement.hasChildNodes()) {
                System.out.println(" BAD PARSE");
            }
            Line mainLine = new Line();
            CommonLineInfo.startDate = null;
            CommonLineInfo.startDateSet = false;
            mainLine.setThisProject(this.projectOutputType);
            mainLine.createLocalLineElements();
            mainLine.createSubLines();
            mainLine.createQueryConstraints();
            NodeList lineNodes = rootElement.getElementsByTagName(this.lineTag);
            this.ProcessLineNodesMain(lineNodes, mainLine);
            return mainLine;
        }
        catch (SQLException sqlE) {
            SpecOutputException spec = new SpecOutputException(sqlE.getMessage());
            throw spec;
        }
        catch (SAXParseException spe) {
            System.out.println("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId() + spe.getMessage());
            SpecOutputException spec = new SpecOutputException(spe.getMessage() + "\n** Parsing error" + ", line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            throw spec;
        }
        catch (SAXException spe) {
            System.out.println("SAX Error in Translate" + spe.getMessage());
            SpecOutputException spec = new SpecOutputException(spe.getMessage());
            throw spec;
        }
        catch (DOMException de) {
            System.out.println("DomException Error in Translate" + de.getMessage());
            SpecOutputException spec = new SpecOutputException(de.getMessage());
            throw spec;
        }
        catch (IOException ioe) {
            System.out.println("IOException Error in Translate" + ioe.getMessage());
            SpecOutputException spec = new SpecOutputException(ioe.getMessage());
            throw spec;
        }
        catch (ParserConfigurationException pce) {
            System.out.println("ParserConfException Error in Translate" + pce.getMessage());
            SpecOutputException spec = new SpecOutputException(pce.getMessage());
            throw spec;
        }
    }

    public Line ProcessLineNodesMain(NodeList lineNodes, Line thisLine) throws SpecOutputException {
        try {
            for (int k = 0; k < lineNodes.getLength(); ++k) {
                Element line = (Element)lineNodes.item(k);
                String lineType = line.getAttribute(this.lineTypeTag);
                if (!lineType.equals("1")) continue;
                thisLine.queryId = line.getAttribute(this.lineIdTag);
                String fileName = line.getAttribute(this.fileNameTag);
                if (!fileName.equals("toScreen")) {
                    fileName = this.msgObject.getUserId() + "-" + fileName;
                }
                thisLine.setFileName(fileName);
                if (!this.fileOutputs.containsKey(fileName)) {
                    String project = thisLine.getThisProject();
                    BufferedWriter outFile = null;
                    if (project.equals("DPAT")) {
                        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Translate XML: DPAT Output : Filename : " + Config.getProperty("dpatPath") + fileName);
                        outFile = new BufferedWriter(new FileWriter(Config.getProperty("dpatPath") + fileName));
                    } else if (project.equals("TAAM")) {
                        String filePath = Config.getProperty("taamPath") + "data/" + fileName;
                        File file = new File(filePath);
                        file.delete();
                        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Translate XML: TAAM Output : Filename : " + filePath);
                        outFile = new BufferedWriter(new FileWriter(filePath));
                    } else {
                        outFile = new BufferedWriter(new FileWriter(Config.getProperty("LOGPATH") + fileName));
                    }
                    this.fileOutputs.put(fileName, outFile);
                }
                thisLine.queryType = line.getAttribute(this.lineTypeTag);
                NodeList tempNode = line.getElementsByTagName(this.queryTag);
                Node queryElement = tempNode.item(0);
                Element thisElement = (Element)queryElement;
                NodeList queryStringElement = thisElement.getElementsByTagName(this.queryStringTag);
                queryElement = queryStringElement.item(0);
                thisLine.setQueryString(queryElement.getFirstChild().getNodeValue());
                tempNode = line.getElementsByTagName(this.queryTag);
                queryElement = tempNode.item(0);
                thisElement = (Element)queryElement;
                NodeList queryConstraintElement = thisElement.getElementsByTagName(this.queryConstraintTag);
                for (int b = 0; b < queryConstraintElement.getLength(); ++b) {
                    Node constraintNode = queryConstraintElement.item(b);
                    Element constraintElement = (Element)queryConstraintElement.item(b);
                    thisLine.addQueryConstraints(new ConstraintInfo(constraintElement.getAttribute("format"), constraintElement.getAttribute("type"), constraintElement.getAttribute("local_name"), constraintElement.getAttribute("table_name"), constraintNode.getFirstChild().getNodeValue()));
                }
                thisLine.buildPreparedQuery();
                k = lineNodes.getLength() + 1;
                NodeList LelemNode = line.getElementsByTagName(this.elementTag);
                this.ProcessLineElementNodes(LelemNode, thisLine);
                this.ProcessLineNodes(lineNodes, thisLine);
            }
            return thisLine;
        }
        catch (IOException ioe) {
            SpecOutputException spec = new SpecOutputException(ioe.getMessage());
            throw spec;
        }
    }

    public boolean ProcessLineNodes(NodeList lineNodes, Line thisLine) throws SpecOutputException {
        try {
            ++this.loopCount;
            boolean finish = false;
            for (int k = 0; k < lineNodes.getLength(); ++k) {
                String queryString;
                if (this.loopCount == this.loopCountMax) {
                    finish = true;
                }
                Element line = (Element)lineNodes.item(k);
                String lineType = line.getAttribute(this.lineTypeTag);
                String constraintType = line.getAttribute(this.lineQueryConstraintTag);
                if (!lineType.equals("2") || !constraintType.equals(thisLine.queryId)) continue;
                Line subLine = new Line(thisLine.getConnection(), thisLine.getThisProject());
                subLine.createLocalLineElements();
                subLine.createQueryConstraints();
                subLine.createSubLines();
                subLine.queryId = line.getAttribute(this.lineIdTag);
                subLine.queryType = line.getAttribute(this.lineTypeTag);
                String fileName = line.getAttribute(this.fileNameTag);
                if (!fileName.equals("toScreen")) {
                    fileName = this.msgObject.getUserId() + "-" + fileName;
                }
                subLine.setFileName(fileName);
                if (!this.fileOutputs.containsKey(fileName)) {
                    String project = subLine.getThisProject();
                    BufferedWriter outFile = null;
                    if (project.equals("TAAM")) {
                        String filePath = Config.getProperty("taamPath") + "data/" + fileName;
                        File file = new File(filePath);
                        file.delete();
                        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Translate XML: TAAM Output : Filename : " + filePath);
                        outFile = new BufferedWriter(new FileWriter(filePath));
                    } else {
                        outFile = new BufferedWriter(new FileWriter(Config.getProperty("LOGPATH") + fileName));
                    }
                    this.fileOutputs.put(fileName, outFile);
                }
                subLine.queryConstraintId = thisLine.queryId;
                NodeList stempNode = line.getElementsByTagName(this.queryTag);
                Node squeryElement = stempNode.item(0);
                Element sthisElement = (Element)squeryElement;
                NodeList squeryStringElement = sthisElement.getElementsByTagName(this.queryStringTag);
                if (squeryStringElement.getLength() > 0 && (squeryElement = squeryStringElement.item(0)) != null && squeryElement.getFirstChild() != null && (queryString = squeryElement.getFirstChild().getNodeValue()) != null) {
                    subLine.setQueryString(queryString);
                }
                stempNode = line.getElementsByTagName(this.queryTag);
                squeryElement = stempNode.item(0);
                sthisElement = (Element)squeryElement;
                NodeList squeryConstraintElement = sthisElement.getElementsByTagName(this.queryConstraintTag);
                for (int b = 0; b < squeryConstraintElement.getLength(); ++b) {
                    Node sconstraintNode = squeryConstraintElement.item(b);
                    Element sconstraintElement = (Element)squeryConstraintElement.item(b);
                    subLine.addQueryConstraints(new ConstraintInfo(sconstraintElement.getAttribute("format"), sconstraintElement.getAttribute("type"), sconstraintElement.getAttribute("local_name"), sconstraintElement.getAttribute("table_name"), sconstraintNode.getFirstChild().getNodeValue()));
                }
                subLine.buildPreparedQuery();
                NodeList LelemNode = line.getElementsByTagName(this.elementTag);
                this.ProcessLineElementNodes(LelemNode, subLine);
                thisLine.addSubLines(subLine);
                finish = this.ProcessLineNodes(lineNodes, subLine);
            }
            return finish;
        }
        catch (IOException ioe) {
            SpecOutputException spec = new SpecOutputException(ioe.getMessage());
            throw spec;
        }
    }

    public Line ProcessLineElementNodes(NodeList LelemNode, Line thisLine) throws SpecOutputException {
        for (int numElem = 0; numElem < LelemNode.getLength(); ++numElem) {
            Node staticValueElement;
            String staticVal;
            NodeList staticValueNode;
            Node dbFieldElement;
            String dbField;
            Element lineelemnt = (Element)LelemNode.item(numElem);
            LineElement thisLineElement = new LineElement();
            thisLineElement.setElementNumber(lineelemnt.getAttribute(this.elementNumberTag));
            NodeList dbTableNode = lineelemnt.getElementsByTagName(this.dbTableTag);
            Node dbTableElement = dbTableNode.item(0);
            Element thisElement = (Element)dbTableElement;
            thisLineElement.setDbTable(thisElement.getFirstChild().getNodeValue());
            NodeList dbFieldNode = lineelemnt.getElementsByTagName(this.dbFieldTag);
            if (dbFieldNode.getLength() > 0 && !(dbField = (thisElement = (Element)(dbFieldElement = dbFieldNode.item(0))).getFirstChild().getNodeValue()).equals("Empty")) {
                thisLineElement.setDbField(dbField);
            }
            if ((staticValueNode = lineelemnt.getElementsByTagName(this.staticValueTag)).getLength() > 0 && !(staticVal = (thisElement = (Element)(staticValueElement = staticValueNode.item(0))).getFirstChild().getNodeValue()).equals("Empty")) {
                thisLineElement.setStaticValue(staticVal);
            }
            NodeList formatTypeNode = lineelemnt.getElementsByTagName(this.formatTypeTag);
            Node formatTypeElement = formatTypeNode.item(0);
            thisElement = (Element)formatTypeElement;
            thisLineElement.setFormatType(thisElement.getFirstChild().getNodeValue());
            NodeList specialTransformNode = lineelemnt.getElementsByTagName(this.specialTransformTag);
            Node specialTransformElement = specialTransformNode.item(0);
            thisElement = (Element)specialTransformElement;
            thisLineElement.setSpecialTransform(thisElement.getFirstChild().getNodeValue());
            NodeList orderNode = lineelemnt.getElementsByTagName(this.orderTag);
            if (orderNode.getLength() > 0) {
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Translate XML: ProcessLineElementNodes. Getting POST Order ");
                Element orderElement = (Element)orderNode.item(0);
                thisLineElement.setOrder(orderElement.getFirstChild().getNodeValue());
            }
            thisLine.addLocalLineElements(thisLineElement);
        }
        return thisLine;
    }

    public HashMap getFileOutputs() throws SpecOutputException {
        return this.fileOutputs;
    }

    public void closeFiles() throws SpecOutputException {
    }
}

