/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.FormUtils;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;

public class DecisionMakerTag
extends TagSupport {
    private String dir_struct = Config.getProperty("customForms");
    private String formType;
    private String formAccess = "Personal";

    public static void main(String[] args) {
        new DecisionMakerTag();
    }

    public int doStartTag() throws JspException {
        User user = (User)this.pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
        if (user == null) {
            throw new JspException("Couldn't find the User object in the session");
        }
        String userid = user.getEmail();
        if (this.pageContext.getRequest().getParameter("formAccess") != null && this.pageContext.getRequest().getParameter("formAccess") != "") {
            this.setFormAccess(this.pageContext.getRequest().getParameter("formAccess"));
        }
        if (this.formAccess.equals("Public") || this.formAccess.equals("PublicEdit")) {
            userid = "public";
        }
        String form_id = this.pageContext.getRequest().getParameter("formid");
        File requested_file = new File(this.dir_struct + userid + "_" + form_id + ".jsp");
        try {
            MraldOutFile.appendToFile(requested_file.getCanonicalPath());
        }
        catch (Exception e) {
            // empty catch block
        }
        int loc = form_id.indexOf("-simple");
        if (loc != -1) {
            form_id = form_id.substring(0, loc);
        }
        if (form_id.equals("")) {
            throw new JspException("No form_id was provided.");
        }
        if (this.pageContext.getRequest().getParameter("formType") != null) {
            this.setFormType(this.pageContext.getRequest().getParameter("formType"));
        } else {
            this.setFormType("Select");
        }
        File xml_file = new File(this.dir_struct + userid + "_" + form_id + ".xml");
        File jsp_file = new File(this.dir_struct + userid + "_" + form_id + ".jsp");
        File simple_jsp_file = new File(this.dir_struct + FormUtils.getSimpleJspName(form_id, userid));
        File redirect_file = requested_file;
        if (xml_file.exists() && jsp_file.exists()) {
            if (xml_file.lastModified() > jsp_file.lastModified()) {
                FormUtils.makeForm(xml_file);
                if (simple_jsp_file.exists()) {
                    redirect_file = requested_file;
                }
            }
        } else if (xml_file.exists()) {
            FormUtils.makeForm(xml_file);
            if (simple_jsp_file.exists()) {
                redirect_file = simple_jsp_file;
            }
        } else if (!jsp_file.exists()) {
            throw new JspException("Couldn't find either the XML or HTML file for the requested form : FormId " + this.dir_struct + userid + "_" + form_id + ".jsp");
        }
        try {
            HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
            res.sendRedirect(FormUtils.getRedirect(redirect_file.getAbsolutePath()));
        }
        catch (IOException e) {
            JspException je = new JspException((Throwable)e);
            throw je;
        }
        this.pageContext.getRequest().removeAttribute("formAccess");
        this.pageContext.getRequest().removeAttribute("formType");
        return 0;
    }

    protected void setFormType(String formType) {
        this.formType = formType;
    }

    protected String getFormType() {
        return this.formType;
    }

    public void setFormAccess(String formAccess) {
        this.formAccess = formAccess;
    }

    public String getFormAccess() {
        return this.formAccess;
    }

    protected String getDirStruct() {
        return this.dir_struct;
    }
}

