/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.TableMetaData;

public class DisplayDBTag
extends TagSupport {
    DBMetaData md;
    ServletRequest req;
    String datasource;
    String schema;
    private String open = "false";
    private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"<:width:>\" height=\"1\"/>";
    private static String STARTER = "<:DisplayName:><a onClick=\"toggle('<:IDName:>', 'images/')\" ><img id=\"<:IDName:>Image\" src=\"images/plus.gif\"></img></a><br /><div id=\"<:IDName:>\" style=\"display:none;\"><br/>";
    private static String END = "</div>";

    public int doStartTag() throws JspException {
        this.init();
        try {
            String divLine = STARTER.replaceAll("<:IDName:>", "DataBase_" + this.datasource);
            divLine = divLine.replaceAll("<:DisplayName:>", "<b><i>Database Schema </i></b>");
            if (this.open.equals("true")) {
                divLine = divLine.replaceAll("display:none", "display:block");
            }
            this.pageContext.getOut().println("<img src=\"images/db.png\" width=\"30\" height=\"30\"/>");
            this.pageContext.getOut().println(divLine);
            this.pageContext.getOut().println(this.displayTables());
            this.pageContext.getOut().flush();
            this.pageContext.getOut().println(this.displayKeys());
            this.pageContext.getOut().println(END);
            this.pageContext.getOut().flush();
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
        return 0;
    }

    void init() throws JspException {
        this.md = MetaData.getDbMetaData(this.datasource);
        this.req = this.pageContext.getRequest();
    }

    private String displayTables() throws JspException {
        String width = "25";
        StringBuffer strOut = new StringBuffer();
        ArrayList tables = (ArrayList)this.md.getAllTableMetaData();
        Iterator iter = tables.iterator();
        HashMap linksMap = this.getFKeysPerTable();
        while (iter.hasNext()) {
            TableMetaData table = (TableMetaData)iter.next();
            String tableName = table.getName();
            strOut.append(SPACER.replaceAll("<:width:>", width));
            String divLine = MiscUtils.replace(STARTER, "<:IDName:>", "Table_" + this.datasource + tableName);
            divLine = MiscUtils.replace(divLine, "<:DisplayName:>", "<b><i>" + tableName + "</i></b>");
            strOut.append("<img src=\"images/table.jpg\" width=\"17\" height=\"17\"/>");
            strOut.append(MiscUtils.replace(SPACER, "<:width:>", "10"));
            strOut.append(divLine);
            strOut.append(this.displayColumns(table));
            strOut.append(this.displayPKeys(table));
            strOut.append(this.displayKeyData(tableName, linksMap));
            strOut.append(END);
        }
        return strOut.toString();
    }

    private String displayColumns(TableMetaData table) throws JspException {
        String width = "50";
        StringBuffer strOut = new StringBuffer();
        Collection<String> columns = table.getColumnNames();
        for (String columnName : columns) {
            strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
            String divLine = MiscUtils.replace(STARTER, "<:IDName:>", "Column_" + this.datasource + table.getName() + "_" + columnName);
            divLine = MiscUtils.replace(divLine, "<:DisplayName:>", "<b>" + columnName + "</b>");
            strOut.append(divLine);
            strOut.append(this.displayColumnDetails(table, columnName));
            strOut.append(END);
        }
        return strOut.toString();
    }

    private String displayPKeys(TableMetaData table) throws JspException {
        String width = "50";
        StringBuffer strOut = new StringBuffer("");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        Collection<String> pKeys = table.getPrimaryKeys();
        Iterator<String> iter = pKeys.iterator();
        strOut.append("<img src=\"images/pkey.png\" width=\"20\" height=\"20\"/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", "10"));
        strOut.append("<i>Primary Keys</i><br/>");
        width = "75";
        while (iter.hasNext()) {
            String primaryKey = iter.next();
            strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
            strOut.append("<b>" + primaryKey + "</b><br/>");
        }
        return strOut.toString();
    }

    private String displayColumnDetails(TableMetaData table, String columnName) throws JspException {
        String width = "75";
        StringBuffer strOut = new StringBuffer();
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("Type: " + FBUtils.getSqlType(table.getFieldType(columnName)) + "<br/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("Comments: " + table.getFieldComments(columnName) + "<br/>");
        strOut.append("<br/>");
        return strOut.toString();
    }

    private String displayKeys() throws JspException {
        String width = "25";
        StringBuffer strOut = new StringBuffer("<br/><br/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        String divLine = MiscUtils.replace(STARTER, "<:IDName:>", "Keys_" + this.datasource);
        divLine = MiscUtils.replace(divLine, "<:DisplayName:>", "<b><i>Database Keys</i></b>");
        strOut.append(divLine);
        Set linkList = this.md.getLinkList();
        Iterator linkIter = linkList.iterator();
        HashMap<String, ArrayList> keysMap = new HashMap<String, ArrayList>();
        while (linkIter.hasNext()) {
            ArrayList keys;
            Link link = (Link)linkIter.next();
            String pTable = link.getFtable() + "_" + link.getPtable();
            if (!keysMap.containsKey(pTable)) {
                keys = new ArrayList();
                keys.add(link);
                keysMap.put(pTable, keys);
                continue;
            }
            keys = (ArrayList)keysMap.get(pTable);
            keys.add(link);
            keysMap.put(pTable, keys);
        }
        for (String pKeyTable : keysMap.keySet()) {
            ArrayList links = (ArrayList)keysMap.get(pKeyTable);
            strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
            strOut.append("<img src=\"images/keys.png\" width=\"25\" height=\"25\"/>");
            strOut.append(MiscUtils.replace(SPACER, "<:width:>", "10"));
            for (int i = 0; i < links.size(); ++i) {
                Link link = (Link)links.get(i);
                if (i == 0) {
                    divLine = MiscUtils.replace(STARTER, "<:IDName:>", "Link_" + this.datasource + link.getPtable() + "_" + link.getFtable());
                    divLine = MiscUtils.replace(divLine, "<:DisplayName:>", "<b>" + link.getPtable() + " : " + link.getFtable() + "</b>");
                    strOut.append(divLine);
                }
                strOut.append(this.displayKeyDetails(link));
            }
            strOut.append(END);
        }
        strOut.append(END);
        return strOut.toString();
    }

    private String displayKeyData(String keyTable, HashMap keysMap) {
        String width = "50";
        StringBuffer strOut = new StringBuffer();
        ArrayList links = (ArrayList)keysMap.get(keyTable);
        if (links == null) {
            return "";
        }
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("<img src=\"images/fkey.png\" width=\"20\" height=\"20\"/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", "10"));
        StringBuffer delayStrOut = new StringBuffer();
        for (int i = 0; i < links.size(); ++i) {
            Link link = (Link)links.get(i);
            if (i == 0) {
                String divLine = MiscUtils.replace(STARTER, "<:IDName:>", "Link_" + this.datasource + keyTable + " _" + link.getPtable() + "_" + link.getFtable());
                divLine = MiscUtils.replace(divLine, "<:DisplayName:>", "<i>Relations</i>");
                strOut.append(divLine);
            }
            if (link.getPtable().equals(keyTable)) {
                strOut.append(this.displayKeyDetailsInTable(link, keyTable));
                continue;
            }
            delayStrOut.append(this.displayKeyDetailsInTable(link, keyTable));
        }
        strOut.append(delayStrOut);
        strOut.append(END);
        strOut.append("<br/>");
        return strOut.toString();
    }

    private HashMap getFKeysPerTable() throws JspException {
        Set linkList = this.md.getLinkList();
        Iterator linkIter = linkList.iterator();
        HashMap<String, ArrayList> keysMap = new HashMap<String, ArrayList>();
        while (linkIter.hasNext()) {
            ArrayList keys;
            ArrayList keys2;
            Link link = (Link)linkIter.next();
            String pTable = link.getPtable();
            if (!keysMap.containsKey(pTable)) {
                keys2 = new ArrayList();
                keys2.add(link);
                keysMap.put(pTable, keys2);
            } else {
                keys2 = (ArrayList)keysMap.get(pTable);
                keys2.add(link);
                keysMap.put(pTable, keys2);
            }
            String fTable = link.getFtable();
            if (!keysMap.containsKey(fTable)) {
                keys = new ArrayList();
                keys.add(link);
                keysMap.put(fTable, keys);
                continue;
            }
            keys = (ArrayList)keysMap.get(fTable);
            keys.add(link);
            keysMap.put(fTable, keys);
        }
        return keysMap;
    }

    private String displayKeyDetails(Link link) {
        String width = "75";
        StringBuffer strOut = new StringBuffer();
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("PK : <b>" + link.getPtable() + "</b>." + link.getPcolumn() + "<br/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("FK:  <b>" + link.getFtable() + "</b>." + link.getFcolumn() + "<br/>");
        strOut.append("<br/>");
        return strOut.toString();
    }

    private String displayKeyDetailsInTable(Link link, String tableName) {
        String width = "75";
        StringBuffer strOut = new StringBuffer();
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("<img src=\"images/table.jpg\" width=\"17\" height=\"17\"/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", "10"));
        width = "100";
        if (link.getPtable().equals(tableName)) {
            strOut.append("<b>" + link.getFtable() + "</b><br/>");
        } else {
            strOut.append("<b>" + link.getPtable() + "</b><br/>");
        }
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("PK : <b>" + link.getPtable() + "</b>." + link.getPcolumn() + "<br/>");
        strOut.append(MiscUtils.replace(SPACER, "<:width:>", width));
        strOut.append("FK :  <b>" + link.getFtable() + "</b>." + link.getFcolumn() + "<br/>");
        return strOut.toString();
    }

    public String getOpen() {
        return this.open;
    }

    public void setOpen(String thisOpen) {
        this.open = thisOpen;
    }

    public void setDatasource(String ds) {
        this.datasource = ds;
    }
}

