/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayTableTag
extends TagSupport {
    public String datasource = "";

    public int doStartTag() throws JspException {
        try {
            ServletRequest req = this.pageContext.getRequest();
            HashMap parameters = (HashMap)req.getParameterMap();
            String[] tables = (String[])parameters.get("Table");
            HashMap newParams = this.reformatHashMap(parameters);
            this.pageContext.getOut().println(this.getTableData(tables, newParams));
        }
        catch (MraldException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
        return 0;
    }

    public String getTableData(String[] tables, HashMap parameters) throws MraldException {
        try {
            Connection conn = new MraldConnection(this.datasource, new MsgObject((HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse())).getConnection();
            DBMetaData md = MetaData.getDbMetaData(this.datasource);
            Statement stmt = conn.createStatement();
            StringBuffer strRtn = new StringBuffer();
            StringBuffer strOut = new StringBuffer();
            String HEADER = "<center><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"  bgcolor=\"#ffffff\"><tr><td class=\"bord\"><table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"100%\">";
            String FOOTER = "</table> </td></tr></table></center><br/>";
            String title = "";
            boolean rowFound = false;
            boolean anyFound = false;
            String query = "";
            ResultSet rs = null;
            for (int j = 0; j < tables.length; ++j) {
                int i;
                title = "<tr><th colspan=\"<:colspan:>\">Table : <:table:></th></tr>";
                strOut = new StringBuffer();
                rowFound = false;
                query = " Select * from <:tableName:> where ";
                String table = tables[j];
                TableMetaData tableInfo = md.getTableMetaData(table);
                if (tableInfo == null) continue;
                strOut.append(HEADER);
                query = query.replaceAll("<:tableName:>", "\"" + tableInfo.getName() + "\"");
                Set<String> params = this.getPK(tableInfo, parameters);
                params = this.getFK(md.getLinkList(), tableInfo, parameters, params);
                query = query + this.getWhereParams(params);
                rs = stmt.executeQuery(query);
                ArrayList fieldNames = (ArrayList)tableInfo.getColumnNames();
                title = title.replaceAll("<:colspan:>", fieldNames.size() + "");
                title = title.replaceAll("<:table:>", table);
                strOut.append(title);
                strOut.append("<tr>");
                for (i = 0; i < fieldNames.size(); ++i) {
                    String field = (String)fieldNames.get(i);
                    strOut.append("<td><h2>" + field + "</h2></td>");
                }
                strOut.append("</tr>");
                anyFound = true;
                while (rs.next()) {
                    rowFound = true;
                    strOut.append("<tr>");
                    for (i = 0; i < fieldNames.size(); ++i) {
                        strOut.append("<td>" + rs.getString(i + 1) + "</td>");
                    }
                    strOut.append("</tr>");
                }
                strOut.append(FOOTER);
                if (rowFound) {
                    strRtn.append(strOut.toString());
                    continue;
                }
                strRtn.append(HEADER + title + "<td align=\"center\"><b><i>No references found in this table</i></b></td>" + FOOTER);
            }
            if (!anyFound) {
                strRtn.append("<tr><th>No other tables in the database reference this data</th></tr>");
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
            return strRtn.toString();
        }
        catch (SQLException e) {
            throw new MraldException(e);
        }
    }

    private HashMap reformatHashMap(HashMap inputHashMap) {
        HashMap<String, String> outputHashMap = new HashMap<String, String>();
        for (String key : inputHashMap.keySet()) {
            String value;
            String[] values = (String[])inputHashMap.get(key);
            if (values == null || (value = values[0]) == null) continue;
            outputHashMap.put(key, value);
        }
        return outputHashMap;
    }

    private Set<String> getPK(TableMetaData tableInfo, HashMap paramMap) {
        Iterator<String> keyIter = tableInfo.getPrimaryKeys().iterator();
        HashSet<String> params = new HashSet<String>();
        int j = 0;
        while (keyIter.hasNext()) {
            String pkName = keyIter.next().toString();
            String value = (String)paramMap.get(pkName);
            if (value == null || value.equals("")) continue;
            value = MiscUtils.checkApostrophe(value);
            params.add(pkName + " = '" + value + "'");
            ++j;
        }
        return params;
    }

    private Set<String> getFK(Set links, TableMetaData tableInfo, HashMap paramMap, Set<String> params) {
        Iterator linkIter = links.iterator();
        String fkName = "";
        int j = 0;
        String table = tableInfo.getName();
        while (linkIter.hasNext()) {
            String value;
            Link link = (Link)linkIter.next();
            if (link.getPtable().equals(table)) {
                fkName = link.getPcolumn();
            } else if (link.getFtable().equals(table)) {
                fkName = link.getFcolumn();
            }
            if ((value = (String)paramMap.get(fkName)) == null || value.equals("")) continue;
            value = MiscUtils.checkApostrophe(value);
            params.add(fkName + " = '" + value + "'");
            ++j;
        }
        return params;
    }

    private String getWhereParams(Set params) {
        StringBuffer queryRtn = new StringBuffer();
        Iterator paramIter = params.iterator();
        int i = 0;
        while (paramIter.hasNext()) {
            if (i > 0) {
                queryRtn.append(" AND ");
            }
            queryRtn.append(paramIter.next().toString());
            ++i;
        }
        return queryRtn.toString();
    }

    public void setDatasource(String ds) {
        this.datasource = ds;
    }
}

