/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;

public class DropDownListTag
extends TagSupport {
    private String table = "";
    private String listColumn = "";
    private String pkColumn = "";
    private String value = "";
    private String filterColumnValue = "";
    private String filterColumn = "";
    private String filterTable;
    private String datasource = "";

    public DropDownListTag() {
        this.init();
    }

    public int doStartTag() throws JspException {
        try {
            this.pageContext.getOut().print(this.getDropDown());
            return 1;
        }
        catch (IOException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
    }

    public void init() {
    }

    public String getDropDown() throws JspException {
        try {
            MraldConnection conn = new MraldConnection(this.datasource);
            if (this.table == null) {
                return "";
            }
            if (this.table.indexOf(" ") > 0 && this.table.charAt(0) != '\"') {
                this.table = "\"" + this.table + "\"";
            }
            String tableList = this.table;
            String whereClause = "";
            if (!this.filterColumn.equals("") && !this.filterColumnValue.equals("")) {
                String linkStr = "";
                whereClause = whereClause + " Where " + this.filterColumn + " = '" + this.filterColumnValue + "'";
                if (!this.table.equals(this.filterTable)) {
                    linkStr = this.getLink(this.table, this.filterTable);
                    if (!linkStr.equals("")) {
                        whereClause = whereClause + " AND " + linkStr;
                    }
                    tableList = tableList + ", " + this.filterTable + " ";
                }
            }
            String select = "Select DISTINCT " + this.table + "." + this.pkColumn + " as id," + this.table + "." + this.listColumn + " from " + tableList + whereClause + " order by " + this.listColumn;
            select = this.appendToQuery(select);
            ResultSet rs = conn.executeQuery(select);
            ResultSetMetaData rsmd = rs.getMetaData();
            StringBuffer buffer = new StringBuffer();
            while (rs.next()) {
                String entry = rs.getString(1);
                if (entry == null) continue;
                buffer.append("\n<option value=\"" + entry + "\"");
                if (String.valueOf(entry).equals(this.value)) {
                    buffer.append(" selected=\"selected\"");
                }
                buffer.append(">");
                for (int i = 2; i < rsmd.getColumnCount() + 1; ++i) {
                    buffer.append(rs.getString(i));
                    if (i == rsmd.getColumnCount()) continue;
                    buffer.append(" - ");
                }
                buffer.append("</option>");
            }
            rs.close();
            conn.close();
            return buffer.toString();
        }
        catch (SQLException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
        catch (MraldException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
    }

    private String getLink(String table1, String table2) throws MraldException {
        DBMetaData md = MetaData.getDbMetaData(this.datasource);
        if (table1.toUpperCase().equals(table2.toUpperCase())) {
            return "";
        }
        try {
            ArrayList links = md.getLinks(table1, table2);
            String rtnStr = "";
            for (int i = 0; i < links.size(); ++i) {
                Link link = (Link)links.get(i);
                if (i > 0) {
                    rtnStr = rtnStr + " AND ";
                }
                rtnStr = rtnStr + link.toString();
            }
            return rtnStr;
        }
        catch (MraldException me) {
            return "";
        }
    }

    public void setTable(String tableName) {
        this.table = tableName;
    }

    protected String appendToQuery(String query) throws MraldException {
        return query;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setFilterColumnValue(String filterColumnValue) {
        this.filterColumnValue = filterColumnValue;
    }

    public void setFilterColumn(String filterColumn) {
        this.filterColumn = filterColumn;
    }

    public void setFilterTable(String filterTable) {
        this.filterTable = filterTable;
    }

    public void setListColumn(String listColumn) {
        this.listColumn = listColumn;
    }

    public void setPkColumn(String pkColName) {
        this.pkColumn = pkColName;
    }

    public void setDatasource(String ds) {
        this.datasource = ds;
    }
}

