/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldError;

public class FormBuilderTag
extends BodyTagSupport {
    String className;
    String howMany;
    int number;
    int thread = 1;
    String other;
    String title;
    static final String SECTION_CLOSE = "</td></tr></table></td></tr></table>\n";
    static final String SECTION_OPENER_TEMPLATE = "<table summary=\"\" width=\"95%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td class=\"bord\"><table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\"><tr><th><:title:></th></tr><tr><td>\n";

    public void setClassName(String className) {
        this.className = className;
    }

    public void setHowMany(String howMany) {
        this.howMany = howMany;
    }

    public void setNumber() {
        if (this.howMany == null) {
            this.number = 1;
            return;
        }
        this.number = Integer.parseInt(this.howMany);
    }

    public void setThread(int threadNumber) {
        this.thread = threadNumber;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public int doEndTag() throws JspException {
        FormBuilderElement thisElement;
        DBMetaData md = (DBMetaData)this.pageContext.getAttribute("DBMetaData");
        StringBuffer ret = new StringBuffer();
        try {
            thisElement = this.castElement();
        }
        catch (ServletException e) {
            throw new MraldError(e);
        }
        this.setNumber();
        for (int i = 0; i < this.number; ++i) {
            ret.append(thisElement.getFBHtml(md, i, this.thread));
            if (i >= this.number - 1) continue;
            ret.append("<hr width=\"90%\">\n");
        }
        ret.append(SECTION_CLOSE);
        try {
            this.pageContext.getOut().print(ret.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 0;
    }

    public int doStartTag() throws JspException {
        try {
            this.pageContext.getOut().print(MiscUtils.replace(SECTION_OPENER_TEMPLATE, "<:title:>", this.title));
        }
        catch (Exception e) {
            throw new JspException();
        }
        return 1;
    }

    protected FormBuilderElement castElement() throws ServletException {
        try {
            if (this.className == null) {
                return null;
            }
            Class<?> classDefinition = Class.forName(this.className);
            FormBuilderElement parserElement = (FormBuilderElement)classDefinition.newInstance();
            return parserElement;
        }
        catch (InstantiationException wfe) {
            ServletException ce = new ServletException((Throwable)wfe);
            throw ce;
        }
        catch (ClassNotFoundException cne) {
            ServletException ce = new ServletException((Throwable)cne);
            throw ce;
        }
        catch (IllegalAccessException iae) {
            ServletException ce = new ServletException((Throwable)iae);
            throw ce;
        }
    }
}

