/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldOutFile;

public class FormMetaDataTag
extends TagSupport {
    protected ServletRequest req;
    protected boolean listAllLinkTables = false;

    public int doStartTag() throws JspException {
        this.init();
        String datasource = this.pageContext.getRequest().getParameter("Datasource");
        String[] tables = this.req.getParameterValues("Table");
        if (tables.length == 0) {
            throw new JspException("No tables were chosen in the previous step.  Please go back and choose one or more tables.");
        }
        int tableDepth = 1;
        if (this.req.getParameter("tableDepth") != null) {
            tableDepth = Integer.parseInt(this.req.getParameter("tableDepth").trim());
        }
        DBMetaData newDbmd = this.setMetaData(datasource, tables, tableDepth);
        this.pageContext.setAttribute("DBMetaData", (Object)newDbmd, 1);
        return 0;
    }

    protected DBMetaData setMetaData(String datasource, String[] tables, int tableDepth) throws JspException {
        try {
            DBMetaData md = MetaData.getDbMetaData(datasource);
            DBMetaData newDbmd = MetaData.getDataSubSet(md, tables, tableDepth);
            newDbmd.setDbProps(md.getDbProps());
            return newDbmd;
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
            return null;
        }
    }

    void init() throws JspException {
        this.req = this.pageContext.getRequest();
    }

    public void setListAllLinkTables(boolean listAllLinkTables) {
        this.listAllLinkTables = listAllLinkTables;
    }

    public void setListAllLinkTables(String bool) {
        this.listAllLinkTables = Boolean.getBoolean(bool);
    }

    public boolean getListAllLinkTables() {
        return this.listAllLinkTables;
    }
}

