/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.taglib.DropDownListTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.TableMetaData;

public class ListUpdateValuesTag
extends BodyTagSupport {
    protected ResultSet rs;
    protected String schema;
    protected String action;

    public int doStartTag() throws JspException {
        try {
            String tempTableName;
            DBMetaData md;
            TableMetaData tableInfo;
            ServletRequest request = this.pageContext.getRequest();
            String tableName = request.getParameter("tableName");
            String datasource = request.getParameter("datasource");
            if (datasource.equals("")) {
                datasource = "main";
            }
            if ((tableInfo = (md = MetaData.getDbMetaData(datasource)).getTableMetaDataNoCase(tempTableName = tableName)) == null) {
                throw new JspException("Table: " + tableName + " not found in Database. ");
            }
            Collection<String> primaryKeys = tableInfo.getPrimaryKeys();
            String queryTableName = new String(tableName);
            if (queryTableName.indexOf(32) != -1) {
                queryTableName = "\"" + queryTableName + "\"";
            }
            int i = 1;
            String[] fks = request.getParameterValues("fKey" + i);
            HashMap<String, String[]> linkInfo = new HashMap<String, String[]>();
            while (i < 100) {
                if (fks == null || fks.length == 0) {
                    fks = request.getParameterValues("fKey" + ++i);
                    continue;
                }
                String filterTable = request.getParameter("fKeyFilterTable" + i);
                String filterColumn = request.getParameter("fKeyFilterColumn" + i);
                String filterValue = request.getParameter("fKeyFilterValue" + i);
                String dropDownDataSource = request.getParameter("fKeyDataSource" + i);
                if (dropDownDataSource == null) {
                    dropDownDataSource = "main";
                }
                if (filterTable == null) {
                    filterTable = "";
                    filterColumn = "";
                    filterValue = "";
                }
                String[] fklink = new String[]{request.getParameter("fKeyTable" + i), request.getParameter("fKeyId" + i), request.getParameter("fKeyList" + i), dropDownDataSource, filterTable, filterColumn, filterValue};
                linkInfo.put(fks[0].toUpperCase(), fklink);
                fks = request.getParameterValues("fKey" + ++i);
            }
            Enumeration names = request.getParameterNames();
            StringBuffer whereClause = new StringBuffer();
            ArrayList<String> filters = new ArrayList<String>();
            ArrayList<String> pks = new ArrayList<String>();
            ArrayList<String> pksLowerCase = new ArrayList<String>();
            String whereAppend = " ";
            while (names.hasMoreElements()) {
                String colName = names.nextElement().toString();
                if (colName.equals("tableName") || colName.startsWith("fKey") || colName.equals("datasource") || colName.equals("SuccessUrl")) continue;
                String newColName = colName;
                boolean isPrimaryKey = tableInfo.isPrimaryKeyNoCase(newColName);
                pks.add(colName.toLowerCase());
                if (isPrimaryKey && !pksLowerCase.contains(colName.toLowerCase())) {
                    pksLowerCase.add(colName.toLowerCase());
                }
                String val = request.getParameter(colName);
                if (!this.checkHasColumn(tableInfo, colName)) continue;
                whereClause.append(whereAppend);
                whereAppend = " AND ";
                whereClause.append(colName + "='" + val + "'");
                String pkStr = "Table:" + tableName + "~Field:" + colName + "~Value:" + val;
                filters.add(pkStr);
            }
            if (pksLowerCase.size() < primaryKeys.size()) {
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "List Update values; doStartTag: Should have " + primaryKeys.size() + " but actually have " + pks.size());
                throw new JspException("Not all Primary Key Values have been specified ");
            }
            String selectClause = "Select * from " + queryTableName;
            if (whereClause.length() > 0) {
                selectClause = selectClause + " WHERE " + whereClause;
            }
            String valuesList = this.outputResults(datasource, selectClause, tableName, pks, linkInfo);
            String filtersList = this.outputFilters(filters);
            this.pageContext.getOut().print(valuesList);
            this.pageContext.getOut().print(filtersList);
            return 2;
        }
        catch (SQLException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private boolean checkHasColumn(TableMetaData tableInfo, String colName) {
        Iterator<String> colIter = tableInfo.getColumnNames().iterator();
        String lowerCaseColumn = colName.toLowerCase();
        while (colIter.hasNext()) {
            String listColumn = colIter.next().toLowerCase();
            if (!lowerCaseColumn.equals(listColumn)) continue;
            return true;
        }
        return false;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String outputResults(String datasource, String selectClause, String tableName, ArrayList pks, HashMap fks) throws JspException, SQLException {
        Connection conn = new MraldConnection(datasource, new MsgObject((HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse())).getConnection();
        DBMetaData md = MetaData.getDbMetaData(datasource);
        String noValue = "";
        this.schema = md.getDbProps().getProperty("SCHEMA");
        if (this.schema == null || this.schema.equals("")) {
            RuntimeException e = new RuntimeException("A SCHEMA value was not provided in the database configuration file.");
            throw e;
        }
        this.rs = conn.createStatement().executeQuery(selectClause);
        String CALENDAR = "\n<SCRIPT LANGUAGE=\"JavaScript\">var cal<:orderNo:> = new CalendarPopup();</SCRIPT>\n<A HREF=\"#\" onClick=\"cal<:orderNo:>.select(document.FormUpdate.<:name:>[0],'anchor<:orderNo:>','MM/dd/yyyy'); return false;\" TITLE=\"cal<:orderNo:>.select(document.FormUpdate.<:name:>[0],'anchor<:orderNo:>','MM/dd/yyyy'); return false; \"  NAME=\"anchor<:orderNo:>\" ID=\"anchor<:orderNo:>\"><img src=\"images/cal.gif\" width=\"17\" height=\"17\" border=\"0\" alt=\"Click Here to Pick up the timestamp\"></A>\n";
        ResultSetMetaData rsmd = this.rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<tr><td colspan=\"2\">");
        buffer.append("<b>" + this.action + " Values:</b></td></tr>");
        while (this.rs.next()) {
            for (int i = 0; i < colCount; ++i) {
                String value = this.rs.getString(i + 1);
                if (value == null || value.equals("null")) {
                    value = noValue;
                }
                String colName = rsmd.getColumnName(i + 1);
                int type = rsmd.getColumnType(i + 1);
                String niceName = FBUtils.getColumnName(tableName + "." + colName);
                if (niceName == null) {
                    niceName = colName;
                }
                boolean isDate = false;
                if (type == 92 || type == 91 || type == 93) {
                    isDate = true;
                }
                buffer.append("\n<tr><td><b>" + niceName + "</b></td><td>");
                int textSize = 0;
                if (value != null) {
                    textSize = value.length();
                }
                if (textSize > 100) {
                    buffer.append("<textarea cols='100' rows='" + (textSize / 100 + 1) + "' name='" + this.action + (i + 1) + "'>");
                    buffer.append(value + "</textarea>");
                } else {
                    String upperCaseColName = colName.toUpperCase();
                    if (fks.containsKey(upperCaseColName)) {
                        DropDownListTag ddl = new DropDownListTag();
                        buffer.append("<select");
                        buffer.append(" name='" + this.action + (i + 1) + "'>");
                        String[] fkInfo = (String[])fks.get(upperCaseColName);
                        ddl.setTable(fkInfo[0]);
                        ddl.setPkColumn(fkInfo[1]);
                        ddl.setListColumn(fkInfo[2]);
                        ddl.setValue(value);
                        ddl.setDatasource(fkInfo[3]);
                        if (!fkInfo[4].equals("")) {
                            ddl.setFilterTable(fkInfo[4]);
                            ddl.setFilterColumn(fkInfo[5]);
                            ddl.setFilterColumnValue(fkInfo[6]);
                        }
                        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "List Update values; outputResults. About to get Drop down data for : " + colName);
                        buffer.append(ddl.getDropDown() + "</select>\n");
                        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "List Update values; outputResults. Finished Drop Down Retrieval for: " + colName);
                    } else if (pks.contains(colName.toLowerCase())) {
                        buffer.append(value + "</td><input type=\"hidden\" name='" + this.action + (i + 1) + "' value=\"" + value + "\">");
                    } else {
                        buffer.append("<input type='text' size='" + textSize);
                        buffer.append("' name='" + this.action + (i + 1) + "' ");
                        if (isDate) {
                            if (!value.equals(noValue)) {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd");
                                try {
                                    Date date = df.parse(value);
                                    df.applyPattern("mm/dd/yyyy");
                                    String dateVal = df.format(date);
                                    buffer.append("value=\"" + dateVal + "\">");
                                }
                                catch (ParseException e) {
                                    RuntimeException re = new RuntimeException("A date value could not be formatted.");
                                    throw re;
                                }
                                String calendar = CALENDAR.replaceAll("<:name:>", this.action + (i + 1));
                                calendar = calendar.replaceAll("<:orderNo:>", new Integer(i + 1).toString());
                                buffer.append(calendar);
                            }
                        } else {
                            buffer.append("value=\"" + value + "\">");
                        }
                        buffer.append("</td>");
                    }
                }
                String typeName = FBUtils.isDateType(type) ? "Date" : (FBUtils.isNumberType(type) ? "Numeric" : (FBUtils.isBinaryType(type) ? "Binary" : "String"));
                buffer.append("<input type='hidden' name='" + this.action + (i + 1) + "' value=\"Table:" + tableName + "~Field:" + colName + "~Type:" + typeName + "\"></tr>");
            }
        }
        this.rs.close();
        conn.close();
        return buffer.toString();
    }

    public String outputFilters(ArrayList filters) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < filters.size(); ++i) {
            buffer.append("\n<input type='hidden' name='Filter" + (i + 1) + "' value=\"" + filters.get(i) + "\" >");
        }
        return buffer.toString();
    }
}

