/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.File;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.XSLTranslator;

public class NewsTag
extends TagSupport {
    private String newsArchive;

    public int doStartTag() throws JspException {
        try {
            String xmlStr = Config.getProperty("NEWSXML");
            String xslStr = this.newsArchive == null ? Config.getProperty("NEWSDISPLAYXSL") : (this.newsArchive.equals("yes") ? Config.getProperty("NEWSARCHIVEXSL") : Config.getProperty("NEWSDISPLAYXSL"));
            StringBuffer ret = new StringBuffer();
            xmlStr = xmlStr.substring(7);
            if (xmlStr == null || xslStr == null || xmlStr.equals("") || xslStr.equals("")) {
                ret.append("Unable to Display News<br>Missing Attributes for News.\n");
            } else {
                File xmlFile = new File(xmlStr);
                File xslFile = new File(xslStr);
                if (!xmlFile.exists() || !xslFile.exists()) {
                    ret.append("Unable to Display News<br>One or Both Files Do Not Exist.\n");
                } else {
                    ret.append(XSLTranslator.xslTransform(xmlFile, xslFile).toString());
                }
            }
            this.pageContext.getOut().print(ret.toString());
        }
        catch (NullPointerException npe) {
            throw new JspException((Throwable)npe);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public void setNewsArchive(String newsArchive) {
        this.newsArchive = newsArchive;
    }
}

