/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import org.mitre.mrald.util.Config;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class DataSource {
    protected String port = null;
    protected String name = null;
    protected String database = null;
    protected String driverClass = null;
    protected String serverString = null;
    protected String url = null;
    protected final String NAME = "name";
    protected final String DRIVER = "driver_class";
    protected final String SERVER = "server_string";
    protected final String PORT = "default_port";
    protected final String URL = "url";
    protected final String SCHEMA = "schema";
    protected String schema = null;

    public String getSchema() {
        return this.schema;
    }

    DataSource(Element datasourceNode) {
        NodeList iCare = datasourceNode.getElementsByTagName("name");
        this.name = iCare.item(0).getFirstChild().getNodeValue();
        iCare = datasourceNode.getElementsByTagName("driver_class");
        this.driverClass = iCare.item(0).getFirstChild().getNodeValue();
        iCare = datasourceNode.getElementsByTagName("server_string");
        this.serverString = iCare.item(0).getFirstChild().getNodeValue();
        try {
            iCare = datasourceNode.getElementsByTagName("default_port");
            this.port = iCare.item(0).getFirstChild().getNodeValue();
        }
        catch (NullPointerException e) {
            this.port = "";
        }
        try {
            iCare = datasourceNode.getElementsByTagName("schema");
            this.schema = iCare.item(0).getFirstChild().getNodeValue();
        }
        catch (NullPointerException e) {
            this.schema = "";
        }
        iCare = datasourceNode.getElementsByTagName("url");
        this.url = iCare.item(0).getFirstChild().getNodeValue();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Name: ");
        ret.append(this.name);
        ret.append(Config.NEWLINE);
        ret.append("Driver class: ");
        ret.append(this.driverClass);
        ret.append(Config.NEWLINE);
        ret.append("Server string: ");
        ret.append(this.serverString);
        ret.append(Config.NEWLINE);
        if (this.port != null) {
            ret.append("Default port: ");
            ret.append(this.port);
            ret.append(Config.NEWLINE);
        }
        ret.append("Drvier URL: ");
        ret.append(this.url);
        ret.append(Config.NEWLINE);
        return ret.toString();
    }

    public String getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getServerString() {
        return this.serverString;
    }
}

