/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.GenerateXMLException;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;

public abstract class GenerateXML
extends AbstractStep {
    private boolean bStyleSheet = false;
    private Writer dataOutputStream;
    protected static final String XML_OUT_PREPROCESSOR_LINE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected static final String XML_OUT_NEWLINE = System.getProperty("line.separator");
    protected static final String XML_HEADER = "<Body>";
    protected static final String XML_STYLESHEET = "";
    protected static final String XML_FOOTER = "</Body>";
    protected static final String XML_CDATA_SECTION_BEGIN = "<![CDATA[";
    protected static final String XML_CDATA_SECTION_END = "]]>";
    protected static final String XML_START_TAG = "<";
    protected static final String XML_END_TAG = "</";
    protected static String query = "";

    public GenerateXML() throws GenerateXMLException {
    }

    public GenerateXML(Writer oOutputStream) throws GenerateXMLException {
        this.dataOutputStream = oOutputStream;
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.GenerateDocument();
        }
        catch (MraldException e) {
            throw new MraldError(e, msgObject);
        }
    }

    public String GetDBName() throws IOException {
        return null;
    }

    public String GetUri() throws IOException {
        return "temp";
    }

    public String GetStyleSheet() throws IOException {
        return null;
    }

    public void GenerateDocument(String sSQLStatement, boolean bStylesheet) throws MraldException {
        try {
            this.ExportHeader(bStylesheet);
            this.RetrieveData();
            this.ExportFooter();
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
    }

    public void GenerateDocument() throws MraldException {
        this.ExportHeader(this.bStyleSheet);
        this.RetrieveData();
        try {
            this.ExportFooter();
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
    }

    public void ExportFooter() throws IOException {
        this.WriteEndRootElementName();
        if (this.IsDefinitionLanguageBiz()) {
            this.Write(XML_FOOTER);
            this.NewLine();
        }
        this.Flush();
    }

    public void ExportHeader(boolean bStylesheet) throws MraldException {
        try {
            this.Write(XML_OUT_PREPROCESSOR_LINE);
            this.NewLine();
            if (bStylesheet) {
                this.Write(XML_STYLESHEET);
                this.NewLine();
            }
            if (this.GetStyleSheet() != null) {
                this.Write("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.GetStyleSheet() + "\"?>");
                this.NewLine();
            }
            if (this.IsDefinitionLanguageDTD()) {
                this.Write("<!DOCTYPE " + this.GetRootElementName() + " SYSTEM \"" + this.GetUri() + "\">");
                this.NewLine();
            }
            if (this.IsDefinitionLanguageBiz()) {
                this.Write(XML_HEADER);
                this.NewLine();
            }
            this.WriteRootElementName();
            this.Flush();
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
    }

    public boolean IsDefinitionLanguageBiz() throws IOException {
        return false;
    }

    public boolean IsDefinitionLanguageDTD() throws IOException {
        return false;
    }

    protected String GetCurrentDatetime() {
        String sDatetime;
        try {
            int iMillisecondsPerMinute = 60000;
            int iMillisecondsPerYear = 60 * iMillisecondsPerMinute;
            Date oDate = new Date();
            SimpleDateFormat oSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            sDatetime = oSimpleDateFormat.format(oDate);
            Calendar oCalendar = oSimpleDateFormat.getCalendar();
            int iMillisecondsFromGMT = oCalendar.get(15) + oCalendar.get(16);
            String sHoursFromGMT = this.TwoDigitString(iMillisecondsFromGMT / iMillisecondsPerYear);
            String sMinutesFromGMT = this.TwoDigitString(Math.abs(iMillisecondsFromGMT % iMillisecondsPerYear) / iMillisecondsPerMinute);
            sDatetime = sDatetime + sHoursFromGMT + ":" + sMinutesFromGMT;
        }
        catch (Exception e) {
            sDatetime = "unknown";
        }
        return sDatetime;
    }

    protected String GetRootElementName() {
        return null;
    }

    protected void Write(String sXML) throws IOException {
        this.dataOutputStream.write(sXML);
    }

    protected String Write(String origXML, String sXML) throws IOException {
        return origXML + sXML;
    }

    protected void NewLine() throws IOException {
        this.dataOutputStream.write(XML_OUT_NEWLINE);
    }

    protected void Indent(int iLevel) throws IOException {
        for (int i = 0; i < iLevel; ++i) {
            this.Write("  ");
        }
    }

    protected void Flush() throws IOException {
        this.dataOutputStream.flush();
    }

    protected void Comment(String sComment) throws IOException {
        this.Write("<!-- " + sComment + " -->");
    }

    protected String RemoveSpaces(String sValue) {
        StringBuffer sbNoSpaces = new StringBuffer();
        for (int i = 0; i < sValue.length(); ++i) {
            char c = sValue.charAt(i);
            if (c == ' ') continue;
            sbNoSpaces.append(c);
        }
        return sbNoSpaces.toString();
    }

    public void setDataOutput(Writer oOutputStream) throws GenerateXMLException {
        this.dataOutputStream = oOutputStream;
    }

    public Writer getDataOutput() throws GenerateXMLException {
        return this.dataOutputStream;
    }

    private String TwoDigitString(int iValue) {
        String sTwoDigit = iValue == 0 ? "00" : (iValue < 10 && iValue > 0 ? "0" + iValue : (iValue > -10 && iValue < 0 ? "-0" + Math.abs(iValue) : XML_STYLESHEET + iValue));
        return sTwoDigit;
    }

    public abstract void RetrieveData() throws MraldException;

    protected abstract void WriteRootElementName() throws IOException;

    protected abstract void WriteEndRootElementName() throws IOException;

    public abstract void ExportBody(int var1, String var2, String var3) throws MraldException;
}

