/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.KeywordSearch;
import org.mitre.mrald.util.LinkUtils;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;
import org.mitre.mrald.util.User;

public class LatticeHtmlKeywordSearch
extends KeywordSearch {
    private User user = null;
    private int lineLimit = -1;
    private int sizeLimit = -1;
    private MsgObject msg;

    public void execute(MsgObject msg) throws WorkflowStepException {
        this.msg = msg;
        try {
            String sizeLimitStr;
            String[] searchParams = msg.getValue("term");
            this.datasource = msg.getValue("Datasource")[0];
            String lineLimitStr = msg.getValue("lineLimit")[0];
            if (lineLimitStr != null && !lineLimitStr.equals("")) {
                this.lineLimit = Integer.valueOf(lineLimitStr);
            }
            if ((sizeLimitStr = msg.getValue("sizeLimit")[0]) != null && !sizeLimitStr.equals("")) {
                this.sizeLimit = Integer.valueOf(sizeLimitStr);
            }
            PrintWriter out = msg.getOutPrintWriter();
            this.search(searchParams, out);
            out.write("\n");
            out.close();
        }
        catch (MraldException me) {
            throw new WorkflowStepException(me);
        }
    }

    public void setUser(User thisUser) {
        this.user = thisUser;
    }

    public void setLineLimit(String lineLimitStr) {
        if (lineLimitStr != null && !lineLimitStr.equals("")) {
            this.lineLimit = Integer.valueOf(lineLimitStr);
        }
    }

    public void setSizeLimit(String sizeLimitStr) {
        if (sizeLimitStr != null && !sizeLimitStr.equals("")) {
            this.sizeLimit = Integer.valueOf(sizeLimitStr);
        }
    }

    public void search(String[] searchParams, Writer out) throws MraldException {
        try {
            TableMetaData tableInfo;
            Connection conn = new MraldConnection(this.datasource, this.msg).getConnection();
            Statement stmt = conn.createStatement();
            StringBuffer strRtn = new StringBuffer();
            if (searchParams.length < 1) {
                out.write("\nYou must enter a search criteria.\n");
                return;
            }
            DBMetaData md = MetaData.getDbMetaData(this.datasource);
            Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
            Iterator<TableMetaData> iter = tableMetaData.iterator();
            StringBuffer strOut = new StringBuffer();
            String titleStr = "<br/><br/><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#ffffff\"><tr><td class=\"bord\"><table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"100%\">";
            titleStr = titleStr + "<tr><th colspan=\"2\" bgcolor=\"#ccccff\">List of Table Names Containing Keyword <i>" + searchParams[0] + "</i></th></tr>";
            boolean tableFound = false;
            while (iter.hasNext()) {
                tableInfo = iter.next();
                if (tableInfo.getName().indexOf(searchParams[0]) <= -1) continue;
                tableFound = true;
                strOut.append("<tr><td align=\"center\"><b>" + tableInfo.getName() + "</b></td></tr>");
            }
            String end = "</table></td></tr></table>";
            if (tableFound) {
                strRtn.append(titleStr + strOut.toString() + end);
            }
            out.write(strRtn.toString());
            strOut = new StringBuffer();
            strRtn = new StringBuffer();
            boolean colFound = false;
            iter = tableMetaData.iterator();
            titleStr = "<br/><br/><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#ffffff\"><tr><td class=\"bord\"><table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"100%\">";
            titleStr = titleStr + "<tr><th colspan=\"2\" bgcolor=\"#ccccff\">List of Column Names Containing Keyword <i>" + searchParams[0] + "</i></th></tr><tr><th>Table</th><th>Column</th></tr>";
            strOut = new StringBuffer();
            while (iter.hasNext()) {
                tableInfo = iter.next();
                ArrayList fieldNames = (ArrayList)tableInfo.getColumnNames();
                for (String field : fieldNames) {
                    if (field.indexOf(searchParams[0]) <= -1) continue;
                    colFound = true;
                    strOut.append("<tr><td align=\"center\"><b>" + tableInfo.getName() + "</b></td><td>" + field + "</td></tr>");
                }
            }
            if (colFound) {
                strRtn.append(titleStr + strOut.toString() + end);
            }
            out.write(strRtn.toString());
            strOut = new StringBuffer();
            strRtn = new StringBuffer();
            iter = tableMetaData.iterator();
            ResultSet rs = null;
            while (iter.hasNext()) {
                titleStr = "<br/><br/><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#ffffff\"><tr><td class=\"bord\"><table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"100%\">";
                titleStr = titleStr + "<tr><th colspan=\"<:colspan:>\" bgcolor=\"#ccccff\"><b><:Title:></b></th></tr>";
                StringBuffer header = new StringBuffer("<tr>");
                tableInfo = iter.next();
                ArrayList fieldNames = (ArrayList)tableInfo.getColumnNames();
                Iterator iter2 = fieldNames.iterator();
                String whereClause = " ( ";
                String selectClause = " select  ";
                String tableName = tableInfo.getName();
                if (tableName.length() > 0 && tableName.charAt(0) != '\"' && tableName.indexOf(32) > -1) {
                    tableName = "\"" + tableName + "\"";
                }
                while (iter2.hasNext()) {
                    String field = (String)iter2.next();
                    Integer type = tableInfo.getFieldType(field);
                    header.append("<td><h2>" + field + "</h2></td>");
                    if (field.length() > 0 && field.indexOf("Table") > -1 && field.charAt(0) != '\"' && field.indexOf(32) > -1) {
                        field = "\"" + field + "\"";
                    }
                    if (!(FBUtils.isNumberType(type) || FBUtils.isDateType(type) || FBUtils.isBooleanType(type) || FBUtils.isBinaryType(type))) {
                        whereClause = whereClause + tableName + "." + field + " like '%" + searchParams[0] + "%' OR ";
                    }
                    selectClause = selectClause + tableName + "." + field + ",";
                }
                if (whereClause.equals("")) continue;
                selectClause = selectClause.substring(0, selectClause.length() - 1) + " from ";
                whereClause = whereClause + "1=0 ) ";
                String query = selectClause + tableName + " where " + whereClause;
                if ((query = LatticeQuery.adaptQuery(query, this.user)) == null) {
                    MraldException se = new MraldException("You must be logged in to return the results from the Keyword Search");
                    se.fillInStackTrace();
                    throw se;
                }
                rs = stmt.executeQuery(query);
                String rows = LinkUtils.getLinkTableHtml(md, tableInfo, rs, this.lineLimit, this.sizeLimit);
                if (rows.equals("")) continue;
                strOut = new StringBuffer();
                header.append("</tr>");
                strOut.append(rows);
                strOut.append("</table></td></tr></table>");
                titleStr = titleStr.replaceAll("<:Title:>", tableInfo.getName());
                titleStr = titleStr.replaceAll("<:colspan:>", fieldNames.size() + "");
                strRtn.append(titleStr + header.toString() + strOut.toString());
                out.write(strRtn.toString());
                strOut = new StringBuffer();
                strRtn = new StringBuffer();
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
            out.write(strRtn.toString());
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
        catch (IOException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }
}

