/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkUtils {
    public static String getLinkTableHtml(DBMetaData md, TableMetaData tableInfo, ResultSet rs, int lineLimitSize, float mbLimitSize) throws MraldException {
        ArrayList pkLinks = (ArrayList)md.getPKLinkData(tableInfo.getName());
        try {
            StringBuffer strOut = new StringBuffer("");
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            String[] fieldNames = new String[colCount];
            for (int i = 0; i < colCount; ++i) {
                fieldNames[i] = rsmd.getColumnName(i + 1);
            }
            int row_count = 0;
            int fileSize = 0;
            while (rs.next() && (lineLimitSize == -1 || row_count < lineLimitSize) && (mbLimitSize == -1.0f || (float)fileSize < mbLimitSize)) {
                ++row_count;
                String rowString = LinkUtils.getRowDetails(md, colCount, fieldNames, tableInfo, pkLinks, rs);
                fileSize += rowString.length();
                strOut.append(rowString);
            }
            return strOut.toString();
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    public static void getLinkTableHtml(Writer out, DBMetaData md, ArrayList<Link> pkLinks, ArrayList<TableMetaData> tables, ResultSet rs, int lineLimitSize, float mbLimitSize) throws MraldException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            String[] fieldNames = new String[colCount];
            for (int i = 0; i < colCount; ++i) {
                fieldNames[i] = rsmd.getColumnName(i + 1);
            }
            int row_count = 0;
            int fileSize = 0;
            while (rs.next() && (lineLimitSize == -1 || row_count < lineLimitSize) && (mbLimitSize == -1.0f || (float)fileSize < mbLimitSize)) {
                ++row_count;
                String rowString = LinkUtils.getRowDetails(md, colCount, fieldNames, tables, pkLinks, rs);
                fileSize += rowString.length();
                out.write(rowString);
            }
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
        catch (IOException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    private static String getRowDetails(DBMetaData md, int colCount, String[] fieldNames, ArrayList<TableMetaData> tables, ArrayList<Link> pkLinks, ResultSet rs) throws MraldException {
        try {
            StringBuffer strOut = new StringBuffer();
            strOut.append("<tr>\n\t");
            TableMetaData tableInfo = null;
            for (int i = 0; i < colCount; ++i) {
                String fkLink;
                String fieldName;
                String value = rs.getString(i + 1);
                tableInfo = tables.get(i);
                if (value == null) {
                    value = "";
                }
                if (tableInfo.isPrimaryKey(fieldName = fieldNames[i])) {
                    if (pkLinks != null && pkLinks.size() > 0) {
                        String pkout = LinkUtils.formatPKOutput(MetaData.getDataSource(md), fieldName, value, pkLinks, rs);
                        if (pkout == null) continue;
                        strOut.append(pkout);
                        continue;
                    }
                    fkLink = LinkUtils.formatFKOutput(MetaData.getDataSource(md), fieldName, value, pkLinks);
                    strOut.append(fkLink);
                    continue;
                }
                Link link = md.getFKLinkData(tableInfo.getName(), fieldName);
                if (link != null) {
                    fkLink = LinkUtils.formatFKOutput(MetaData.getDataSource(md), fieldName, value, link);
                    if (fkLink == null) continue;
                    strOut.append(fkLink);
                    continue;
                }
                strOut.append("<td>&nbsp;" + value + "</td>");
            }
            strOut.append("</tr>");
            return strOut.toString();
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    private static String getRowDetails(DBMetaData md, int colCount, String[] fieldNames, TableMetaData tableInfo, ArrayList pkLinks, ResultSet rs) throws MraldException {
        try {
            StringBuffer strOut = new StringBuffer();
            strOut.append("<tr>");
            strOut.append("\n\t");
            for (int i = 0; i < colCount; ++i) {
                String fkLink;
                String fieldName;
                String value = rs.getString(i + 1);
                if (value == null) {
                    value = "";
                }
                if (tableInfo.isPrimaryKey(fieldName = fieldNames[i])) {
                    if (pkLinks != null && pkLinks.size() > 0) {
                        String pkout = LinkUtils.formatPKOutput(MetaData.getDataSource(md), fieldName, value, pkLinks, rs);
                        if (pkout == null) continue;
                        strOut.append(pkout);
                        continue;
                    }
                    fkLink = LinkUtils.formatFKOutput(MetaData.getDataSource(md), fieldName, value, pkLinks);
                    strOut.append(fkLink);
                    continue;
                }
                Link link = md.getFKLinkData(tableInfo.getName(), fieldName);
                if (link != null) {
                    fkLink = LinkUtils.formatFKOutput(MetaData.getDataSource(md), fieldName, value, link);
                    if (fkLink == null) continue;
                    strOut.append(fkLink);
                    continue;
                }
                strOut.append("<td>&nbsp;" + value + "</td>");
            }
            strOut.append("</tr>");
            return strOut.toString();
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    private static String formatPKOutput(String datasource, String columnName, String value, ArrayList links, ResultSet rs) throws MraldException {
        try {
            StringBuffer strOut = new StringBuffer();
            StringBuffer listParams = new StringBuffer();
            boolean noValues = true;
            for (int i = 0; i < links.size(); ++i) {
                Link link = (Link)links.get(i);
                if (i > 0) {
                    listParams.append("&");
                }
                if (link.getFtable() == null) continue;
                String pCol = link.getPcolumn();
                String fCol = link.getFcolumn();
                String val = rs.getString(pCol);
                if (val != null) {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                listParams.append("Table=" + link.getFtable());
                listParams.append("&" + fCol + "=" + val);
                noValues = false;
            }
            if (noValues) {
                return "<td>" + value + "</td>";
            }
            strOut.append("<td align=\"right\" width=\"15%\">");
            strOut.append("<a href=\"TableDetails.jsp?datasource=" + datasource + "&" + listParams.toString() + "\">");
            strOut.append("&nbsp;" + value + "</a></td>");
            return strOut.toString();
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
        catch (UnsupportedEncodingException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    private static String formatFKOutput(String datasource, String columnName, String value, ArrayList links) throws MraldException {
        try {
            StringBuffer strOut = new StringBuffer();
            StringBuffer listParams = new StringBuffer();
            boolean noValues = true;
            String urlVal = value;
            if (value != null) {
                urlVal = URLEncoder.encode(value, "UTF-8");
            }
            for (int i = 0; i < links.size(); ++i) {
                Link link = (Link)links.get(i);
                if (link.getPtable() == null) continue;
                listParams.append("Table=" + link.getPtable());
                listParams.append("&" + link.getPcolumn() + "=" + urlVal);
                noValues = false;
            }
            if (noValues) {
                return "<td>" + value + "</td>";
            }
            strOut.append("<td align=\"right\" width=\"15%\">");
            strOut.append("<a href=\"TableDetails.jsp?datasource=" + datasource + "&" + listParams.toString() + "\">");
            return strOut.toString();
        }
        catch (UnsupportedEncodingException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    private static String formatFKOutput(String datasource, String columnName, String value, Link link) throws MraldException {
        try {
            StringBuffer strOut = new StringBuffer();
            String urlVal = value;
            if (value != null) {
                urlVal = URLEncoder.encode(value, "UTF-8");
            }
            if (link.getPtable() == null) {
                return "<td>" + value + "</td>";
            }
            String pTable = link.getPtable();
            String pColumn = link.getPcolumn();
            strOut.append("<td align=\"right\" width=\"15%\">");
            strOut.append("<a href=\"TableDetails.jsp?datasource=" + datasource + "&Table=" + pTable + "&" + pColumn + "=" + urlVal + "\">" + value + "</a>");
            return strOut.toString();
        }
        catch (UnsupportedEncodingException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }
}

