/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import org.columba.ristretto.composer.MimeTreeRenderer;
import org.columba.ristretto.io.CharSequenceSource;
import org.columba.ristretto.io.Source;
import org.columba.ristretto.message.Address;
import org.columba.ristretto.message.BasicHeader;
import org.columba.ristretto.message.Header;
import org.columba.ristretto.message.LocalMimePart;
import org.columba.ristretto.message.MimeHeader;
import org.columba.ristretto.message.MimePart;
import org.columba.ristretto.message.MimeType;
import org.columba.ristretto.parser.AddressParser;
import org.columba.ristretto.smtp.SMTPProtocol;

public class Mailer {
    public static void send(String to, String from, String smtpServer, String body, String subject) {
        if (body == null) {
            body = "";
        }
        try {
            LocalMimePart root;
            Address fromAddress = AddressParser.parseAddress((CharSequence)from);
            Address toAddress = AddressParser.parseAddress((CharSequence)to);
            Header header = new Header();
            BasicHeader basicHeader = new BasicHeader(header);
            basicHeader.setFrom(fromAddress);
            basicHeader.setTo(new Address[]{toAddress});
            basicHeader.setSubject(subject, Charset.forName("ISO-8859-1"));
            basicHeader.set("X-Mailer", (Object)"SimpleSMTP example / Ristretto API");
            MimeHeader mimeHeader = new MimeHeader(header);
            mimeHeader.set("Mime-Version", (Object)"1.0");
            LocalMimePart textPart = root = new LocalMimePart(mimeHeader);
            MimeHeader textHeader = textPart.getHeader();
            textHeader.setMimeType(new MimeType("text", "plain"));
            root.setBody((Source)new CharSequenceSource((CharSequence)body));
            InputStream messageSource = MimeTreeRenderer.getInstance().renderMimePart((MimePart)root);
            SMTPProtocol protocol = new SMTPProtocol(smtpServer);
            protocol.openPort();
            try {
                protocol.ehlo(InetAddress.getByName(smtpServer));
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    protocol.helo(InetAddress.getByName(smtpServer));
                }
                catch (Exception ee) {
                    e.printStackTrace();
                }
            }
            protocol.mail(fromAddress);
            protocol.rcpt(toAddress);
            protocol.data(messageSource);
            protocol.quit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

