/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscUtils {
    public static ArrayList<String> getTableColumns(String sSql) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        if (sSql.indexOf("*") > 0) {
            return tableColumns;
        }
        sSql = sSql.toUpperCase();
        int selectIndex = sSql.indexOf("SELECT");
        int distinctIndex = sSql.indexOf("DISTINCT");
        if (distinctIndex > selectIndex) {
            selectIndex = distinctIndex + 2;
        }
        int fromIndex = sSql.indexOf("FROM");
        int spacePos = 0;
        StringTokenizer sParse = new StringTokenizer(sSql.substring(selectIndex + 6, fromIndex), ",");
        while (sParse.hasMoreTokens()) {
            String columnSelect = sParse.nextElement().toString().trim();
            spacePos = columnSelect.indexOf(" ");
            if (spacePos > 0) {
                columnSelect = columnSelect.substring(0, spacePos);
            }
            tableColumns.add(columnSelect);
        }
        return tableColumns;
    }

    public static ArrayList<String> getTables(String sSql, boolean includeSyns) {
        ArrayList<String> tables = new ArrayList<String>();
        sSql = sSql.toUpperCase();
        int fromIndex = sSql.indexOf("FROM");
        int whereIndex = sSql.indexOf("WHERE");
        if (whereIndex <= 0) {
            whereIndex = sSql.length();
        }
        int spacePos = 0;
        StringTokenizer sParse = new StringTokenizer(sSql.substring(fromIndex + 5, whereIndex), ",");
        while (sParse.hasMoreTokens()) {
            String tableSelect = sParse.nextElement().toString().trim();
            if (!includeSyns && (spacePos = tableSelect.indexOf(" ")) > 0) {
                tableSelect = tableSelect.substring(0, spacePos);
            }
            tables.add(tableSelect);
        }
        return tables;
    }

    public static ArrayList<String> getTables(String sSql) {
        ArrayList<String> tables = new ArrayList<String>();
        sSql = sSql.toUpperCase();
        int fromIndex = sSql.indexOf("FROM");
        int whereIndex = sSql.indexOf("WHERE");
        if (whereIndex <= 0) {
            whereIndex = sSql.length();
        }
        int spacePos = 0;
        StringTokenizer sParse = new StringTokenizer(sSql.substring(fromIndex + 5, whereIndex), ",");
        while (sParse.hasMoreTokens()) {
            String tableSelect = sParse.nextElement().toString().trim();
            spacePos = tableSelect.indexOf(" ");
            if (spacePos > 0) {
                tableSelect = tableSelect.substring(0, spacePos);
            }
            tables.add(tableSelect);
        }
        return tables;
    }

    public static void appendCollectionContents(Collection list, StringBuffer ret) {
        if (list.size() == 0) {
            ret.append(" none.");
        } else {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ret.append("\n\t" + iter.next().toString());
            }
        }
    }

    public static MsgObject groupNVPairs(MsgObject msg) throws MsgObjectException {
        Iterator<String> nvNames = msg.getNames().iterator();
        MsgObject returnObject = new MsgObject();
        int outputFormats = 0;
        while (nvNames.hasNext()) {
            String currentName = nvNames.next();
            if (!currentName.toLowerCase().startsWith("outputformat")) continue;
            String[] values = msg.getValue(currentName);
            StringBuffer ret = new StringBuffer(values[0]);
            for (int i = 1; i < values.length; ++i) {
                ret.append("~" + values[i]);
            }
            returnObject.setValue(Integer.toString(outputFormats), ret.toString());
            ++outputFormats;
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(MsgObject msg, Exception e, boolean html) {
        MraldOutFile.logToFile(e);
        try {
            try {
                msg.SetOutPrintWriter();
            }
            catch (MsgObjectException moe) {
                MraldOutFile.logToFile(moe);
                Object var5_4 = null;
                PrintWriter out = msg.getOutPrintWriter();
                if (html) {
                    out.println("<HTML>" + Config.getProperty("CSS") + "<BODY>");
                    out.println("<div class=holder>");
                    out.println("<p>There has been a problem processing your request.");
                    SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy 'at' h:mm");
                    Date currentTime_1 = new Date();
                    out.println("<br>at: " + formatter.format(currentTime_1) + "<br>");
                    out.println(e.getMessage());
                    out.println("<p>Please <a href='mailTo: " + Config.getProperty("MAILTO") + "'>report" + "</a> this to us and " + "we will correct it as soon as possible.  Please include both the " + "time and message above in your report.");
                    out.println("</div>");
                    out.println("<!-- " + MiscUtils.formatThrowable(e) + "-->");
                    out.println("</BODY></HTML>");
                    out.close();
                } else if (out != null) {
                    out.println("There has been a problem processing your request.");
                    SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy 'at' h:mm");
                    Date currentTime_1 = new Date();
                    out.println("at: " + formatter.format(currentTime_1));
                    out.println(e.getMessage());
                    out.println("Please report this to " + Config.getProperty("MAILTO") + " to us and we will correct it as soon as possible. " + " Please include both the time and message above in your report.");
                    out.close();
                }
            }
            Object var5_3 = null;
            PrintWriter out = msg.getOutPrintWriter();
            if (html) {
                out.println("<HTML>" + Config.getProperty("CSS") + "<BODY>");
                out.println("<div class=holder>");
                out.println("<p>There has been a problem processing your request.");
                SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy 'at' h:mm");
                Date currentTime_1 = new Date();
                out.println("<br>at: " + formatter.format(currentTime_1) + "<br>");
                out.println(e.getMessage());
                out.println("<p>Please <a href='mailTo: " + Config.getProperty("MAILTO") + "'>report" + "</a> this to us and " + "we will correct it as soon as possible.  Please include both the " + "time and message above in your report.");
                out.println("</div>");
                out.println("<!-- " + MiscUtils.formatThrowable(e) + "-->");
                out.println("</BODY></HTML>");
                out.close();
            } else if (out != null) {
                out.println("There has been a problem processing your request.");
                SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy 'at' h:mm");
                Date currentTime_1 = new Date();
                out.println("at: " + formatter.format(currentTime_1));
                out.println(e.getMessage());
                out.println("Please report this to " + Config.getProperty("MAILTO") + " to us and we will correct it as soon as possible. " + " Please include both the time and message above in your report.");
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PrintWriter out = msg.getOutPrintWriter();
            if (html) {
                out.println("<HTML>" + Config.getProperty("CSS") + "<BODY>");
                out.println("<div class=holder>");
                out.println("<p>There has been a problem processing your request.");
                SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy 'at' h:mm");
                Date currentTime_1 = new Date();
                out.println("<br>at: " + formatter.format(currentTime_1) + "<br>");
                out.println(e.getMessage());
                out.println("<p>Please <a href='mailTo: " + Config.getProperty("MAILTO") + "'>report" + "</a> this to us and " + "we will correct it as soon as possible.  Please include both the " + "time and message above in your report.");
                out.println("</div>");
                out.println("<!-- " + MiscUtils.formatThrowable(e) + "-->");
                out.println("</BODY></HTML>");
                out.close();
            } else if (out != null) {
                out.println("There has been a problem processing your request.");
                SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy 'at' h:mm");
                Date currentTime_1 = new Date();
                out.println("at: " + formatter.format(currentTime_1));
                out.println(e.getMessage());
                out.println("Please report this to " + Config.getProperty("MAILTO") + " to us and we will correct it as soon as possible. " + " Please include both the time and message above in your report.");
                out.close();
            }
            throw throwable;
        }
    }

    public static Properties loadProperties(String propsFile) {
        Properties ret = new Properties();
        try {
            File test = new File(propsFile);
            if (!test.exists()) {
                RuntimeException re = new RuntimeException("Could not find the properties file: " + propsFile);
                throw re;
            }
            FileInputStream in = new FileInputStream(propsFile);
            ret.load(in);
        }
        catch (IOException e) {
            RuntimeException re = new RuntimeException("Could not find the properties file: " + propsFile, e);
            throw re;
        }
        return ret;
    }

    public static long logQuery(String userId, String datasource, String query, StringBuffer logInfo) {
        Date date = Calendar.getInstance().getTime();
        logInfo.append("User: " + userId + "; Start Time: " + date + "; Datasource: " + datasource + "; Query: " + query + ";");
        MraldOutFile.appendToFile(Config.getProperty("LOGFILE"), logInfo.toString());
        return date.getTime();
    }

    public static long logQueryRun(long startTime, StringBuffer logInfo) {
        long dbTime = System.currentTimeMillis() - startTime;
        logInfo.append(" Execute time: " + (double)dbTime / 1000.0 + " s." + ";");
        MraldOutFile.appendToFile(Config.getProperty("DBLOGFILE"), logInfo.toString());
        return dbTime;
    }

    public static void logWorkFlow(String userId, String workflow) {
        MraldOutFile.appendToFile(Config.getProperty("LOGFILE"), "User: " + userId + "; Workflow: " + workflow + "; " + Calendar.getInstance().getTime() + ";");
    }

    public static String parseHtmlToText(String input) {
        input = input.replaceAll("<br>", Config.NEWLINE);
        input = input.replaceAll("&#39", "'");
        return input;
    }

    public static MsgObject parseNVPairs(String parseString) {
        MsgObject nameValues = new MsgObject();
        StringTokenizer valueTokens = new StringTokenizer(parseString, "~");
        while (valueTokens.hasMoreTokens()) {
            String pair = valueTokens.nextToken();
            int split = pair.indexOf(":");
            String name = pair.substring(0, split);
            String value = pair.substring(split + 1, pair.length());
            nameValues.setValue(name, value);
        }
        return nameValues;
    }

    public static String parseSynonym(String table) {
        String schemaPart = "";
        String tableName = "";
        StringTokenizer tableNameTokens = new StringTokenizer(table, ".");
        if (tableNameTokens.countTokens() > 1) {
            schemaPart = tableNameTokens.nextToken() + ".";
        }
        tableNameTokens = new StringTokenizer(table, " ");
        tableName = tableNameTokens.nextToken();
        if (tableNameTokens.hasMoreTokens()) {
            tableName = tableNameTokens.nextToken();
        }
        return schemaPart + tableName;
    }

    public static String parseTextToHtml(String input) {
        input = input.replaceAll("&", "&amp;");
        input = input.replaceAll("'", "&#39");
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("\r\n", "<br>");
        input = input.replaceAll("\n\r", "<br>");
        input = input.replaceAll("\r", "<br>");
        input = input.replaceAll("\n", "<br>");
        return input;
    }

    public static String parseTextToXml(String input) {
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("&", "&amp;");
        return input;
    }

    public static String replace(String input, String target, String replacement) {
        int last = 0;
        String returnString = "";
        target = target.toUpperCase();
        int len = target.length();
        while (input.length() > 0) {
            String upperCaseContent = input.toUpperCase();
            last = upperCaseContent.indexOf(target);
            String currentParagraph = "";
            if (last == -1) {
                currentParagraph = input.substring(0, input.length());
                returnString = returnString + currentParagraph;
                input = "";
                continue;
            }
            currentParagraph = input.substring(0, last);
            returnString = returnString + currentParagraph + replacement;
            input = input.substring(last + len);
        }
        return returnString;
    }

    public static String replace(String input, String target, int replacement) {
        int last = 0;
        String returnString = "";
        target = target.toUpperCase();
        int len = target.length();
        while (input.length() > 0) {
            String upperCaseContent = input.toUpperCase();
            last = upperCaseContent.indexOf(target);
            String currentParagraph = "";
            if (last == -1) {
                currentParagraph = input.substring(0, input.length());
                returnString = returnString + currentParagraph;
                input = "";
                continue;
            }
            currentParagraph = input.substring(0, last);
            returnString = returnString + currentParagraph + replacement;
            input = input.substring(last + len);
        }
        return returnString;
    }

    public static String checkApostrophe(String input) {
        return input.replaceAll("'", "''");
    }

    public static String appendSuffix(String filename, String suffix) {
        return filename + suffix;
    }

    public static String insertSuffix(String filename, String suffix) {
        if (filename.lastIndexOf(46) >= 0) {
            return filename.substring(0, filename.lastIndexOf(46)) + suffix + filename.substring(filename.lastIndexOf(46));
        }
        return MiscUtils.appendSuffix(filename, suffix);
    }

    public static String insertSuffixInFileName(String filename, String suffix) {
        int dotPos = filename.lastIndexOf(46);
        if (dotPos >= 0) {
            int fileSepPos = filename.lastIndexOf("/");
            if (fileSepPos > dotPos) {
                return MiscUtils.appendSuffix(filename, suffix);
            }
            return filename.substring(0, filename.lastIndexOf(46)) + suffix + filename.substring(filename.lastIndexOf(46));
        }
        return MiscUtils.appendSuffix(filename, suffix);
    }

    public static String prependSuffix(String filename, String suffix) {
        if (filename.indexOf(46) >= 0) {
            return filename.substring(0, filename.indexOf(46)) + suffix + filename.substring(filename.indexOf(46));
        }
        return MiscUtils.appendSuffix(filename, suffix);
    }

    public static String replaceSuffix(String filename, String suffix) {
        if (filename.lastIndexOf(46) >= 0) {
            return filename.substring(0, filename.lastIndexOf(46)) + suffix;
        }
        return MiscUtils.appendSuffix(filename, suffix);
    }

    public static String replaceWholeSuffix(String filename, String suffix) {
        if (filename.indexOf(46) >= 0) {
            return filename.substring(0, filename.indexOf(46)) + suffix;
        }
        return MiscUtils.appendSuffix(filename, suffix);
    }

    public static String clearSemiColon(String q) {
        boolean inLiteral = false;
        for (int i = 0; i < q.length(); ++i) {
            char nextChar;
            char currentChar = q.charAt(i);
            if (!inLiteral) {
                if (currentChar == '\'') {
                    inLiteral = true;
                    continue;
                }
                if (currentChar == '{' || currentChar == ';') {
                    return q.substring(0, i);
                }
                if (i >= q.length() - 1) continue;
                nextChar = q.charAt(i + 1);
                if ((currentChar != '/' || nextChar != '*') && (currentChar != '-' || nextChar != '-')) continue;
                return q.substring(0, i);
            }
            if (currentChar != '\'' || i >= q.length() - 1) continue;
            nextChar = q.charAt(i + 1);
            if (nextChar == '\'') {
                ++i;
                continue;
            }
            inLiteral = false;
        }
        return q;
    }

    public static String formatThrowable(Throwable t) {
        StringBuffer ret = new StringBuffer();
        ret.append("\t--");
        ret.append(Config.NEWLINE);
        ret.append("\t");
        ret.append(t.getClass().getName());
        ret.append(": ");
        ret.append(t.getMessage());
        StackTraceElement[] stack = t.getStackTrace();
        if (t.getCause() != null) {
            ret.append(Config.NEWLINE);
            int limit = stack.length > 2 ? 3 : stack.length;
            for (int i = 0; i < limit; ++i) {
                ret.append("\t");
                ret.append(stack[i]);
                ret.append(Config.NEWLINE);
            }
            ret.append("\t..." + stack.length + " total\n");
            ret.append(MiscUtils.formatThrowable(t.getCause()));
        } else {
            int extra = 2;
            boolean foundMyClasses = false;
            ret.append(Config.NEWLINE);
            ret.append("\t*Root cause*");
            ret.append(Config.NEWLINE);
            for (int i = 0; i < stack.length && extra >= 0; ++i) {
                ret.append("\t" + stack[i]);
                ret.append(Config.NEWLINE);
                boolean bl = foundMyClasses = foundMyClasses || stack[i].getClassName().indexOf("mrald") > -1;
                if (!foundMyClasses) continue;
                --extra;
            }
            ret.append("\t..." + stack.length + " total");
        }
        return ret.toString();
    }

    public static String formatDate(long time_millis) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(time_millis);
        return format.format(date);
    }
}

