/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.mitre.mrald.util.ImageDisplayPanel;
import org.mitre.mrald.util.PrintUtilities;

public class PrintPreview
extends JFrame {
    protected int pageWidth;
    protected int pageHeight;
    protected JComboBox scaleCombo;
    protected PreviewContainer preview = new PreviewContainer();

    public PrintPreview(Component[] targets) {
        this(targets, "Print Preview");
    }

    public PrintPreview(Component[] targets, String title) {
        super(title);
        this.init(targets);
        this.getPreviews(targets);
        JScrollPane ps = new JScrollPane(this.preview);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        ActionListener lst = this.getPreviewActionListener();
        this.scaleCombo.addActionListener(lst);
        this.scaleCombo.setMaximumSize(this.scaleCombo.getPreferredSize());
        this.scaleCombo.setEditable(true);
        this.scaleCombo.setSelectedIndex(3);
    }

    private void getPreviews(Component[] targets) {
        PrintUtilities printUtil = new PrintUtilities(targets);
        int pageIndex = 0;
        int size = targets.length;
        int scale = 50;
        int w = this.pageWidth * scale / 100;
        int h = this.pageHeight * scale / 100;
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.defaultPage();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            System.out.println("Unable to determine default page size");
            return;
        }
        this.pageWidth = (int)pageFormat.getWidth();
        this.pageHeight = (int)pageFormat.getHeight();
        for (int i = 0; i < size; ++i) {
            PagePreview pp;
            Graphics g;
            pageIndex = i;
            Graphics2D g2 = (Graphics2D)targets[i].getGraphics();
            if (g2 != null) {
                System.out.println("Got G2 Graphics");
                BufferedImage graphCache = g2.getDeviceConfiguration().createCompatibleImage(this.pageWidth, this.pageHeight);
                g = graphCache.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.pageWidth, this.pageHeight);
                if (printUtil.print(g, pageFormat, pageIndex) != 0) break;
                pp = new PagePreview(w, h, graphCache);
                this.preview.add(pp);
            } else {
                System.out.println("About to PrintPreview Graphics");
                pp = new PagePreview(w, h, ((ImageDisplayPanel)targets[i]).getCurrentImage());
                g = this.preview.getGraphics();
                if (g == null) {
                    System.out.print("Graphics object is null");
                }
                this.preview.add(pp);
            }
            ++pageIndex;
        }
    }

    private ActionListener initListener(Component[] targets) {
        final Component[] printComponents = targets;
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                PrintUtilities.printComponent(printComponents);
                PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                PrintPreview.this.dispose();
            }
        };
        return lst;
    }

    private JToolBar initToolBar(Component[] targets) {
        this.setSize(800, 600);
        JToolBar tb = new JToolBar();
        URL imageURL = null;
        try {
            imageURL = new URL("http://127.0.0.1:8080/graphics/print.gif");
        }
        catch (MalformedURLException m) {
            // empty catch block
        }
        JButton bt = new JButton("Print", new ImageIcon(imageURL));
        ActionListener lst = this.initListener(targets);
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(4, 6, 4, 6));
        tb.add(bt);
        bt = new JButton("Close");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add(bt);
        return tb;
    }

    private void init(Component[] targets) {
        this.setSize(800, 600);
        JToolBar tb = this.initToolBar(targets);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %", "150 %", "200 %"};
        this.scaleCombo = new JComboBox<String>(scales);
        tb.addSeparator();
        tb.add(this.scaleCombo);
        this.scaleCombo.setSelectedIndex(3);
        this.getContentPane().add((Component)tb, "North");
    }

    private ActionListener getPreviewActionListener() {
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(){

                    public void run() {
                        String str = PrintPreview.this.scaleCombo.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        int w = PrintPreview.this.pageWidth * scale / 100;
                        int h = PrintPreview.this.pageHeight * scale / 100;
                        Component[] comps = PrintPreview.this.preview.getComponents();
                        for (int k = 0; k < comps.length; ++k) {
                            if (!(comps[k] instanceof PagePreview)) continue;
                            PagePreview pp = (PagePreview)comps[k];
                            pp.setScaledSize(w, h);
                        }
                        PrintPreview.this.preview.doLayout();
                    }
                };
                runner.start();
            }
        };
        return lst;
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.setBackground(Color.white);
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_source, 0, 0, this.m_w, this.m_h, this);
            this.paintBorder(g);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

