/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.WebRowSet;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

public class RowSetFactory {
    private static Class jdbcRowSetClass = null;
    private static Class joinRowSetClass = null;
    private static Class webRowSetClass = null;

    public static JdbcRowSet createJdbcRowSet() throws MraldException {
        try {
            if (jdbcRowSetClass == null) {
                RowSetFactory.init();
            }
            return (JdbcRowSet)jdbcRowSetClass.newInstance();
        }
        catch (InstantiationException wfe) {
            throw new MraldException(wfe);
        }
        catch (IllegalAccessException iae) {
            throw new MraldException(iae);
        }
    }

    public static JoinRowSet createJoinRowSet() throws MraldException {
        try {
            if (joinRowSetClass == null) {
                RowSetFactory.init();
            }
            return (JoinRowSet)joinRowSetClass.newInstance();
        }
        catch (InstantiationException wfe) {
            throw new MraldException(wfe);
        }
        catch (IllegalAccessException iae) {
            throw new MraldException(iae);
        }
    }

    public static WebRowSet createWebRowSet() throws MraldException {
        try {
            if (webRowSetClass == null) {
                RowSetFactory.init();
            }
            return (WebRowSet)webRowSetClass.newInstance();
        }
        catch (InstantiationException wfe) {
            throw new MraldException(wfe);
        }
        catch (IllegalAccessException iae) {
            throw new MraldException(iae);
        }
    }

    private static void init() throws MraldException {
        try {
            jdbcRowSetClass = Class.forName(Config.getProperty("JdbcRowSet"));
            joinRowSetClass = Class.forName(Config.getProperty("JoinRowSet"));
            webRowSetClass = Class.forName(Config.getProperty("WebRowSet"));
        }
        catch (ClassNotFoundException cne) {
            MraldOutFile.appendToFile("**WARNING** JdbcRowSet, JoinRowSet, and/or WebRowSet are not configured properly in standard.properties.  Please fix before you try to use any of the cross DB join facilities or XML output.");
            throw new MraldException(cne);
        }
    }
}

