/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.query.BroadcastQueryTargetsParser;
import org.mitre.mrald.query.BroadcastTargetProvider;
import org.mitre.mrald.query.LinkElement;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MiscUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTargetProvider
implements BroadcastTargetProvider {
    private List<BroadcastQueryTarget> allTargets;
    public static final String TARGETS_FILE = "broadcastTargets.xml";
    private String xmlFileLoc = Config.getFinalPropertiesLocation() + "broadcastTargets.xml";

    public SimpleTargetProvider() {
        this.reload();
    }

    public SimpleTargetProvider(boolean loadXmlfile) {
        if (loadXmlfile) {
            this.reload();
        }
    }

    @Override
    public List<BroadcastQueryTarget> getTargets(List<ParserElement> sqlElements, List<LinkElement> linkElements, String datasource) {
        ArrayList<BroadcastQueryTarget> targets = new ArrayList<BroadcastQueryTarget>();
        for (BroadcastQueryTarget potentialTarget : this.allTargets) {
            if (!potentialTarget.getLocalDatasource().equals(datasource)) continue;
            LinkElement[] links = new LinkElement[linkElements.size()];
            for (int i = 0; i < linkElements.size(); ++i) {
                links[i] = linkElements.get(i);
            }
            SqlElements[] parts = new SqlElements[sqlElements.size()];
            for (int i = 0; i < sqlElements.size(); ++i) {
                parts[i] = (SqlElements)sqlElements.get(i);
            }
            potentialTarget.setLinkElements(links);
            potentialTarget.setSqlElements(parts);
            targets.add(potentialTarget);
        }
        return targets;
    }

    @Override
    public void reload() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.xmlFileLoc);
        }
        catch (IOException e) {
            String mailText = MiscUtils.formatThrowable(e);
            System.out.println(mailText);
            Mailer.send(Config.getProperty("MAILTO"), "SimpleTargetProvider", Config.getProperty("SMTPHOST"), mailText, "Error loading targets in SimpleTargetProvider");
        }
        this.reload(in);
    }

    public void reload(InputStream in) {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            BroadcastQueryTargetsParser parser = new BroadcastQueryTargetsParser();
            xr.setContentHandler(parser);
            xr.parse(new InputSource(in));
            in.close();
            this.allTargets = parser.getBroadcastQueryTargets();
        }
        catch (Exception e) {
            String mailText = MiscUtils.formatThrowable(e);
            e.printStackTrace();
            Mailer.send(Config.getProperty("MAILTO"), "SimpleTargetProvider", Config.getProperty("SMTPHOST"), mailText, "Error loading targets in SimpleTargetProvider");
        }
    }
}

