/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;

public class Snoop {
    public static void logCookies(HttpServletRequest request) {
        StringBuilder ret = new StringBuilder();
        ret.append("Cookies in this request:");
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            ret.append(Config.NEWLINE);
            ret.append(cookie.getName());
            ret.append(" = ");
            ret.append(cookie.getValue());
        }
        MraldOutFile.logToFile(ret.toString());
    }

    public static void logHeaders(HttpServletRequest request) {
        StringBuilder ret = new StringBuilder();
        ret.append("Headers in this request:");
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = request.getHeader(key);
            ret.append(Config.NEWLINE);
            ret.append(key);
            ret.append(": ");
            ret.append(value);
        }
        MraldOutFile.logToFile(ret.toString());
    }

    public static void logParameters(MsgObject msg) {
        StringBuilder logInfo = new StringBuilder("");
        logInfo.append("Name/value pairs in this MsgObject:");
        Iterator<String> e = msg.getNames().iterator();
        try {
            while (e.hasNext()) {
                String key = e.next();
                if (key.toLowerCase().indexOf("password") != -1) continue;
                String[] values = msg.getValue(key);
                logInfo.append(Config.NEWLINE + key + " = ");
                for (int i = 0; i < values.length; ++i) {
                    logInfo.append(values[i] + " ");
                }
            }
            logInfo.append(Config.NEWLINE + "User IP Address = " + msg.getUserUrl());
        }
        catch (Exception ex) {
            throw new MraldError(ex, msg);
        }
        finally {
            MraldOutFile.logToFile(logInfo.toString());
        }
    }

    public static void logParameters(MsgObject msg, String log) {
        Snoop.logParameters(msg);
    }

    public static void logParameters(HttpServletRequest request) {
        StringBuilder ret = new StringBuilder();
        ret.append("Parameter names in this request:");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.toLowerCase().indexOf("password") != -1) continue;
            String[] values = request.getParameterValues(key);
            ret.append(Config.NEWLINE);
            ret.append(key);
            ret.append(" = ");
            for (int i = 0; i < values.length; ++i) {
                ret.append(values[i]);
                ret.append(" ");
            }
        }
        MraldOutFile.logToFile(ret.toString());
    }

    public static void logUserInfo(HttpServletRequest request) {
        StringBuilder ret = new StringBuilder();
        ret.append("Remote User: " + request.getRemoteUser());
        ret.append(Config.NEWLINE + "User IP address: " + request.getRemoteAddr());
        MraldOutFile.logToFile(ret.toString());
    }

    public static void logUserInfo(MsgObject msg) {
        StringBuilder ret = new StringBuilder();
        ret.append(msg.getUserUrl() + Config.NEWLINE);
        MraldOutFile.logToFile(ret.toString());
    }
}

