/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldCrypter;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;

public class UserLogin
extends AbstractStep {
    private String username = null;
    private String password = null;
    private String pageurl = null;
    private String loginAction = null;
    private User mraldUser = null;
    private MsgObject msg;
    private FailReason errCode = null;

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        this.msg = msgObject;
        try {
            this.username = msgObject.getValue("userName")[0];
            this.password = msgObject.getValue("password")[0];
            this.pageurl = msgObject.getValue("pageurl")[0];
            if (this.pageurl == null) {
                this.pageurl = Config.getProperty("BaseUrl");
            }
            this.loginAction = msgObject.getValue("loginAction")[0];
            this.mraldUser = new User(this.username);
            if (this.loginAction.equals("updateLogin")) {
                String checkPassword;
                String newPassword = msgObject.getValue("newPassword")[0];
                if (!newPassword.equals(checkPassword = msgObject.getValue("checkPassword")[0])) {
                    this.errCode = FailReason.PasswordMismatch;
                    WorkflowStepException ipe = new WorkflowStepException("Your passwords did not match. Please go back and enter matching passwords.");
                    throw ipe;
                }
                if (!this.updatePassword(newPassword, checkPassword)) {
                    this.errCode = FailReason.UnequalPasswords;
                    WorkflowStepException e = new WorkflowStepException("You must enter a valid password.");
                    throw e;
                }
            } else if (this.loginAction.equals("checkUser")) {
                if (!this.logInUser()) {
                    return;
                }
            } else if (this.loginAction.equals("retrievePassword")) {
                this.generatePassword();
            } else if (this.loginAction.equals("changeCOI")) {
                String newCoi = msgObject.getValue("COI")[0];
                this.pageurl = "success.jsp";
                this.mraldUser = (User)msgObject.getReq().getSession().getAttribute(Config.getProperty("cookietag"));
                this.mraldUser.setGroup(newCoi);
            } else {
                this.errCode = FailReason.InvalidAction;
                WorkflowStepException e = new WorkflowStepException("Invalid Entry Point.  Please go to " + Config.getProperty("BaseUrl") + "/MraldLogin.jsp and log in through a valid entry point.");
                throw e;
            }
            if (this.loginAction.equals("checkUser") || this.loginAction.equals("changeCOI")) {
                msgObject.getReq().getSession().setAttribute(Config.getProperty("cookietag"), null);
                msgObject.getReq().getSession().setAttribute(Config.getProperty("cookietag"), (Object)this.mraldUser);
                Cookie c = new Cookie(Config.getProperty("cookietag"), this.username);
                c.setMaxAge(0x3FFFFFFF);
                msgObject.getRes().addCookie(c);
                msgObject.setRedirect(this.pageurl);
                return;
            }
            if (this.loginAction.equals("updateLogin")) {
                msgObject.setRedirect("logout.jsp");
                return;
            }
            msgObject.setRedirect(this.pageurl);
            return;
        }
        catch (WorkflowStepException e) {
            if (this.errCode != null) {
                this.niceErrorPage(msgObject);
            }
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowStepException(e);
        }
    }

    protected void niceErrorPage(MsgObject msgObject) {
        String message;
        switch (this.errCode) {
            case InvalidPassword: {
                message = "The user with that email address has an invalide password, you must request a new password <a href=\"RetrievePassword.jsp\">here</a>.";
                break;
            }
            case UnvalidatedUser: {
                message = "The user with that email address must be validated.  Please check your email for instructions.";
                break;
            }
            case UserDoesNotExist: {
                message = "No user with that email exists.  Please register <a href=\"RegistrationForm.jsp\">here</a>.";
                break;
            }
            case UnequalPasswords: {
                message = "The passwords provided did not match.  Please use the browser back button and try again.";
                break;
            }
            case PasswordMismatch: {
                message = "The passwords provided did not match.  Please use the browser back button and try again.";
                break;
            }
            case CantCreatePeopleTable: {
                message = "Unable to properly set up the administrative database.  Please report this to the system administrator.";
                break;
            }
            case InvalidAction: {
                message = "An invalide action was requested by the calling page.  Please report this to the system administrator.";
                break;
            }
            default: {
                message = "";
            }
        }
        try {
            msgObject.getReq().getSession().setAttribute("responseMessage", (Object)message);
            msgObject.getRes().sendRedirect("responseMessage.jsp");
        }
        catch (IOException e) {
            throw new MraldError(e, msgObject);
        }
    }

    protected boolean updatePassword(String newpassword, String checkpassword) throws Exception {
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        ResultSet r = null;
        String query = "SELECT email, peopletypeid, password FROM people WHERE people.email = '" + this.username.toLowerCase() + "'";
        String prevPass = null;
        r = conn.executeQuery(query);
        if (!r.next()) {
            r.close();
            conn.close();
            this.errCode = FailReason.UserDoesNotExist;
            WorkflowStepException e = new WorkflowStepException("No User Found with the corresponding Email Address");
            throw e;
        }
        prevPass = r.getString("password");
        if (MraldCrypter.matchPassword(prevPass, this.password)) {
            String passEncrypt = MraldCrypter.encodePassword(newpassword, null);
            this.setPassword(this.username, passEncrypt, conn);
            r.close();
            conn.close();
            return true;
        }
        r.close();
        conn.close();
        return false;
    }

    protected boolean setPassword(String emailId, String password, Object connect) throws Exception {
        MraldConnection conn = (MraldConnection)connect;
        String update = "UPDATE people SET password = '" + password + "' WHERE email = '" + emailId + "'";
        conn.executeUpdate(update);
        conn.close();
        return true;
    }

    protected boolean logInUser() throws Exception {
        if (this.username == null || this.password == null) {
            this.msg.setRedirect(Config.getProperty("BaseUrl") + "/MraldLogin.jsp?badLogin=true");
            return false;
        }
        String query = "SELECT email, peopletypeid, password, latticegroupid, validated FROM people WHERE people.email = '" + this.username.toLowerCase() + "'";
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        ResultSet r = null;
        try {
            r = conn.executeQuery(query);
        }
        catch (SQLException e) {
            try {
                if (!MraldConnection.createPeopleTable()) {
                    throw new SQLException("Error creating the people/latticegroup table. Please check database configuration.");
                }
            }
            catch (SQLException se) {
                throw e;
            }
            r = conn.executeQuery(query);
        }
        if (r.next()) {
            String prevPass = r.getString("password");
            int peopleTypeId = r.getInt("peopletypeid");
            String groupid = r.getString("latticegroupid");
            String validationKey = r.getString("validated");
            if (prevPass == null) {
                r.close();
                conn.close();
                this.errCode = FailReason.InvalidPassword;
                WorkflowStepException e = new WorkflowStepException("Account password is invalid.  You must request a new password.");
                throw e;
            }
            if (validationKey == null || validationKey.equals("N")) {
                // empty if block
            }
            if (!MraldCrypter.matchPassword(prevPass, this.password)) {
                r.close();
                conn.close();
                this.msg.setRedirect(Config.getProperty("BaseUrl") + "/MraldLogin.jsp?badLogin=true");
                return false;
            }
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "UserLogin: logInUser() - User Logged In:" + this.username.toLowerCase());
            this.mraldUser.setEmail(this.username.toLowerCase());
            this.mraldUser.setTypeId(peopleTypeId);
            this.mraldUser.setGroup(groupid);
            r.close();
            conn.close();
            return true;
        }
        r.close();
        conn.close();
        this.msg.setRedirect(Config.getProperty("BaseUrl") + "/MraldLogin.jsp?badLogin=true");
        return false;
    }

    public void generatePassword() throws Exception {
        String password;
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        String query = "SELECT email FROM people WHERE people.email = '" + this.username.toLowerCase() + "'";
        ResultSet r = conn.executeQuery(query);
        if (r.next()) {
            password = "";
            Random rng = new Random(Calendar.getInstance().getTimeInMillis());
            for (int i = 0; i < 8; ++i) {
                password = password + (char)(rng.nextInt(26) + 97);
            }
        } else {
            r.close();
            conn.close();
            this.errCode = FailReason.UserDoesNotExist;
            WorkflowStepException npe = new WorkflowStepException("No User Found With Corresponding Email");
            throw npe;
        }
        String reset = MraldCrypter.encodePassword(password, null);
        this.setPassword(this.username, reset, conn);
        StringBuffer emailText = new StringBuffer();
        emailText.append("This email was generated at your request.\n");
        emailText.append("Below you will find your newly created password for the ");
        emailText.append(Config.getProperty("TITLE") + " system located at:\n\n");
        emailText.append(Config.getProperty("URL") + "\n\n");
        emailText.append("Your new password is: " + password + "\n\n");
        emailText.append("You may change your password once you have logged successfully into the system.\n\n");
        emailText.append("Thank you,\nThe " + Config.getProperty("TITLE") + " Development Team\n\n");
        Mailer.send(this.username, Config.getProperty("MAILTO"), Config.getProperty("SMTPHOST"), emailText.toString(), "Password Request");
        r.close();
        conn.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FailReason {
        InvalidPassword,
        UnvalidatedUser,
        UserDoesNotExist,
        UnequalPasswords,
        PasswordMismatch,
        CantCreatePeopleTable,
        InvalidAction;

    }
}

