/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;

public class WebUtils {
    public static String getRequiredParameter(ServletRequest req, String name) throws NullPointerException {
        String ret = req.getParameter(name);
        if (ret == null) {
            throw new NullPointerException("This form requires a \"" + name + "\" parameter, which was missing from the submitted request.");
        }
        return ret;
    }

    public static String getRequiredParameterValues(ServletRequest req, String name) throws NullPointerException {
        String[] values = req.getParameterValues(name);
        if (values == null) {
            throw new NullPointerException("This form requires a \"" + name + "\" parameter, which was missing from the submitted request.");
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                ret.append(",");
            }
            ret.append(values[i]);
        }
        return ret.toString();
    }

    public static String getOptionalParameter(ServletRequest req, String name, String defalt) throws NullPointerException {
        String ret = req.getParameter(name);
        if (ret == null) {
            ret = defalt;
        }
        return ret;
    }

    public static String getOptionalParameterValues(ServletRequest req, String name) throws NullPointerException {
        String[] values = req.getParameterValues(name);
        if (values == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                ret.append(",");
            }
            ret.append(values[i]);
        }
        return ret.toString();
    }

    public static String getOptionalParameter(ServletRequest req, String name) throws NullPointerException {
        return WebUtils.getOptionalParameter(req, name, "");
    }

    public static String getRequiredAttribute(PageContext page, String name, int scope) {
        Object ret = page.getAttribute(name, scope);
        if (ret == null) {
            throw new NullPointerException("This form requires a \"" + name + "\" parameter, which was missing from the submitted request.");
        }
        return ret.toString();
    }

    public static String getOptionalAttribute(PageContext page, String name, int scope) {
        Object ret = page.getAttribute(name, scope);
        if (ret == null) {
            return "";
        }
        return ret.toString();
    }

    public static boolean isValidEmailAddress(String aEmailAddress) {
        if (aEmailAddress == null) {
            return false;
        }
        String[] tokens = aEmailAddress.split("@");
        return tokens.length == 2 && tokens[0].trim().length() > 0 && tokens[1].trim().length() > 0 && tokens[1].indexOf(".") != -1;
    }

    public static String getDatasourceDisplayName(String name) {
        if (name.startsWith("db_")) {
            return name.substring(3, name.indexOf(46));
        }
        return name;
    }
}

