/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.util.Locale;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorHandlerImpl;
import org.apache.woden.internal.ErrorInfoImpl;
import org.apache.woden.internal.MessageFormatter;
import org.apache.woden.internal.util.PropertyUtils;

public class ErrorReporterImpl
implements ErrorReporter {
    protected static final String LOCALE_LANGUAGE = "org.apache.woden.locale-language";
    protected static final String ERROR_HANDLER_NAME = "org.apache.woden.error-handler-name";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "org.apache.woden.continue-after-fatal-error";
    private Locale fLocale;
    private MessageFormatter fMessageFormatter = new MessageFormatter();
    private ErrorHandler fDefaultErrorHandler = new ErrorHandlerImpl();
    private ErrorHandler fErrorHandler;

    public ErrorReporterImpl() throws WSDLException {
        String string;
        String string2 = PropertyUtils.findProperty(LOCALE_LANGUAGE);
        if (string2 != null) {
            this.fLocale = new Locale(string2);
        }
        if ((string = PropertyUtils.findProperty(ERROR_HANDLER_NAME)) != null) {
            try {
                Class<?> clazz = Class.forName(string);
                this.fErrorHandler = (ErrorHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating the customer error handler.", exception);
            }
        } else {
            this.fErrorHandler = null;
        }
    }

    public void reportError(ErrorLocator errorLocator, String string, Object[] objectArray, short s) throws WSDLException {
        this.reportError(errorLocator, string, objectArray, s, null);
    }

    public void reportError(ErrorLocator errorLocator, String string, Object[] objectArray, short s, Exception exception) throws WSDLException {
        String string2 = this.fMessageFormatter.formatMessage(this.fLocale, string, objectArray);
        this.reportError(errorLocator, string, string2, s, exception);
    }

    public void reportError(ErrorLocator errorLocator, String string, String string2, short s) throws WSDLException {
        this.reportError(errorLocator, string, string2, s, null);
    }

    public void reportError(ErrorLocator errorLocator, String string, String string2, short s, Exception exception) throws WSDLException {
        ErrorHandler errorHandler;
        ErrorInfoImpl errorInfoImpl = new ErrorInfoImpl(errorLocator, string, string2, exception);
        ErrorHandler errorHandler2 = errorHandler = this.fErrorHandler != null ? this.fErrorHandler : this.fDefaultErrorHandler;
        if (s == 1) {
            errorHandler.warning(errorInfoImpl);
        } else if (s == 2) {
            errorHandler.error(errorInfoImpl);
        } else {
            if (s == 3) {
                errorHandler.fatalError(errorInfoImpl);
                if (exception == null) {
                    throw new WSDLException("INVALID_WSDL", "Fatal WSDL error:\n" + ((Object)errorInfoImpl).toString());
                }
                if (exception instanceof WSDLException) {
                    throw (WSDLException)exception;
                }
                throw new WSDLException("OTHER_ERROR", "Fatal error.", exception);
            }
            throw new IllegalArgumentException("Invalid severity: " + s);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler != null ? this.fErrorHandler : this.fDefaultErrorHandler;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public String getFormattedMessage(String string, Object[] objectArray) {
        String string2 = this.fMessageFormatter.formatMessage(this.fLocale, string, objectArray);
        return string2;
    }
}

