/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.ErrorReporterImpl;
import org.apache.woden.internal.util.dom.QNameUtils;
import org.apache.woden.internal.util.dom.XPathUtils;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String emptyString = "";

    public static List getAttributes(Element element) {
        String string = null;
        Vector<Node> vector = new Vector<Node>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string2 = namedNodeMap.item(i).getNodeName();
            string = namedNodeMap.item(i).getPrefix();
            if (ATTR_XMLNS.equals(string2) || ATTR_XMLNS.equals(string)) continue;
            vector.add(namedNodeMap.item(i));
        }
        return vector;
    }

    public static String getAttribute(Element element, String string) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public static String getAttribute(Element element, String string, List list) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
            list.remove(attr);
        }
        return string2;
    }

    public static String getAttributeNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue();
        }
        return string3;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Element getFirstChildElement(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element element, String string, String string2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !string2.equals(DOMUtils.getAttribute((Element)node, string))) continue;
            return (Element)node;
        }
        return null;
    }

    public static int countKids(Element element, short s) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != s) continue;
            ++n;
        }
        return n;
    }

    public static String getNamespaceURIFromPrefix(Node node, String string) {
        short s = node.getNodeType();
        Node node2 = null;
        switch (s) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string2;
            Element element = (Element)node2;
            String string3 = string2 = string == null ? DOMUtils.getAttribute(element, ATTR_XMLNS) : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string);
            if (string2 != null) {
                return string2;
            }
            node2 = element.getParentNode();
        }
        return null;
    }

    public static QName getQName(String string, Element element) throws WSDLException {
        int n = string.indexOf(58);
        String string2 = n != -1 ? string.substring(0, n) : null;
        String string3 = string.substring(n + 1);
        String string4 = DOMUtils.getNamespaceURIFromPrefix(element, string2);
        if (string4 != null) {
            return new QName(string4, string3, string2 != null ? string2 : emptyString);
        }
        String string5 = string2 == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        WSDLException wSDLException = new WSDLException(string5, "Unable to determine namespace of '" + string + "'.");
        wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
        throw wSDLException;
    }

    public static QName getQName(String string, Element element, DescriptionElement descriptionElement) throws WSDLException {
        int n = string.indexOf(58);
        String string2 = n != -1 ? string.substring(0, n) : null;
        String string3 = string.substring(n + 1);
        String string4 = DOMUtils.getNamespaceURIFromPrefix(element, string2);
        if (string4 != null) {
            DOMUtils.registerUniquePrefix(string2, string4, descriptionElement);
            return new QName(string4, string3, string2 != null ? string2 : emptyString);
        }
        String string5 = string2 == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        WSDLException wSDLException = new WSDLException(string5, "Unable to determine namespace of '" + string + "'.");
        wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
        throw wSDLException;
    }

    public static void registerUniquePrefix(String string, String string2, DescriptionElement descriptionElement) throws WSDLException {
        String string3;
        URI uRI = descriptionElement.getNamespace(string);
        String string4 = string3 = uRI != null ? uRI.toString() : null;
        if (string3 != null && string3.equals(string2)) {
            return;
        }
        while (string3 != null && !string3.equals(string2)) {
            uRI = descriptionElement.getNamespace(string = string + "_");
            string3 = uRI != null ? uRI.toString() : null;
        }
        URI uRI2 = null;
        try {
            uRI2 = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            new ErrorReporterImpl().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{string2}, (short)2, (Exception)uRISyntaxException);
        }
        descriptionElement.addNamespace(string, uRI2);
    }

    public static void throwWSDLException(Element element) throws WSDLException {
        String string = QNameUtils.newQName(element).toString();
        WSDLException wSDLException = new WSDLException("INVALID_WSDL", "Encountered unexpected element '" + string + "'.");
        wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
        throw wSDLException;
    }

    public static void throwWSDLException(Element element, List list) throws WSDLException {
        Object object;
        String string = QNameUtils.newQName(element).toString();
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = QNameUtils.newQName((Attr)listIterator.next()).toString();
            stringBuffer.append((String)object);
            stringBuffer.append(listIterator.hasNext() ? " " : emptyString);
        }
        object = new WSDLException("INVALID_WSDL", "Element '" + string + "' contained unexpected attributes: '" + stringBuffer.toString() + "'");
        ((WSDLException)object).setLocation(XPathUtils.getXPathExprFromNode(element));
        throw object;
    }
}

