/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.xml.IntOrTokenAttr;
import org.w3c.dom.Element;

public class IntOrTokenAnyAttrImpl
extends XMLAttrImpl
implements IntOrTokenAttr {
    public boolean isInt() {
        return this.fContent instanceof Integer;
    }

    public boolean isToken() {
        return !this.isInt() && this.isValid();
    }

    public Integer getInt() {
        if (this.isInt()) {
            return (Integer)this.fContent;
        }
        return null;
    }

    public String getToken() {
        if (!this.isInt() && this.isValid()) {
            return (String)this.fContent;
        }
        return null;
    }

    protected Object convert(Element element, String string) throws WSDLException {
        if ("#any".equals(string)) {
            return string;
        }
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setValid(false);
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL512", new Object[]{string}, (short)2, (Exception)numberFormatException);
        }
        return n;
    }
}

