/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.impl.ChromosomePool;

public class Chromosome
implements Comparable,
Cloneable,
Serializable {
    protected transient Configuration m_activeConfiguration = null;
    protected Gene[] m_genes = null;
    protected boolean m_isSelectedForNextGeneration = false;
    protected int m_fitnessValue = -1;
    private int m_hashCode = 0;

    public Chromosome(Gene gene, int n) {
        if (gene == null) {
            throw new IllegalArgumentException("Sample Gene cannot be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Chromosome size must be positive.");
        }
        this.m_genes = new Gene[n];
        int n2 = 0;
        while (n2 < this.m_genes.length) {
            this.m_genes[n2] = gene.newGene(null);
            ++n2;
        }
        this.m_activeConfiguration = null;
    }

    public Chromosome(Gene[] geneArray) {
        if (geneArray == null) {
            throw new IllegalArgumentException("The given array of genes cannot be null.");
        }
        int n = 0;
        while (n < geneArray.length) {
            if (geneArray[n] == null) {
                throw new IllegalArgumentException("The gene at index " + n + " in the given array of " + "genes was found to be null. No genes in the array " + "may be null.");
            }
            ++n;
        }
        this.m_genes = geneArray;
        this.m_activeConfiguration = null;
    }

    public Chromosome(Configuration configuration, Gene[] geneArray) throws InvalidConfigurationException {
        if (geneArray == null) {
            throw new IllegalArgumentException("The given array of genes cannot be null.");
        }
        int n = 0;
        while (n < geneArray.length) {
            if (geneArray[n] == null) {
                throw new IllegalArgumentException("The gene at index " + n + " in the given array of " + "genes was found to be null. No genes in the array " + "may be null.");
            }
            ++n;
        }
        if (configuration == null) {
            throw new InvalidConfigurationException("Configuration instance must not be null");
        }
        configuration.lockSettings();
        this.m_activeConfiguration = configuration;
        this.m_genes = geneArray;
    }

    public void setActiveConfiguration(Configuration configuration) throws InvalidConfigurationException {
        if (this.m_activeConfiguration == null) {
            if (configuration == null) {
                throw new InvalidConfigurationException("The given Configuration object may not be null.");
            }
            configuration.lockSettings();
            this.m_activeConfiguration = configuration;
        }
    }

    public synchronized Object clone() {
        Gene[] geneArray;
        if (this.m_activeConfiguration == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the clone() method.");
        }
        ChromosomePool chromosomePool = this.m_activeConfiguration.getChromosomePool();
        if (chromosomePool != null && (geneArray = chromosomePool.acquireChromosome()) != null) {
            Gene[] geneArray2 = geneArray.getGenes();
            int n = 0;
            while (n < geneArray2.length) {
                geneArray2[n].setAllele(this.m_genes[n].getAllele());
                ++n;
            }
            return geneArray;
        }
        geneArray = new Gene[this.m_genes.length];
        int n = 0;
        while (n < geneArray.length) {
            geneArray[n] = this.m_genes[n].newGene(this.m_activeConfiguration);
            geneArray[n].setAllele(this.m_genes[n].getAllele());
            ++n;
        }
        try {
            return new Chromosome(this.m_activeConfiguration, geneArray);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            throw new RuntimeException("Fatal Error: clone method produced an InvalidConfigurationException. This should never happen.Please report this as a bug to the JGAP team.");
        }
    }

    public synchronized Gene getGene(int n) {
        return this.m_genes[n];
    }

    public synchronized Gene[] getGenes() {
        return this.m_genes;
    }

    public int size() {
        return this.m_genes.length;
    }

    public int getFitnessValue() {
        if (this.m_fitnessValue < 0) {
            if (this.m_activeConfiguration == null) {
                throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the getFitnessValue() method.");
            }
            FitnessFunction fitnessFunction = this.m_activeConfiguration.getFitnessFunction();
            if (fitnessFunction != null) {
                this.m_fitnessValue = fitnessFunction.getFitnessValue(this);
            }
        }
        return this.m_fitnessValue;
    }

    public void setFitnessValue(int n) {
        if (n > 0) {
            this.m_fitnessValue = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        int n = 0;
        while (n < this.m_genes.length - 1) {
            stringBuffer.append(this.m_genes[n].toString());
            stringBuffer.append(", ");
            ++n;
        }
        stringBuffer.append(this.m_genes[this.m_genes.length - 1].toString());
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public static Chromosome randomInitialChromosome(Configuration configuration) throws InvalidConfigurationException {
        Chromosome chromosome;
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration instance must not be null");
        }
        configuration.lockSettings();
        ChromosomePool chromosomePool = configuration.getChromosomePool();
        if (chromosomePool != null && (chromosome = chromosomePool.acquireChromosome()) != null) {
            Gene[] geneArray = chromosome.getGenes();
            RandomGenerator randomGenerator = configuration.getRandomGenerator();
            int n = 0;
            while (n < geneArray.length) {
                geneArray[n].setToRandomValue(randomGenerator);
                ++n;
            }
            return chromosome;
        }
        chromosome = configuration.getSampleChromosome();
        Gene[] geneArray = chromosome.getGenes();
        Gene[] geneArray2 = new Gene[geneArray.length];
        RandomGenerator randomGenerator = configuration.getRandomGenerator();
        int n = 0;
        while (n < geneArray2.length) {
            geneArray2[n] = geneArray[n].newGene(configuration);
            geneArray2[n].setToRandomValue(randomGenerator);
            ++n;
        }
        return new Chromosome(configuration, geneArray2);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            int n = 0;
            while (n < this.m_genes.length) {
                this.m_hashCode ^= this.m_genes[n].hashCode();
                ++n;
            }
        }
        return this.m_hashCode;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        Chromosome chromosome = (Chromosome)object;
        Gene[] geneArray = chromosome.m_genes;
        if (geneArray.length != this.m_genes.length) {
            return this.m_genes.length - geneArray.length;
        }
        int n = 0;
        while (n < this.m_genes.length) {
            int n2 = this.m_genes[n].compareTo(geneArray[n]);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public void setIsSelectedForNextGeneration(boolean bl) {
        this.m_isSelectedForNextGeneration = bl;
    }

    public boolean isSelectedForNextGeneration() {
        return this.m_isSelectedForNextGeneration;
    }

    public void cleanup() {
        this.m_fitnessValue = -1;
        this.m_hashCode = 0;
        this.m_isSelectedForNextGeneration = false;
        if (this.m_activeConfiguration == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the cleanup() method.");
        }
        ChromosomePool chromosomePool = this.m_activeConfiguration.getChromosomePool();
        if (chromosomePool != null) {
            chromosomePool.releaseChromosome(this);
        } else {
            int n = 0;
            while (n < this.m_genes.length) {
                this.m_genes[n].cleanup();
                ++n;
            }
        }
    }
}

