/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.RandomGenerator;
import org.jgap.event.EventManager;
import org.jgap.impl.ChromosomePool;

public class Configuration {
    private FitnessFunction m_objectiveFunction = null;
    private BulkFitnessFunction m_bulkObjectiveFunction = null;
    private NaturalSelector m_populationSelector = null;
    private Chromosome m_sampleChromosome = null;
    private RandomGenerator m_randomGenerator = null;
    private EventManager m_eventManager = null;
    private ChromosomePool m_chromosomePool = null;
    private List m_geneticOperators = new ArrayList();
    private int m_chromosomeSize = 0;
    private int m_populationSize = 0;
    private boolean m_settingsLocked = false;

    public synchronized void setFitnessFunction(FitnessFunction fitnessFunction) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (fitnessFunction == null) {
            throw new InvalidConfigurationException("The FitnessFunction instance may not be null.");
        }
        if (this.m_bulkObjectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.m_objectiveFunction = fitnessFunction;
    }

    public FitnessFunction getFitnessFunction() {
        return this.m_objectiveFunction;
    }

    public synchronized void setBulkFitnessFunction(BulkFitnessFunction bulkFitnessFunction) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (bulkFitnessFunction == null) {
            throw new InvalidConfigurationException("The BulkFitnessFunction instance may not be null.");
        }
        if (this.m_objectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.m_bulkObjectiveFunction = bulkFitnessFunction;
    }

    public BulkFitnessFunction getBulkFitnessFunction() {
        return this.m_bulkObjectiveFunction;
    }

    public void setSampleChromosome(Chromosome chromosome) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (chromosome == null) {
            throw new InvalidConfigurationException("The sample Chromosome instance may not be null.");
        }
        this.m_sampleChromosome = chromosome;
        this.m_chromosomeSize = this.m_sampleChromosome.size();
    }

    public Chromosome getSampleChromosome() {
        return this.m_sampleChromosome;
    }

    public int getChromosomeSize() {
        return this.m_chromosomeSize;
    }

    public synchronized void setNaturalSelector(NaturalSelector naturalSelector) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (naturalSelector == null) {
            throw new InvalidConfigurationException("The Natural Selector instance may not be null.");
        }
        this.m_populationSelector = naturalSelector;
    }

    public NaturalSelector getNaturalSelector() {
        return this.m_populationSelector;
    }

    public synchronized void setRandomGenerator(RandomGenerator randomGenerator) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (randomGenerator == null) {
            throw new InvalidConfigurationException("The RandomGenerator instance may not be null.");
        }
        this.m_randomGenerator = randomGenerator;
    }

    public RandomGenerator getRandomGenerator() {
        return this.m_randomGenerator;
    }

    public synchronized void addGeneticOperator(GeneticOperator geneticOperator) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (geneticOperator == null) {
            throw new InvalidConfigurationException("The GeneticOperator instance may not be null.");
        }
        this.m_geneticOperators.add(geneticOperator);
    }

    public List getGeneticOperators() {
        return this.m_geneticOperators;
    }

    public synchronized void setPopulationSize(int n) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (n < 1) {
            throw new InvalidConfigurationException("The population size must be positive.");
        }
        this.m_populationSize = n;
    }

    public int getPopulationSize() {
        return this.m_populationSize;
    }

    public void setEventManager(EventManager eventManager) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (eventManager == null) {
            throw new InvalidConfigurationException("The EventManager instance may not be null.");
        }
        this.m_eventManager = eventManager;
    }

    public EventManager getEventManager() {
        return this.m_eventManager;
    }

    public void setChromosomePool(ChromosomePool chromosomePool) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        this.m_chromosomePool = chromosomePool;
    }

    public ChromosomePool getChromosomePool() {
        return this.m_chromosomePool;
    }

    public synchronized void lockSettings() throws InvalidConfigurationException {
        if (!this.m_settingsLocked) {
            this.verifyStateIsValid();
            this.m_geneticOperators = Collections.unmodifiableList(this.m_geneticOperators);
            this.m_settingsLocked = true;
        }
    }

    public boolean isLocked() {
        return this.m_settingsLocked;
    }

    public synchronized void verifyStateIsValid() throws InvalidConfigurationException {
        if (this.m_objectiveFunction == null && this.m_bulkObjectiveFunction == null) {
            throw new InvalidConfigurationException("A desired fitness function or bulk fitness function must be specified in the active configuration.");
        }
        if (this.m_sampleChromosome == null) {
            throw new InvalidConfigurationException("A sample instance of the desired Chromosome setup must be specified in the active configuration.");
        }
        if (this.m_populationSelector == null) {
            throw new InvalidConfigurationException("A desired natural selector must be specified in the active configuration.");
        }
        if (this.m_randomGenerator == null) {
            throw new InvalidConfigurationException("A desired random number generator must be specified in the active configuration.");
        }
        if (this.m_eventManager == null) {
            throw new InvalidConfigurationException("A desired event manager must be specified in the active configuration.");
        }
        if (this.m_geneticOperators.isEmpty()) {
            throw new InvalidConfigurationException("At least one genetic operator must be specified in the configuration.");
        }
        if (this.m_chromosomeSize <= 0) {
            throw new InvalidConfigurationException("A chromosome size greater than zero must be specified in the active configuration.");
        }
        if (this.m_populationSize <= 0) {
            throw new InvalidConfigurationException("A genotype size greater than zero must be specified in the active configuration.");
        }
        Gene[] geneArray = this.m_sampleChromosome.getGenes();
        int n = 0;
        while (n < geneArray.length) {
            Gene gene = geneArray[n].newGene(this);
            gene.setAllele(geneArray[n].getAllele());
            if (!gene.equals(geneArray[n])) {
                throw new InvalidConfigurationException("The sample Gene at gene position (locus) " + n + " does not appear to have a working equals() method. " + "When tested, the method returned false when comparing " + "the sample gene with a gene of the same type and " + "possessing the same value (allele).");
            }
            ++n;
        }
    }

    protected void verifyChangesAllowed() throws InvalidConfigurationException {
        if (this.m_settingsLocked) {
            throw new InvalidConfigurationException("This Configuration object is locked. Settings may not be altered.");
        }
    }
}

